/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.outbound.schema;

import com.tridiumx.jsonToolkit.outbound.schema.BIJsonProperty;
import com.tridiumx.jsonToolkit.outbound.schema.BIJsonSchemaMember;
import com.tridiumx.jsonToolkit.outbound.schema.BJsonSchema;
import com.tridiumx.jsonToolkit.outbound.schema.postprocess.BIPostProcessor;
import com.tridiumx.jsonToolkit.outbound.schema.support.BJsonSchemaService;
import com.tridiumx.jsonToolkit.outbound.schema.support.BSchemaEvent;
import com.tridiumx.jsonToolkit.outbound.schema.support.JsonSchemaConfigException;
import com.tridiumx.jsonToolkit.outbound.schema.support.JsonSchemaUtil;
import com.tridiumx.jsonToolkit.util.ParentLegal;
import java.util.Date;
import java.util.logging.Level;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;

@NiagaraType
@NiagaraAction(name="handleSchemaEvent", parameterType="BSchemaEvent", defaultValue="BSchemaEvent.DEFAULT", flags=2068)
public abstract class BJsonSchemaMember
extends BComponent
implements BIJsonSchemaMember {
    @Generated
    public static final Action handleSchemaEvent = BJsonSchemaMember.newAction((int)2068, (BValue)BSchemaEvent.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BJsonSchemaMember.class);
    private Date lastSchemaEventTime = new Date();
    private BJsonSchema mySchema;

    @Generated
    public void handleSchemaEvent(BSchemaEvent parameter) {
        this.invoke(handleSchemaEvent, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (this.isRunning()) {
            this.linkTo(this.getSchema(), (Slot)BJsonSchema.schemaModified, (Slot)handleSchemaEvent);
        }
    }

    public void changed(Property property, Context context) {
        if (this.isRunning() && "displayNames".equals(property.getName())) {
            this.getSchema().fireSchemaModified(BSchemaEvent.displayNameChanged);
        }
    }

    public void added(Property property, Context context) {
        super.added(property, context);
        if ("displayNames".equals(property.getName())) {
            this.getSchema().fireSchemaModified(BSchemaEvent.displayNameChanged);
        }
    }

    public boolean isChildLegal(BComponent child) {
        return child instanceof BIJsonSchemaMember && !(this instanceof BIJsonProperty);
    }

    public boolean isParentLegal(BComponent parent) {
        return ParentLegal.is(this.getType(), parent.getType(), BJsonSchema.TYPE, TYPE);
    }

    public BIcon getIcon() {
        return BIcon.std((String)"braces.png");
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        if (this.isRunning()) {
            return BJsonSchemaService.post(this, action, argument, cx);
        }
        return null;
    }

    public void renamed(Property property, String oldName, Context context) {
        if (property.getType().is(BIJsonSchemaMember.TYPE)) {
            this.getSchema().fireSchemaModified(BSchemaEvent.nameChanged);
        }
    }

    public String getSchemaPath() {
        return this.getSchemaPath(null);
    }

    private String getSchemaPath(String pathAlreadyCreated) {
        if (!this.isRunning()) {
            return "unmounted";
        }
        if (this instanceof BJsonSchema) {
            return this.getName() + '/' + pathAlreadyCreated;
        }
        if (this.getParent() instanceof BJsonSchemaMember) {
            return ((BJsonSchemaMember)this.getParent()).getSchemaPath(this.getName() + (pathAlreadyCreated == null ? "" : '/' + pathAlreadyCreated));
        }
        throw new JsonSchemaConfigException(this.getParent().getType() + " should not be parent of: " + this.getType());
    }

    void postProcessors(Exception e) {
        this.postProcessors(this, e);
    }

    void postProcessors(BComponent component, Exception e) {
        for (BIPostProcessor bIPostProcessor : (BIPostProcessor[])component.getChildren(BIPostProcessor.class)) {
            bIPostProcessor.postProcess(this.getSchema(), e);
        }
        for (BIPostProcessor bIPostProcessor : component.getChildComponents()) {
            this.postProcessors((BComponent)bIPostProcessor, e);
        }
    }

    @Override
    public BJsonSchema getSchema() {
        if (this.mySchema != null) {
            return this.mySchema;
        }
        if (this instanceof BJsonSchema) {
            this.mySchema = (BJsonSchema)this;
        } else if (this.getParent() instanceof BIJsonSchemaMember) {
            this.mySchema = ((BIJsonSchemaMember)this.getParent()).getSchema();
        }
        if (this.mySchema != null) {
            return this.mySchema;
        }
        throw new JsonSchemaConfigException(this.getParent().getType() + " should not be parent of: " + this.getType());
    }

    public void doHandleSchemaEvent(BSchemaEvent event) {
        this.onSchemaEvent(event);
    }

    public void synchronousSchemaEvent(BSchemaEvent event) {
        for (BJsonSchemaMember child : (BJsonSchemaMember[])this.getChildren(BJsonSchemaMember.class)) {
            child.onSchemaEvent(event);
            child.synchronousSchemaEvent(event);
        }
    }

    public String schemaName() {
        return this.getSchema().getName();
    }

    void onSchemaEvent(BSchemaEvent event) {
        if (JsonSchemaUtil.logger.isLoggable(Level.FINE)) {
            JsonSchemaUtil.logger.fine(String.format("%s: %s processing schema event %s", this.getSchema().getName(), this.getName(), event.getTag()));
        }
        this.lastSchemaEventTime = new Date();
    }

    public Date getLastSchemaEventTime() {
        return this.lastSchemaEventTime;
    }
}

