/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.outbound.schema;

import com.tridium.util.PrefixLogUtil;
import com.tridiumx.jsonToolkit.outbound.schema.BJsonSchema;
import com.tridiumx.jsonToolkit.outbound.schema.BJsonSchemaMember;
import com.tridiumx.jsonToolkit.outbound.schema.config.BJsonSchemaNameSource;
import com.tridiumx.jsonToolkit.outbound.schema.relative.BRelativeJsonSchema;
import com.tridiumx.jsonToolkit.outbound.schema.subscription.SchemaBoundMemberSubscriber;
import com.tridiumx.jsonToolkit.outbound.schema.subscription.Subscription;
import com.tridiumx.jsonToolkit.outbound.schema.subscription.SubscriptionFactory;
import com.tridiumx.jsonToolkit.outbound.schema.support.BJsonSchemaService;
import com.tridiumx.jsonToolkit.outbound.schema.support.BSchemaEvent;
import com.tridiumx.jsonToolkit.outbound.schema.support.JsonSchemaNameUtil;
import com.tridiumx.jsonToolkit.outbound.schema.support.JsonSchemaSecurity;
import com.tridiumx.jsonToolkit.outbound.schema.support.JsonSchemaUtil;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="binding", type="BOrd", defaultValue="BOrd.DEFAULT", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, BString.make(\"jsonToolkit:SlotOrdFE\"))"), @Facet(value="BFacets.make(BFacets.UX_FIELD_EDITOR, BString.make(\"jsonToolkit:SlotOrdEditor\"))")}), @NiagaraProperty(name="jsonName", type="String", defaultValue="BString.DEFAULT", flags=9), @NiagaraProperty(name="jsonNameSource", type="BJsonSchemaNameSource", defaultValue="BJsonSchemaNameSource.displayName")})
public abstract class BJsonSchemaBoundMember
extends BJsonSchemaMember {
    @Generated
    public static final Property binding = BJsonSchemaBoundMember.newProperty((int)0, (BValue)BOrd.DEFAULT, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"jsonToolkit:SlotOrdFE")), (BFacets)BFacets.make((String)"uxFieldEditor", (BIDataValue)BString.make((String)"jsonToolkit:SlotOrdEditor"))));
    @Generated
    public static final Property jsonName = BJsonSchemaBoundMember.newProperty((int)9, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property jsonNameSource = BJsonSchemaBoundMember.newProperty((int)0, (BValue)BJsonSchemaNameSource.displayName, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BJsonSchemaBoundMember.class);
    private final Object subscribeMutex = new Object();
    private SchemaBoundMemberSubscriber subscriber;
    private final AtomicReference<BObject> cache = new AtomicReference();

    @Generated
    public BOrd getBinding() {
        return (BOrd)this.get(binding);
    }

    @Generated
    public void setBinding(BOrd v) {
        this.set(binding, (BValue)v, null);
    }

    @Override
    @Generated
    public String getJsonName() {
        return this.getString(jsonName);
    }

    @Generated
    public void setJsonName(String v) {
        this.setString(jsonName, v, null);
    }

    @Generated
    public BJsonSchemaNameSource getJsonNameSource() {
        return (BJsonSchemaNameSource)this.get(jsonNameSource);
    }

    @Generated
    public void setJsonNameSource(BJsonSchemaNameSource v) {
        this.set(jsonNameSource, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() {
        super.started();
        if (this.getSchema().isRelative()) {
            this.setFlags((Slot)jsonName, this.getFlags((Slot)jsonName) | 4);
        } else if (this.isRunning() && this.getSchema().getEnabled()) {
            this.updateJsonName();
            this.setupSubscriptions();
        }
    }

    public void stopped() throws Exception {
        super.stopped();
        this.endSubscriptions();
    }

    @Override
    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        BJsonSchema schema = this.getSchema();
        if ((property.equals(jsonNameSource) || property.equals(binding)) && !schema.isRelative()) {
            this.updateJsonName();
        }
        if (property.equals(binding)) {
            if (schema.isRelative()) {
                ((BRelativeJsonSchema)schema.as(BRelativeJsonSchema.class)).unregister(this);
            } else {
                this.setupSubscriptions();
            }
        }
    }

    @Override
    public BIcon getIcon() {
        return BIcon.std((String)"bracesAsterisk.png");
    }

    protected void updateJsonName() {
        String jsonName = JsonSchemaNameUtil.getJsonName(this);
        this.setJsonName(jsonName);
        this.clearCache();
    }

    public abstract List<String> getPropertiesToIncludeInJson(BComplex var1);

    @Override
    protected void onSchemaEvent(BSchemaEvent event) {
        super.onSchemaEvent(event);
        switch (event.getOrdinal()) {
            case 0: 
            case 1: 
            case 5: 
            case 6: {
                this.updateJsonName();
                break;
            }
            case 2: {
                this.setupSubscriptions();
                break;
            }
            case 3: {
                this.endSubscriptions();
                break;
            }
            case 4: {
                this.clearCache();
                break;
            }
            default: {
                PrefixLogUtil.logWithPrefix((Logger)BJsonSchemaService.log, (Level)Level.FINE, () -> String.format("%s - unhandled event type: %s", new Object[]{this.getSchemaPath(), event}), (Object)this);
            }
        }
    }

    public void updateCache(BObject value) {
        this.cache.set(value);
    }

    protected void clearCache() {
        if (this.cache.get() != null) {
            this.cache.set(null);
            PrefixLogUtil.logWithPrefix((Logger)BJsonSchemaService.log, (Level)Level.FINE, () -> String.format("%s - Cache cleared", this.getSchemaPath()), (Object)this);
        }
    }

    public boolean isBindOrdSet() {
        return this.getBinding() != null && !this.getBinding().isNull();
    }

    protected BObject getTarget() {
        boolean useCache = this.getSchema().requiresMemberSubscriptions();
        if (this.isBindOrdSet()) {
            BObject value = null;
            if (useCache) {
                value = this.cache.get();
            }
            this.getSchema().getConfig().getDebug().getMetrics().cacheResult(value);
            if (value == null) {
                PrefixLogUtil.logWithPrefix((Logger)BJsonSchemaService.log, (Level)Level.FINE, () -> "Cache miss: " + this.getSchemaPath(), (Object)this);
                OrdTarget ordTarget = this.getOrdTarget();
                if (ordTarget == null) {
                    PrefixLogUtil.logWithPrefix((Logger)BJsonSchemaService.log, (Level)Level.SEVERE, () -> String.format("Json schema member %s bound to invalid ord %s", this.getSchemaPath(), this.getBinding()), (Object)this);
                    return null;
                }
                value = this.getOrdTarget().get();
                if (useCache && value != null) {
                    this.cache.set(value);
                }
            } else {
                PrefixLogUtil.logWithPrefix((Logger)BJsonSchemaService.log, (Level)Level.FINE, () -> "Cache hit: " + this.getSchemaPath(), (Object)this);
            }
            return value;
        }
        PrefixLogUtil.logWithPrefix((Logger)BJsonSchemaService.log, (Level)Level.WARNING, () -> "Skipping Null Ord @ " + this.getSchemaPath(), (Object)this);
        return null;
    }

    public OrdTarget getOrdTarget() {
        return this.getOrdTarget(null);
    }

    public OrdTarget getOrdTarget(BObject overrideBase) {
        OrdTarget target = null;
        if (this.isBindOrdSet()) {
            try {
                target = JsonSchemaSecurity.permissionsCheck(this.getSchema(), this.getSchema().getOrdTarget(this, overrideBase));
                if (this.isRunning()) {
                    String targetOrd = target.toString();
                    PrefixLogUtil.logWithPrefix((Logger)BJsonSchemaService.log, (Level)Level.FINE, () -> String.format("Json schema member [%s] resolved ord to [%s] with base [%s]", this.getSchemaPath(), targetOrd, JsonSchemaUtil.currentBasePath(this.getSchema())), (Object)this);
                }
            }
            catch (UnresolvedException ue) {
                PrefixLogUtil.logWithPrefix((Logger)BJsonSchemaService.log, (Level)Level.WARNING, () -> String.format("Json schema member [%s] INVALID ord [%s] with base [%s], [%s]", this.getSchemaPath(), this.getBinding(), JsonSchemaUtil.currentBasePath(this.getSchema()), ue.getMessage()), (Object)this);
                PrefixLogUtil.logWithPrefix((Logger)BJsonSchemaService.log, (Level)Level.FINEST, (String)"", (Throwable)ue, (Object)this);
                this.getSchema().getConfig().getDebug().getMetrics().resolveError();
            }
        } else {
            PrefixLogUtil.logWithPrefix((Logger)BJsonSchemaService.log, (Level)Level.WARNING, () -> String.format("Json schema member [%s] Skipping Null Ord", this.getSchemaPath()), (Object)this);
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setupSubscriptions() {
        if (!this.getSchema().getEnabled() || !this.getSchema().requiresMemberSubscriptions()) {
            return;
        }
        Object object = this.subscribeMutex;
        synchronized (object) {
            OrdTarget ordTarget;
            PrefixLogUtil.logWithPrefix((Logger)BJsonSchemaService.log, (Level)Level.FINE, () -> String.format("%s - setting up subscriptions", this.getSchemaPath()), (Object)this);
            if (this.subscriber != null) {
                this.endSubscriptions();
            }
            if ((ordTarget = this.getOrdTarget()) == null) {
                PrefixLogUtil.logWithPrefix((Logger)BJsonSchemaService.log, (Level)Level.WARNING, () -> String.format("%s - Invalid target ord %s, in  cannot subscribe", this.getSchemaPath(), this.getBinding()), (Object)this);
                return;
            }
            BObject target = ordTarget.get();
            this.updateCache(target);
            BComponent subscriptionTarget = SubscriptionFactory.getSubscriptionTarget(ordTarget, this);
            Subscription subscription = SubscriptionFactory.makeSubscription(this, ordTarget);
            PrefixLogUtil.logWithPrefix((Logger)BJsonSchemaService.log, (Level)Level.FINE, () -> String.format("new subscription for [%s], target type [%s], target [%s]", this.getSchemaPath(), target.getType(), subscriptionTarget), (Object)this);
            this.subscriber = new SchemaBoundMemberSubscriber(this, subscription, event -> this.handleSubscriptionEvent(subscription, event));
            this.subscriber.subscribeTo(subscriptionTarget);
        }
    }

    protected void handleSubscriptionEvent(Subscription subscription, BComponentEvent event) {
        if (event.getId() == 13 || event.getId() == 20) {
            this.subscriber.unsubscribe(event.getSourceComponent());
        } else if (this.getSchema().requiresMemberSubscriptions()) {
            this.updateCacheWithLiveValue(subscription, event);
            this.getSchema().requestGenerateJson(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endSubscriptions() {
        Object object = this.subscribeMutex;
        synchronized (object) {
            if (this.subscriber != null) {
                this.subscriber.unsubscribeAll();
                PrefixLogUtil.logWithPrefix((Logger)BJsonSchemaService.log, (Level)Level.FINE, () -> String.format("%s - unsubscribing", this.getSchemaPath()), (Object)this);
                this.subscriber = null;
            }
            if (this.getSchema().isRelative()) {
                ((BRelativeJsonSchema)this.getSchema().as(BRelativeJsonSchema.class)).unregister(this);
            }
        }
    }

    protected void updateCacheWithLiveValue(Subscription subscription, BComponentEvent event) {
        BValue valueToCache = subscription.getLiveBindingValue(this, event);
        if (valueToCache != null) {
            this.updateCache((BObject)valueToCache);
        } else {
            PrefixLogUtil.logWithPrefix((Logger)BJsonSchemaService.log, (Level)Level.WARNING, () -> String.format("SUBS: [%s] failed to find value", this.getSchemaPath()), (Object)this);
        }
    }
}

