/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.inbound.selector;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONTokener;
import com.tridium.json.JSONUtil;
import com.tridium.util.EngineCycleUtil;
import com.tridiumx.jsonToolkit.inbound.routing.RoutingFailedException;
import com.tridiumx.jsonToolkit.inbound.selector.BJsonStringSelector;
import com.tridiumx.jsonToolkit.util.BEngineCycleMessageQueue;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.QueueFullException;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="numericOut", type="double", defaultValue="BDouble.DEFAULT", flags=1), @NiagaraProperty(name="booleanOut", type="boolean", defaultValue="BBoolean.DEFAULT", flags=1), @NiagaraProperty(name="defaultBetweenItems", type="boolean", defaultValue="false"), @NiagaraProperty(name="queue", type="BEngineCycleMessageQueue", defaultValue="new BEngineCycleMessageQueue()")})
@NiagaraAction(name="selectValue", parameterType="BString", defaultValue="BString.DEFAULT", flags=4)
public class BJsonArrayForEachSelector
extends BJsonStringSelector {
    @Generated
    public static final Property numericOut = BJsonArrayForEachSelector.newProperty((int)1, (BValue)BDouble.DEFAULT, null);
    @Generated
    public static final Property booleanOut = BJsonArrayForEachSelector.newProperty((int)1, (BValue)BBoolean.DEFAULT, null);
    @Generated
    public static final Property defaultBetweenItems = BJsonArrayForEachSelector.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property queue = BJsonArrayForEachSelector.newProperty((int)0, (BValue)new BEngineCycleMessageQueue(), null);
    @Generated
    public static final Action selectValue = BJsonArrayForEachSelector.newAction((int)4, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BJsonArrayForEachSelector.class);
    private static final List<Property> propertiesToClear = Arrays.asList(out, numericOut, booleanOut);
    private static final String NULL_JSON_LITERAL = "jsonNullPlaceholder";

    @Generated
    public double getNumericOut() {
        return this.getDouble(numericOut);
    }

    @Generated
    public void setNumericOut(double v) {
        this.setDouble(numericOut, v, null);
    }

    @Generated
    public boolean getBooleanOut() {
        return this.getBoolean(booleanOut);
    }

    @Generated
    public void setBooleanOut(boolean v) {
        this.setBoolean(booleanOut, v, null);
    }

    @Generated
    public boolean getDefaultBetweenItems() {
        return this.getBoolean(defaultBetweenItems);
    }

    @Generated
    public void setDefaultBetweenItems(boolean v) {
        this.setBoolean(defaultBetweenItems, v, null);
    }

    @Generated
    public BEngineCycleMessageQueue getQueue() {
        return (BEngineCycleMessageQueue)this.get(queue);
    }

    @Generated
    public void setQueue(BEngineCycleMessageQueue v) {
        this.set(queue, (BValue)v, null);
    }

    @Generated
    public void selectValue(BString parameter) {
        this.invoke(selectValue, (BValue)parameter, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.linkTo(this.getQueue(), (Slot)BEngineCycleMessageQueue.out, (Slot)selectValue);
    }

    @Override
    protected void routeValue(BString message, Context cx) throws RoutingFailedException {
        Object json = new JSONTokener(message.getString()).nextValue();
        if (json instanceof JSONArray) {
            JSONArray array = (JSONArray)json;
            if (array.length() == 0) {
                throw new RoutingFailedException("No values routed, empty JSON array");
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine(String.format("%s attempting to queue %s new array items", this.getSlotPath(), array.length()));
            }
            for (int i = 0; i < array.length(); ++i) {
                if (array.isNull(i)) {
                    this.enqueueArrayItem(NULL_JSON_LITERAL);
                    continue;
                }
                this.enqueueArrayItem(JSONUtil.getString((JSONArray)array, (int)i));
            }
        } else {
            throw new RoutingFailedException(this.getClass().getSimpleName() + " only supports JSON array input");
        }
    }

    private void enqueueArrayItem(String valueToQueue) throws RoutingFailedException {
        try {
            this.getQueue().doEnqueue(BString.make((String)valueToQueue));
        }
        catch (QueueFullException e) {
            throw new RoutingFailedException(valueToQueue, "Failed to queue array item", e);
        }
    }

    public void doSelectValue(BString value) throws Exception {
        if (this.getDefaultBetweenItems()) {
            this.setDefaults();
            EngineCycleUtil.runOnFutureEngineCycle(() -> this.setNewValue(value.getString()));
        } else {
            this.setNewValue(value.getString());
        }
    }

    private void setNewValue(String value) {
        block2: {
            this.setOutValue(NULL_JSON_LITERAL.equals(value) ? null : value);
            try {
                this.setNumericOut(Double.parseDouble(value));
            }
            catch (NumberFormatException e) {
                if (!log.isLoggable(Level.FINEST)) break block2;
                log.finest(this.getClass().getSimpleName() + " not passing value to numericOut: " + value);
            }
        }
        this.setBooleanOut(Boolean.parseBoolean(value));
    }

    private void setDefaults() {
        propertiesToClear.forEach(property -> this.set((Property)property, property.getDefaultValue()));
    }

    @Override
    protected List<Property> implOutputsToClear() {
        return propertiesToClear;
    }
}

