/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.inbound.routing;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridiumx.jsonToolkit.inbound.routing.BJsonRouter;
import com.tridiumx.jsonToolkit.inbound.routing.RoutingFailedException;
import com.tridiumx.jsonToolkit.inbound.routing.slot.BAddSlotTypeEnum;
import com.tridiumx.jsonToolkit.outbound.schema.support.BJsonSchemaService;
import com.tridiumx.jsonToolkit.outbound.schema.support.JsonSchemaUtil;
import com.tridiumx.jsonToolkit.outbound.schema.support.UnsupportedConversionTypeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="defaultMissing", type="boolean", defaultValue="true")
public class BJsonDemuxRouter
extends BJsonRouter {
    @Generated
    public static final Property defaultMissing = BJsonDemuxRouter.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BJsonDemuxRouter.class);
    private static final Logger log = BJsonSchemaService.childLogger(TYPE.getTypeName());

    @Generated
    public boolean getDefaultMissing() {
        return this.getBoolean(defaultMissing);
    }

    @Generated
    public void setDefaultMissing(boolean v) {
        this.setBoolean(defaultMissing, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected void routeValue(BString message, Context cx) throws RoutingFailedException {
        String in = message.toString();
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.getName() + " routing message " + this.loggableJson(message.toString()));
        }
        if (this.isRunning() && this.getEnabled()) {
            Property[] props = this.getDynamicPropertiesArray();
            ArrayList knownKeys = new ArrayList(props.length);
            Arrays.stream(props).filter(BAddSlotTypeEnum::isSupportedType).forEach(prop -> knownKeys.add(prop.getName()));
            if (knownKeys.isEmpty() && !this.getLearnMode()) {
                throw new RoutingFailedException(in, this.getName() + " demux requires added slots to extract data when not in learn mode");
            }
            Map values = this.lookupKeyValues(in);
            for (Map.Entry value : values.entrySet()) {
                String jsonKey = (String)value.getKey();
                Object jsonValue = value.getValue();
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Parsing " + jsonKey + " : " + jsonValue);
                }
                boolean isNull = jsonValue == null || jsonValue == JSONObject.NULL;
                try {
                    boolean statusValue;
                    Property property;
                    if (jsonValue instanceof JSONObject || jsonValue instanceof JSONArray) {
                        jsonValue = jsonValue.toString();
                    }
                    if ((property = this.getProperty(SlotPath.escape((String)jsonKey))) == null && (!this.getLearnMode() || isNull)) continue;
                    BValue existingValueForProperty = property == null ? null : this.get(property);
                    boolean bl = statusValue = property != null && property.getType().is(BStatusValue.TYPE);
                    if (isNull && existingValueForProperty != null && statusValue) {
                        this.nullifyStatusValue(property);
                    } else {
                        BStatusValue bValue = statusValue ? JsonSchemaUtil.toStatusValue(jsonValue) : JsonSchemaUtil.toBValue(jsonValue);
                        this.setNewValueOnSlot(message.toString(), SlotPath.escape((String)jsonKey), (BValue)bValue);
                    }
                    knownKeys.remove(SlotPath.escape((String)jsonKey));
                }
                catch (UnsupportedConversionTypeException unsup) {
                    throw new RoutingFailedException(in, "Could not convert to BValue k:" + jsonKey + " v:" + jsonValue, unsup);
                }
            }
            if (!knownKeys.isEmpty() && this.getDefaultMissing()) {
                knownKeys.forEach(knownKey -> {
                    Property property = this.getProperty((String)knownKey);
                    this.resetDynamicProperty(this, property);
                    this.nullifyStatusValue(property);
                });
            }
        }
    }

    private void nullifyStatusValue(Property property) {
        BValue value = this.get(property);
        if (value instanceof BStatusValue) {
            ((BStatusValue)value.as(BStatusValue.class)).setStatusNull(true);
        }
    }
}

