/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.inbound.routing;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONTokener;
import com.tridiumx.jsonToolkit.inbound.BJsonInbound;
import com.tridiumx.jsonToolkit.inbound.routing.BJsonRouter;
import com.tridiumx.jsonToolkit.inbound.routing.RoutingFailedException;
import com.tridiumx.jsonToolkit.outbound.schema.support.JsonSchemaUtil;
import com.tridiumx.jsonToolkit.outbound.schema.support.UnsupportedConversionTypeException;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconModule;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="maxSlots", type="int", defaultValue="50", facets={@Facet(value="BFacets.make(BFacets.MIN, 1)")}), @NiagaraProperty(name="createStatusValues", type="boolean", defaultValue="false"), @NiagaraProperty(name="clearOutputsOnEachMessage", type="boolean", defaultValue="true"), @NiagaraProperty(name="path", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="createDate", type="boolean", defaultValue="false"), @NiagaraProperty(name="dateFormat", type="BString", defaultValue="yyyy-MM-dd HH:mm:ss.SSSZ", flags=4), @NiagaraProperty(name="learnMode", type="boolean", defaultValue="true", flags=5, override=true)})
public class BJsonArrayRouter
extends BJsonRouter {
    @Generated
    public static final Property maxSlots = BJsonArrayRouter.newProperty((int)0, (int)50, (BFacets)BFacets.make((String)"min", (int)1));
    @Generated
    public static final Property createStatusValues = BJsonArrayRouter.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property clearOutputsOnEachMessage = BJsonArrayRouter.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property path = BJsonArrayRouter.newProperty((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property createDate = BJsonArrayRouter.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property dateFormat = BJsonArrayRouter.newProperty((int)4, (String)"yyyy-MM-dd HH:mm:ss.SSSZ", null);
    @Generated
    public static final Property learnMode = BJsonArrayRouter.newProperty((int)5, (boolean)true, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BJsonArrayRouter.class);
    protected SimpleDateFormat userInputDate;
    private static final String SLOT_NAME_PREFIX = "index";
    protected static final Logger LOGGER = BJsonInbound.LOG;
    private static final LexiconModule LEX = LexiconModule.make(BJsonArrayRouter.class);

    @Generated
    public int getMaxSlots() {
        return this.getInt(maxSlots);
    }

    @Generated
    public void setMaxSlots(int v) {
        this.setInt(maxSlots, v, null);
    }

    @Generated
    public boolean getCreateStatusValues() {
        return this.getBoolean(createStatusValues);
    }

    @Generated
    public void setCreateStatusValues(boolean v) {
        this.setBoolean(createStatusValues, v, null);
    }

    @Generated
    public boolean getClearOutputsOnEachMessage() {
        return this.getBoolean(clearOutputsOnEachMessage);
    }

    @Generated
    public void setClearOutputsOnEachMessage(boolean v) {
        this.setBoolean(clearOutputsOnEachMessage, v, null);
    }

    @Generated
    public String getPath() {
        return this.getString(path);
    }

    @Generated
    public void setPath(String v) {
        this.setString(path, v, null);
    }

    @Generated
    public boolean getCreateDate() {
        return this.getBoolean(createDate);
    }

    @Generated
    public void setCreateDate(boolean v) {
        this.setBoolean(createDate, v, null);
    }

    @Generated
    public String getDateFormat() {
        return this.getString(dateFormat);
    }

    @Generated
    public void setDateFormat(String v) {
        this.setString(dateFormat, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected void routeValue(BString message, Context cx) throws RoutingFailedException {
        Object json = new JSONTokener(message.getString()).nextValue();
        if (!(json instanceof JSONArray)) {
            throw new RoutingFailedException(LEX.getText("inputNotArray", cx));
        }
        JSONArray jsonArray = (JSONArray)json;
        if (jsonArray.isEmpty()) {
            throw new RoutingFailedException(LEX.getText("emptyArray", cx));
        }
        if (jsonArray.length() > this.getMaxSlots() && LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Array entry exceeds max slots. Array Length: " + jsonArray.length() + " is > Max slots: " + this.getMaxSlots());
        }
        List<Object> arrayList = this.arrayToList(jsonArray, "");
        for (int i = 0; i < this.getMaxSlots(); ++i) {
            String slotName = SLOT_NAME_PREFIX + i;
            if (i >= jsonArray.length()) {
                Property slotNameProperty = this.getProperty(slotName);
                if (slotNameProperty == null || !this.getClearOutputsOnEachMessage()) continue;
                this.set(slotNameProperty, (BValue)BString.DEFAULT);
                continue;
            }
            try {
                Object arrayEntry = arrayList.get(i);
                if (arrayEntry == null || arrayEntry.equals(JSONObject.NULL)) {
                    this.setNewValueOnSlot(message.toString(), slotName, (BValue)(this.getCreateStatusValues() ? new BStatusString("", BStatus.nullStatus) : BString.DEFAULT));
                    continue;
                }
                if (!this.getPath().isEmpty()) {
                    arrayEntry = this.runJsonPathQuery(arrayEntry.toString(), this.getPath(), Object.class);
                    arrayEntry = JsonSchemaUtil.jsonToString(arrayEntry, message);
                }
                if (this.getCreateDate()) {
                    BAbsTime absTime = JsonSchemaUtil.toBAbsTime(this.stringToDate(JsonSchemaUtil.toBValue(arrayEntry)));
                    this.setNewValueOnSlot(message.toString(), slotName, (BValue)absTime);
                    continue;
                }
                BStatusValue bValue = this.getCreateStatusValues() ? JsonSchemaUtil.toStatusValue(arrayEntry) : JsonSchemaUtil.toBValue(arrayEntry);
                this.setNewValueOnSlot(message.toString(), slotName, (BValue)bValue);
                continue;
            }
            catch (UnsupportedConversionTypeException | IOException exception) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("The supplied JSON input contains objects that are not supported for conversion by JsonSchemaUtil.toBValue: " + exception.getMessage() + ' ' + this.getSlotPath());
                }
                throw new RoutingFailedException(LEX.getText("unsupportedConversion", cx));
            }
        }
    }

    @Override
    public void changed(Property property, Context cx) {
        if (property.equals(dateFormat)) {
            this.userInputDate = null;
        }
    }

    protected List<Object> arrayToList(JSONArray arrayInput, String sortField) throws RoutingFailedException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (arrayInput.isEmpty()) {
            return Collections.emptyList();
        }
        for (Object item : arrayInput) {
            arrayList.add(item);
        }
        return arrayList;
    }

    protected Date stringToDate(Object date) throws RoutingFailedException {
        Date formattedDate;
        try {
            if (this.userInputDate == null) {
                this.userInputDate = new SimpleDateFormat(this.getDateFormat());
            }
            formattedDate = this.userInputDate.parse(date.toString());
        }
        catch (ParseException exception) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Error parsing JSON input date to Date in stringToDate. Check JSON input matches date format. " + exception.getMessage() + ' ' + "The supplied date is:" + date + ' ' + "The Date format is: " + this.getDateFormat());
            }
            throw new RoutingFailedException(LEX.getText("parseException", null, new Object[]{date, this.getDateFormat()}));
        }
        return formattedDate;
    }
}

