/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnetAws.datatypes;

import com.tridium.bacnet.asn.AsnUtil;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

@NiagaraType
@Deprecated
@NiagaraProperties(value={@NiagaraProperty(name="deviceId", type="BBacnetObjectIdentifier", defaultValue="BBacnetObjectIdentifier.DEFAULT_DEVICE", facets={@Facet(value="BBacnetObjectType.getObjectIdFacets(BBacnetObjectType.DEVICE)")}), @NiagaraProperty(name="objectId", type="BBacnetObjectIdentifier", defaultValue="BBacnetObjectIdentifier.DEFAULT"), @NiagaraProperty(name="propertyId", type="BEnum", defaultValue="BDynamicEnum.make(BBacnetPropertyIdentifier.presentValue)"), @NiagaraProperty(name="propertyArrayIndex", type="int", defaultValue="-1"), @NiagaraProperty(name="priority", type="int", defaultValue="-1", facets={@Facet(name="BFacets.MIN", value="-1"), @Facet(name="BFacets.MAX", value="16")}), @NiagaraProperty(name="postDelay", type="int", defaultValue="0", facets={@Facet(name="BFacets.MIN", value="0"), @Facet(name="BFacets.MAX", value="30"), @Facet(name="BFacets.UNITS", value="BUnit.getUnit(\"second\")")}), @NiagaraProperty(name="quitOnFailure", type="boolean", defaultValue="false"), @NiagaraProperty(name="writeSuccessful", type="boolean", defaultValue="false", flags=1)})
public class BBacnetActionCommand
extends BComponent
implements BIBacnetDataType {
    @Generated
    public static final Property deviceId = BBacnetActionCommand.newProperty((int)0, (BValue)BBacnetObjectIdentifier.DEFAULT_DEVICE, (BFacets)BBacnetObjectType.getObjectIdFacets((int)8));
    @Generated
    public static final Property objectId = BBacnetActionCommand.newProperty((int)0, (BValue)BBacnetObjectIdentifier.DEFAULT, null);
    @Generated
    public static final Property propertyId = BBacnetActionCommand.newProperty((int)0, (BValue)BDynamicEnum.make((BEnum)BBacnetPropertyIdentifier.presentValue), null);
    @Generated
    public static final Property propertyArrayIndex = BBacnetActionCommand.newProperty((int)0, (int)-1, null);
    @Generated
    public static final Property priority = BBacnetActionCommand.newProperty((int)0, (int)-1, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)-1), (BFacets)BFacets.make((String)"max", (int)16)));
    @Generated
    public static final Property postDelay = BBacnetActionCommand.newProperty((int)0, (int)0, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)0), (BFacets)BFacets.make((String)"max", (int)30)), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"second"))));
    @Generated
    public static final Property quitOnFailure = BBacnetActionCommand.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property writeSuccessful = BBacnetActionCommand.newProperty((int)1, (boolean)false, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetActionCommand.class);
    public static final int DEVICE_ID_TAG = 0;
    public static final int OBJECT_ID_TAG = 1;
    public static final int PROPERTY_ID_TAG = 2;
    public static final int PROPERTY_ARRAY_INDEX_TAG = 3;
    public static final int PROPERTY_VALUE_TAG = 4;
    public static final int PRIORITY_TAG = 5;
    public static final int POST_DELAY_TAG = 6;
    public static final int QUIT_ON_FAILURE_TAG = 7;
    public static final int WRITE_SUCCESSFUL_TAG = 8;

    @Generated
    public BBacnetObjectIdentifier getDeviceId() {
        return (BBacnetObjectIdentifier)this.get(deviceId);
    }

    @Generated
    public void setDeviceId(BBacnetObjectIdentifier v) {
        this.set(deviceId, (BValue)v, null);
    }

    @Generated
    public BBacnetObjectIdentifier getObjectId() {
        return (BBacnetObjectIdentifier)this.get(objectId);
    }

    @Generated
    public void setObjectId(BBacnetObjectIdentifier v) {
        this.set(objectId, (BValue)v, null);
    }

    @Generated
    public BEnum getPropertyId() {
        return (BEnum)this.get(propertyId);
    }

    @Generated
    public void setPropertyId(BEnum v) {
        this.set(propertyId, (BValue)v, null);
    }

    @Generated
    public int getPropertyArrayIndex() {
        return this.getInt(propertyArrayIndex);
    }

    @Generated
    public void setPropertyArrayIndex(int v) {
        this.setInt(propertyArrayIndex, v, null);
    }

    @Generated
    public int getPriority() {
        return this.getInt(priority);
    }

    @Generated
    public void setPriority(int v) {
        this.setInt(priority, v, null);
    }

    @Generated
    public int getPostDelay() {
        return this.getInt(postDelay);
    }

    @Generated
    public void setPostDelay(int v) {
        this.setInt(postDelay, v, null);
    }

    @Generated
    public boolean getQuitOnFailure() {
        return this.getBoolean(quitOnFailure);
    }

    @Generated
    public void setQuitOnFailure(boolean v) {
        this.setBoolean(quitOnFailure, v, null);
    }

    @Generated
    public boolean getWriteSuccessful() {
        return this.getBoolean(writeSuccessful);
    }

    @Generated
    public void setWriteSuccessful(boolean v) {
        this.setBoolean(writeSuccessful, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        this.getParent().asComponent().changed(this.getPropertyInParent(), cx);
    }

    public BValue getPropertyValue() {
        return this.get("propertyValue");
    }

    public void setPropertyValue(BValue v) {
        Property p = this.getProperty("propertyValue");
        if (p == null) {
            this.add("propertyValue", v);
        } else {
            this.set("propertyValue", v);
        }
    }

    public void readAsn(AsnInput in) throws AsnException {
        in.peekTag();
        if (in.isValueTag(0)) {
            this.setDeviceId(in.readObjectIdentifier(0));
        }
        this.setObjectId(in.readObjectIdentifier(1));
        this.setPropertyId((BEnum)BDynamicEnum.make((int)in.readEnumerated(2), (BEnumRange)this.getPropertyId().getRange()));
        in.peekTag();
        if (in.isValueTag(3)) {
            this.setPropertyArrayIndex(in.readUnsignedInt(3));
        }
        this.setPropertyValue(AsnUtil.asnToValue((byte[])in.readEncodedValue(4)));
        in.peekTag();
        if (in.isValueTag(5)) {
            this.setPriority(in.readUnsignedInt(5));
        }
        in.peekTag();
        if (in.isValueTag(6)) {
            this.setPostDelay(in.readUnsignedInt(6));
        }
        this.setQuitOnFailure(in.readBoolean(7));
        this.setWriteSuccessful(in.readBoolean(8));
    }

    public void writeAsn(AsnOutput out) {
        if (this.isDeviceIdUsed()) {
            out.writeObjectIdentifier(0, this.getDeviceId());
        }
        out.writeObjectIdentifier(1, this.getObjectId());
        out.writeEnumerated(2, this.getPropertyId());
        if (this.isPropertyArrayIndexUsed()) {
            out.writeUnsignedInteger(3, (long)this.getPropertyArrayIndex());
        }
        out.writeEncodedValue(4, AsnUtil.toAsn((BValue)this.getPropertyValue()));
        if (this.isPriorityUsed()) {
            out.writeUnsignedInteger(5, (long)this.getPriority());
        }
        if (this.isPostDelayUsed()) {
            out.writeUnsignedInteger(6, (long)this.getPostDelay());
        }
        out.writeBoolean(7, this.getQuitOnFailure());
        out.writeBoolean(8, this.getWriteSuccessful());
    }

    private boolean isDeviceIdUsed() {
        return !deviceId.isEquivalentToDefaultValue((BValue)this.getDeviceId());
    }

    private boolean isPropertyArrayIndexUsed() {
        return this.getPropertyArrayIndex() != -1;
    }

    private boolean isPriorityUsed() {
        return this.getPriority() != -1;
    }

    private boolean isPostDelayUsed() {
        return this.getPostDelay() > 0;
    }

    public String toString(Context c) {
        this.loadSlots();
        StringBuilder sb = new StringBuilder();
        sb.append(this.getObjectId()).append(":");
        sb.append(this.getPropertyId());
        if (this.getPropertyArrayIndex() >= 0) {
            sb.append("[").append(this.getPropertyArrayIndex()).append("]");
        }
        sb.append(":");
        if (this.getPostDelay() > 0) {
            sb.append("dly=").append(this.getPostDelay()).append(":");
        }
        sb.append("val=").append(this.getPropertyValue());
        return sb.toString();
    }
}

