/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnetAws.history;

import com.tridium.bacnet.asn.EventNotificationParameters;
import com.tridium.bacnet.datatypes.BBacnetEventNotification;
import com.tridium.bacnet.datatypes.BTrendEvent;
import com.tridium.bacnet.history.BAbstractBacnetHistory;
import com.tridium.bacnet.history.BacnetTrendLogUtil;
import com.tridium.bacnet.services.confirmed.ReadRangeAck;
import com.tridium.bacnetAws.history.BBacnetEventRecord;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.datatypes.BBacnetEventLogRecord;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.driver.history.ArchiveException;
import javax.baja.driver.util.BDescriptorState;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComplex;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperty(name="localHistoryNames", type="String", defaultValue="", flags=1)
public class BBacnetEventLogImport
extends BAbstractBacnetHistory
implements BacnetConst {
    @Generated
    public static final Property localHistoryNames = BBacnetEventLogImport.newProperty((int)1, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetEventLogImport.class);
    public static final Logger logger = Logger.getLogger("bacnet.history");
    public static final Lexicon lex = Lexicon.make((String)"bacnet");
    byte[] prev = null;
    String[] prevNams = null;
    boolean oprChange = true;

    @Generated
    public String getLocalHistoryNames() {
        return this.getString(localHistoryNames);
    }

    @Generated
    public void setLocalHistoryNames(String v) {
        this.setString(localHistoryNames, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void doExecute() throws ArchiveException {
        if (!this.isRunning()) {
            return;
        }
        BBacnetDevice device = this.device();
        if (!device.isServiceSupported("readRange")) {
            this.executeFail(lex.getText("serviceNotSupported.readRange"));
            return;
        }
        BHistoryDatabase db = this.getHistoryDb();
        this.verifyLocalNameFormat();
        try (HistorySpaceConnection conn = db.getConnection(null);){
            BIHistory history = this.getOrCreateHistory(conn);
            if (history == null) {
                return;
            }
            long referenceIndex = -1L;
            int rangeType = 6;
            BBacnetDateTime referenceTime = this.getReferenceTime();
            int count = this.getMaxRecordsPerRequest();
            if (count == 0) {
                count = 10;
            }
            try {
                referenceIndex = this.determineNextIndex();
                if (referenceIndex < 0L) {
                    return;
                }
                ReadRangeAck prevResponse = null;
                boolean moreItems = true;
                while (moreItems) {
                    ReadRangeAck response = this.client().readRange(device.getAddress(), this.getObjectId(), 131, -1, rangeType, referenceIndex, referenceTime, count);
                    if (response == null) {
                        if (!logger.isLoggable(Level.INFO)) break;
                        logger.info("Error importing history data for " + (Object)((Object)this) + ": null response from device!");
                        break;
                    }
                    if (response.equals(prevResponse)) {
                        if (!logger.isLoggable(Level.INFO)) break;
                        logger.info("Error importing history data for " + (Object)((Object)this) + ": duplicate response (loop?):\nResponse:" + response);
                        break;
                    }
                    prevResponse = response;
                    byte[] encodedValue = response.getItemData();
                    if (encodedValue == null || encodedValue.length == 0) break;
                    moreItems = response.isMoreItems() || !response.includesLastItem();
                    this.asnIn.setBuffer(encodedValue);
                    long currentSeqNum = response.getFirstSequenceNumber();
                    if (currentSeqNum == -1L) {
                        currentSeqNum = BacnetTrendLogUtil.incrementSequenceNumber((long)this.getLastSequenceNumberProcessed());
                    }
                    Array a = new Array(BBacnetEventLogRecord.class);
                    while (this.asnIn.peekTag() != -1) {
                        BBacnetEventLogRecord entry = new BBacnetEventLogRecord();
                        entry.readAsn((AsnInput)this.asnIn);
                        a.add((Object)entry);
                    }
                    BBacnetEventLogRecord[] recs = (BBacnetEventLogRecord[])a.trim();
                    BBacnetEventLogRecord lstRec = recs[recs.length - 1];
                    this.getReferenceTime().copyFrom((BComplex)lstRec.getTimestamp());
                    this.setLastSequenceNumberProcessed(response.getFirstSequenceNumber() + (long)recs.length - 1L);
                    for (int i = 0; i < recs.length; ++i) {
                        BBacnetEventLogRecord entry = recs[i];
                        try {
                            BHistoryRecord rec = this.initializeNiagaraRecord(entry, history.getConfig().makeRecord(), currentSeqNum);
                            conn.append(history, (BIHistoryRecordSet)this.correctTimestamp(rec));
                        }
                        catch (Exception e) {
                            if (!logger.isLoggable(Level.INFO)) break;
                            logger.info("Ignore trend record " + currentSeqNum + ":" + e.toString());
                            break;
                        }
                        currentSeqNum = BacnetTrendLogUtil.incrementSequenceNumber((long)currentSeqNum);
                    }
                    if (!moreItems) continue;
                    referenceIndex = BacnetTrendLogUtil.incrementSequenceNumber((long)this.getLastSequenceNumberProcessed());
                    referenceTime = this.getReferenceTime();
                }
                this.executeOk();
            }
            catch (Exception e) {
                this.executeFail(e);
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, "Asn Exception reading range (device " + device.getAddress() + ", id " + this.getObjectId() + ", rangeType " + rangeType + ", referenceIndex " + referenceIndex + ", referenceTime " + referenceTime + ", count " + count + ")", e);
                }
                throw new ArchiveException((Throwable)e);
            }
            finally {
                this.setState(BDescriptorState.idle);
            }
        }
    }

    private BHistoryRecord initializeNiagaraRecord(BBacnetEventLogRecord eventLogRecord, BHistoryRecord historyRecord, long seqNum) throws BacnetException {
        if (!(historyRecord instanceof BBacnetEventRecord)) {
            throw new BacnetException("History record should have been instanceof BBacnetEventRecord");
        }
        BBacnetEventRecord rec = (BBacnetEventRecord)historyRecord;
        rec.setTimestamp(eventLogRecord.getTimestamp().toBAbsTime());
        rec.setSequenceNumber(seqNum);
        BValue logDatum = eventLogRecord.getLogDatum();
        if (logDatum instanceof BTrendEvent) {
            rec.setLogEvent((BTrendEvent)logDatum);
            rec.setTrendFlags(rec.getTrendFlags().set(4, true));
            return rec;
        }
        if (logDatum instanceof BBacnetEventNotification) {
            rec.setLogEvent(BTrendEvent.DEFAULT);
            BBacnetEventLogImport.eventNotificationParametersToEventRecord(rec, ((BBacnetEventNotification)logDatum).getEventNotificationParameters());
            return rec;
        }
        throw new BacnetException("The logDatum property for BBacnetEventLogRecord is not applicable: " + logDatum);
    }

    private static void eventNotificationParametersToEventRecord(BBacnetEventRecord record, EventNotificationParameters enp) {
        record.setProcessId(Long.toString(enp.getProcessId()));
        record.setInitiatingDevice(enp.getInitiatingDeviceId().toString());
        record.setEventObject(enp.getEventObjectId().toString());
        record.setTimeStamp(enp.getTimeStamp().toString());
        record.setNotificationClass(Long.toString(enp.getNotificationClass()));
        record.setPriority(Integer.toString(enp.getPriority()));
        record.setEventType(enp.getEventType().getTag());
        record.setMessageText(enp.getMessageText());
        record.setNotifyType(enp.getNotifyType().toString());
        record.setAckRequired(Boolean.toString(enp.getAckRequired()));
        record.setFromState(enp.getFromState().getTag());
        record.setToState(enp.getToState().getTag());
        record.setEventValues(enp.getEventValues().toString());
    }

    protected BTypeSpec getTypeSpec() {
        return BTypeSpec.make((String)"bacnetAws", (String)"BacnetEventRecord");
    }
}

