/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaServer.ui;

import com.tridium.opcUaServer.BOpcUaNamespace;
import com.tridium.opcUaServer.BOpcUaServer;
import com.tridium.opcUaServer.BOpcUaServerDeviceFolder;
import com.tridium.util.ArrayUtil;
import javax.baja.driver.BDevice;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.driver.ui.device.DeviceController;
import javax.baja.driver.ui.device.DeviceExtsColumn;
import javax.baja.driver.ui.device.DeviceModel;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;

@NiagaraType(agent={@AgentOn(types={"opcUaServer:OpcUaServer", "opcUaServer:OpcUaServerDeviceFolder"})})
public class BOpcUaServerDeviceManager
extends BDeviceManager {
    @Generated
    public static final Type TYPE = Sys.loadType(BOpcUaServerDeviceManager.class);
    static Lexicon lex = Lexicon.make(BOpcUaServerDeviceManager.class);
    static BImage stationIcon = BImage.make((String)"module://icons/x16/device.png");
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colType = new MgrColumn.Type();
    MgrColumn colDeviceExts = new DeviceExtsColumn((BDevice)new BOpcUaNamespace());
    MgrColumn colStatus = new MgrColumn.Prop(BDevice.status, 4);
    MgrColumn colNamespaceUrl = new MgrColumn.Prop(BOpcUaNamespace.namespaceUrl, 1);
    MgrColumn colEnabled = new MgrColumn.Prop(BDevice.enabled, 1);
    MgrColumn colHealth = new MgrColumn.Prop(BDevice.health, 0);
    MgrColumn[] cols = new MgrColumn[]{this.colName, this.colType, this.colDeviceExts, this.colNamespaceUrl, this.colStatus, this.colEnabled, this.colHealth};

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BOpcUaServer getNetwork() {
        BObject owner = this.getCurrentValue();
        if (owner instanceof BOpcUaServerDeviceFolder) {
            return ((BOpcUaServerDeviceFolder)owner).getOpcUaServer();
        }
        if (owner instanceof BOpcUaServer) {
            return (BOpcUaServer)owner;
        }
        return null;
    }

    public void doLoadValue(BObject obj, Context cx) {
        super.doLoadValue(obj, cx);
        this.updateLearnData();
    }

    void updateLearnData() {
    }

    public BOpcUaNamespace[] getSelectedDevices() {
        if (this.getModel() == null || this.getModel().getTable() == null) {
            return new BOpcUaNamespace[0];
        }
        BComponent[] selection = this.getModel().getTable().getSelectedComponents();
        Object[] devices = new BOpcUaNamespace[]{};
        for (int i = 0; i < selection.length; ++i) {
            if (!selection[i].getType().is(BOpcUaNamespace.TYPE)) continue;
            devices = (BOpcUaNamespace[])ArrayUtil.addOne((Object[])devices, (Object)((BOpcUaNamespace)selection[i]));
        }
        return devices;
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    class Controller
    extends DeviceController {
        Controller(BDeviceManager mgr) {
            super(mgr);
        }
    }

    class Learn
    extends MgrLearn {
        Learn(BDeviceManager manager) {
            super((BAbstractManager)manager);
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[0];
        }

        public BImage getIcon(Object dis) {
            return stationIcon;
        }

        public MgrTypeInfo[] toTypes(Object discovery) {
            return MgrTypeInfo.makeArray((Type)BOpcUaServerDeviceManager.this.getNetwork().getDeviceType());
        }

        public void toRow(Object discovery, MgrEditRow row) {
        }

        public boolean isExisting(Object dis, BComponent comp) {
            BOpcUaNamespace d = (BOpcUaNamespace)comp;
            return false;
        }

        public void jobComplete(BJob job) {
            super.jobComplete(job);
        }
    }

    class Model
    extends DeviceModel {
        Model(BDeviceManager manager) {
            super(manager);
        }

        protected MgrColumn[] makeColumns() {
            return BOpcUaServerDeviceManager.this.cols;
        }
    }
}

