/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.services.weather;

import com.lynxspring.control.BLicensedComponent;
import com.lynxspring.services.weather.BAtmosphericPressure;
import com.lynxspring.services.weather.BWeatherCondition;
import com.lynxspring.services.weather.BWeatherForecast;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.baja.agent.BPxView;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.TextUtil;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIService;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XWriter;

public class BYahooWeatherService
extends BLicensedComponent
implements BIService {
    public static final Property location = BYahooWeatherService.newProperty((int)0, (String)"", null);
    public static final Property refreshRate = BYahooWeatherService.newProperty((int)0, (BValue)BRelTime.makeHours((int)1), null);
    public static final Property units = BYahooWeatherService.newProperty((int)0, (boolean)false, (BFacets)BFacets.makeBoolean((String)"Metric", (String)"US"));
    public static final Property temperature = BYahooWeatherService.newProperty((int)11, (BValue)new BStatusNumeric(), (BFacets)BFacets.makeNumeric((BUnit)BUnit.getUnit((String)"fahrenheit"), (int)0));
    public static final Property condition = BYahooWeatherService.newProperty((int)11, (BValue)BWeatherCondition.notAvailable, null);
    public static final Property conditionText = BYahooWeatherService.newProperty((int)11, (BValue)new BStatusString(), null);
    public static final Property windChill = BYahooWeatherService.newProperty((int)11, (BValue)new BStatusNumeric(), (BFacets)BFacets.makeNumeric((BUnit)BUnit.getUnit((String)"fahrenheit"), (int)0));
    public static final Property humidity = BYahooWeatherService.newProperty((int)11, (BValue)new BStatusNumeric(), (BFacets)BFacets.makeNumeric((BUnit)BUnit.getUnit((String)"percent"), (int)0));
    public static final Property windSpeed = BYahooWeatherService.newProperty((int)11, (BValue)new BStatusNumeric(), (BFacets)BFacets.makeNumeric((BUnit)BUnit.getUnit((String)"miles per hour"), (int)0));
    public static final Property windDirection = BYahooWeatherService.newProperty((int)11, (BValue)new BStatusNumeric(), (BFacets)BFacets.makeNumeric((BUnit)BUnit.getUnit((String)"degrees angular"), (int)0));
    public static final Property visibility = BYahooWeatherService.newProperty((int)11, (BValue)new BStatusNumeric(), (BFacets)BFacets.makeNumeric((BUnit)BUnit.getUnit((String)"mile"), (int)0));
    public static final Property pressure = BYahooWeatherService.newProperty((int)11, (BValue)new BStatusNumeric(), null);
    public static final Property rising = BYahooWeatherService.newProperty((int)11, (BValue)BAtmosphericPressure.steady, null);
    public static final Property sunrise = BYahooWeatherService.newProperty((int)11, (BValue)BTime.DEFAULT, null);
    public static final Property sunset = BYahooWeatherService.newProperty((int)11, (BValue)BTime.DEFAULT, null);
    public static final Property forecast1 = BYahooWeatherService.newProperty((int)11, (BValue)new BWeatherForecast(), null);
    public static final Property forecast2 = BYahooWeatherService.newProperty((int)11, (BValue)new BWeatherForecast(), null);
    public static final Property weatherView = BYahooWeatherService.newProperty((int)256, (BValue)BYahooWeatherService.makeWeatherView(), null);
    public static final Action refresh = BYahooWeatherService.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BYahooWeatherService.class);
    Clock.Ticket refreshTicket;
    public static final Log log = Log.getLog((String)"YahooWeatherService");
    public static final String YAHOO_WEATHER_URL = "http://weather.yahooapis.com/forecastrss";

    public String getLocation() {
        return this.getString(location);
    }

    public void setLocation(String v) {
        this.setString(location, v, null);
    }

    public BRelTime getRefreshRate() {
        return (BRelTime)this.get(refreshRate);
    }

    public void setRefreshRate(BRelTime v) {
        this.set(refreshRate, (BValue)v, null);
    }

    public boolean getUnits() {
        return this.getBoolean(units);
    }

    public void setUnits(boolean v) {
        this.setBoolean(units, v, null);
    }

    public BStatusNumeric getTemperature() {
        return (BStatusNumeric)this.get(temperature);
    }

    public void setTemperature(BStatusNumeric v) {
        this.set(temperature, (BValue)v, null);
    }

    public BWeatherCondition getCondition() {
        return (BWeatherCondition)this.get(condition);
    }

    public void setCondition(BWeatherCondition v) {
        this.set(condition, (BValue)v, null);
    }

    public BStatusString getConditionText() {
        return (BStatusString)this.get(conditionText);
    }

    public void setConditionText(BStatusString v) {
        this.set(conditionText, (BValue)v, null);
    }

    public BStatusNumeric getWindChill() {
        return (BStatusNumeric)this.get(windChill);
    }

    public void setWindChill(BStatusNumeric v) {
        this.set(windChill, (BValue)v, null);
    }

    public BStatusNumeric getHumidity() {
        return (BStatusNumeric)this.get(humidity);
    }

    public void setHumidity(BStatusNumeric v) {
        this.set(humidity, (BValue)v, null);
    }

    public BStatusNumeric getWindSpeed() {
        return (BStatusNumeric)this.get(windSpeed);
    }

    public void setWindSpeed(BStatusNumeric v) {
        this.set(windSpeed, (BValue)v, null);
    }

    public BStatusNumeric getWindDirection() {
        return (BStatusNumeric)this.get(windDirection);
    }

    public void setWindDirection(BStatusNumeric v) {
        this.set(windDirection, (BValue)v, null);
    }

    public BStatusNumeric getVisibility() {
        return (BStatusNumeric)this.get(visibility);
    }

    public void setVisibility(BStatusNumeric v) {
        this.set(visibility, (BValue)v, null);
    }

    public BStatusNumeric getPressure() {
        return (BStatusNumeric)this.get(pressure);
    }

    public void setPressure(BStatusNumeric v) {
        this.set(pressure, (BValue)v, null);
    }

    public BAtmosphericPressure getRising() {
        return (BAtmosphericPressure)this.get(rising);
    }

    public void setRising(BAtmosphericPressure v) {
        this.set(rising, (BValue)v, null);
    }

    public BTime getSunrise() {
        return (BTime)this.get(sunrise);
    }

    public void setSunrise(BTime v) {
        this.set(sunrise, (BValue)v, null);
    }

    public BTime getSunset() {
        return (BTime)this.get(sunset);
    }

    public void setSunset(BTime v) {
        this.set(sunset, (BValue)v, null);
    }

    public BWeatherForecast getForecast1() {
        return (BWeatherForecast)this.get(forecast1);
    }

    public void setForecast1(BWeatherForecast v) {
        this.set(forecast1, (BValue)v, null);
    }

    public BWeatherForecast getForecast2() {
        return (BWeatherForecast)this.get(forecast2);
    }

    public void setForecast2(BWeatherForecast v) {
        this.set(forecast2, (BValue)v, null);
    }

    public BPxView getWeatherView() {
        return (BPxView)this.get(weatherView);
    }

    public void setWeatherView(BPxView v) {
        this.set(weatherView, (BValue)v, null);
    }

    public void refresh() {
        this.invoke(refresh, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public void serviceStarted() throws Exception {
    }

    public void serviceStopped() throws Exception {
        if (!this.isRunning()) {
            return;
        }
        this.cancelRefresh();
    }

    public void atSteadyState() {
        this.doRefresh();
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (p == refreshRate) {
            this.refreshTicket();
        } else if (p == units || p == location) {
            this.doRefresh();
        }
    }

    public void doRefresh() {
        if (!this.isRunning() || !this.checkLicense()) {
            return;
        }
        this.refreshTicket();
        if (this.getLocation().length() > 0) {
            new HttpThread().start();
        }
    }

    private void refreshTicket() {
        this.cancelRefresh();
        this.refreshTicket = Clock.schedule((BComponent)this, (BRelTime)this.getRefreshRate(), (Action)refresh, null);
    }

    private void cancelRefresh() {
        if (this.refreshTicket != null && !this.refreshTicket.isExpired()) {
            this.refreshTicket.cancel();
        }
    }

    private BTime getTime(String time) {
        BTime ret = BTime.DEFAULT;
        try {
            String[] amPm = TextUtil.split((String)time, (char)' ');
            String[] hourMin = TextUtil.split((String)amPm[0], (char)':');
            int hour = Integer.parseInt(hourMin[0]);
            int min = Integer.parseInt(hourMin[1]);
            if (amPm[1].equalsIgnoreCase("pm")) {
                hour += 12;
            }
            ret = BTime.make((int)hour, (int)min, (int)0);
        }
        catch (Exception e) {
            log.error("Invalid time format", (Throwable)e);
        }
        return ret;
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot == temperature || slot == windChill) {
            return this.getUnits() ? BFacets.makeNumeric((BUnit)BUnit.getUnit((String)"celsius"), (int)0) : BFacets.makeNumeric((BUnit)BUnit.getUnit((String)"fahrenheit"), (int)0);
        }
        if (slot == windSpeed) {
            return this.getUnits() ? BFacets.makeNumeric((BUnit)BUnit.getUnit((String)"kilometers per hour"), (int)0) : BFacets.makeNumeric((BUnit)BUnit.getUnit((String)"miles per hour"), (int)0);
        }
        if (slot == visibility) {
            return this.getUnits() ? BFacets.makeNumeric((BUnit)BUnit.getUnit((String)"kilometer"), (int)0) : BFacets.makeNumeric((BUnit)BUnit.getUnit((String)"mile"), (int)0);
        }
        return super.getSlotFacets(slot);
    }

    private static final BPxView makeWeatherView() {
        BPxView view = new BPxView(BOrd.make((String)"module://lynxKitControl/px/Weather.px"));
        view.setIcon(BIcon.make((String)"module://lynxKitControl/icons/yahoo.png"));
        return view;
    }

    class HttpThread
    extends Thread {
        @Override
        public void run() {
            InputStream in = null;
            try {
                HttpURLConnection conn = (HttpURLConnection)new URL("http://weather.yahooapis.com/forecastrss?p=" + BYahooWeatherService.this.getLocation() + (BYahooWeatherService.this.getUnits() ? "&u=c" : "")).openConnection();
                conn.setDoOutput(true);
                conn.setUseCaches(false);
                conn.setRequestMethod("GET");
                in = conn.getInputStream();
                XElem elem = XParser.make((InputStream)in).parse();
                in.close();
                if (log.isTraceOn()) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    XWriter out = new XWriter((OutputStream)baos);
                    elem.write(out);
                    out.flush();
                    log.trace(baos.toString());
                }
                elem = elem.elem("channel");
                double windChill = Double.NaN;
                double windSpeed = Double.NaN;
                double windDirection = Double.NaN;
                XElem wind = elem.elem("wind");
                try {
                    windChill = wind.getd("chill", Double.NaN);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    windSpeed = wind.getd("speed", Double.NaN);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    windDirection = wind.getd("direction", Double.NaN);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                BYahooWeatherService.this.setWindChill(new BStatusNumeric(windChill));
                BYahooWeatherService.this.setWindSpeed(new BStatusNumeric(windSpeed));
                BYahooWeatherService.this.setWindDirection(new BStatusNumeric(windDirection));
                double humidity = Double.NaN;
                double visibility = Double.NaN;
                double pressure = Double.NaN;
                int rising = 0;
                XElem atmosphere = elem.elem("atmosphere");
                try {
                    humidity = atmosphere.getd("humidity", Double.NaN);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    visibility = atmosphere.getd("visibility", Double.NaN);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    pressure = atmosphere.getd("pressure", Double.NaN);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    rising = atmosphere.geti("rising", 0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                BYahooWeatherService.this.setHumidity(new BStatusNumeric(humidity));
                BYahooWeatherService.this.setVisibility(new BStatusNumeric(visibility));
                BYahooWeatherService.this.setPressure(new BStatusNumeric(pressure));
                BYahooWeatherService.this.setRising(BAtmosphericPressure.make(rising));
                XElem astronomy = elem.elem("astronomy");
                BTime sunrise = BTime.DEFAULT;
                BTime sunset = BTime.DEFAULT;
                try {
                    sunrise = BYahooWeatherService.this.getTime(astronomy.get("sunrise", ""));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    sunset = BYahooWeatherService.this.getTime(astronomy.get("sunset", ""));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                BYahooWeatherService.this.setSunrise(sunrise);
                BYahooWeatherService.this.setSunset(sunset);
                elem = elem.elem("item");
                double temp = Double.NaN;
                int cond = 3200;
                String condText = "";
                XElem condition = elem.elem("condition");
                try {
                    temp = condition.getd("temp", Double.NaN);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    cond = condition.geti("code", 3200);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    condText = condition.get("text", "");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                BYahooWeatherService.this.setTemperature(new BStatusNumeric(temp));
                BYahooWeatherService.this.setCondition(BWeatherCondition.make(cond));
                BYahooWeatherService.this.setConditionText(new BStatusString(condText));
                XElem[] forecasts = elem.elems("forecast");
                String day = "";
                double low = Double.NaN;
                double high = Double.NaN;
                cond = 3200;
                condText = "";
                if (forecasts.length > 0) {
                    try {
                        day = forecasts[0].get("day", "");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        low = forecasts[0].getd("low", Double.NaN);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        high = forecasts[0].getd("high", Double.NaN);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        cond = forecasts[0].geti("code", 3200);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        condText = forecasts[0].get("text", "");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                BWeatherForecast forecast = BYahooWeatherService.this.getForecast1();
                forecast.setDay(day);
                forecast.setLow(new BStatusNumeric(low));
                forecast.setHigh(new BStatusNumeric(high));
                forecast.setCondition(BWeatherCondition.make(cond));
                forecast.setConditionText(new BStatusString(condText));
                day = "";
                low = Double.NaN;
                high = Double.NaN;
                cond = 3200;
                condText = "";
                if (forecasts.length > 1) {
                    try {
                        day = forecasts[1].get("day", "");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        low = forecasts[1].getd("low", Double.NaN);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        high = forecasts[1].getd("high", Double.NaN);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        cond = forecasts[1].geti("code", 3200);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        condText = forecasts[1].get("text", "");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                forecast = BYahooWeatherService.this.getForecast2();
                forecast.setDay(day);
                forecast.setLow(new BStatusNumeric(low));
                forecast.setHigh(new BStatusNumeric(high));
                forecast.setCondition(BWeatherCondition.make(cond));
                forecast.setConditionText(new BStatusString(condText));
            }
            catch (Exception e) {
                log.error("Error getting weather data from http://weather.yahooapis.com/forecastrss", (Throwable)e);
            }
        }

        HttpThread() {
        }
    }
}

