/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.services.config;

import com.lynxspring.services.config.BUtilConfig;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public class BComponentConfig
extends BUtilConfig {
    public static final Property typeToAdd = BComponentConfig.newProperty((int)0, (BValue)BTypeSpec.DEFAULT, null);
    public static final Property useTypeName = BComponentConfig.newProperty((int)0, (boolean)true, null);
    public static final Type TYPE = Sys.loadType(BComponentConfig.class);

    public BTypeSpec getTypeToAdd() {
        return (BTypeSpec)this.get(typeToAdd);
    }

    public void setTypeToAdd(BTypeSpec v) {
        this.set(typeToAdd, (BValue)v, null);
    }

    public boolean getUseTypeName() {
        return this.getBoolean(useTypeName);
    }

    public void setUseTypeName(boolean v) {
        this.setBoolean(useTypeName, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public static BComponentConfig make(BTypeSpec spec, BOrd ord, String name) {
        BComponentConfig cc = new BComponentConfig();
        cc.setTypeToAdd(spec);
        cc.setTargetOrd(ord);
        if (cc.getUseTypeName()) {
            cc.setNewName(spec.getTypeName());
        } else {
            cc.setNewName(name);
        }
        return cc;
    }

    public static BComponentConfig make(String spec, String ord, String name) {
        return BComponentConfig.make(BTypeSpec.make((String)spec), BOrd.make((String)ord), name);
    }

    @Override
    public void encode(DataOutput out) throws IOException {
        out.writeBytes(this.getTypeToAdd().toString() + ';' + this.getTargetOrd().toString() + ';' + this.getNewName());
    }

    @Override
    public BObject decode(DataInput in) throws IOException {
        String line = in.readLine();
        String name = TextUtil.split((String)line, (char)';').length > 2 ? TextUtil.split((String)line, (char)';')[2] : "component";
        return BComponentConfig.make(TextUtil.split((String)line, (char)';')[0], TextUtil.split((String)line, (char)';')[1], name);
    }

    @Override
    public String encodeToString() throws IOException {
        return this.getTypeToAdd().toString() + ';' + this.getTargetOrd().toString() + ';' + this.getNewName();
    }

    @Override
    public BObject decodeFromString(String s) throws IOException {
        String name = TextUtil.split((String)s, (char)';').length > 2 ? TextUtil.split((String)s, (char)';')[2] : "component";
        return BComponentConfig.make(TextUtil.split((String)s, (char)';')[0], TextUtil.split((String)s, (char)';')[1], name);
    }
}

