/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.services;

import com.lynxspring.services.config.BComponentConfig;
import com.lynxspring.services.config.BHaystackConfig;
import com.lynxspring.services.config.BTemplateConfig;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.baja.file.BIFile;
import javax.baja.io.ValueDocDecoder;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.sys.Action;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.ModuleException;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeException;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.util.BTypeSpec;

public class BCompUtilService
extends BAbstractService {
    public static final Property message = BCompUtilService.newProperty((int)1, (String)"", null);
    public static final Action addComponent = BCompUtilService.newAction((int)0, (BValue)new BComponentConfig(), null);
    public static final Action addHaystackTags = BCompUtilService.newAction((int)0, (BValue)new BHaystackConfig(), null);
    public static final Action addDeviceFromTemplate = BCompUtilService.newAction((int)0, (BValue)new BTemplateConfig(), null);
    public static final Type TYPE = Sys.loadType(BCompUtilService.class);
    BOrd drivers = BOrd.make((String)"station:|slot:/Drivers");
    private static final BIcon icon = BIcon.std((String)"gears.png");
    private static final String HAYSTACK_PROPERTY = "haystack";
    private static final String ERR = "ERR: ";

    public String getMessage() {
        return this.getString(message);
    }

    public void setMessage(String v) {
        this.setString(message, v, null);
    }

    public BString addComponent(BComponentConfig arg) {
        return (BString)this.invoke(addComponent, (BValue)arg, null);
    }

    public BString addHaystackTags(BHaystackConfig arg) {
        return (BString)this.invoke(addHaystackTags, (BValue)arg, null);
    }

    public BString addDeviceFromTemplate(BTemplateConfig arg) {
        return (BString)this.invoke(addDeviceFromTemplate, (BValue)arg, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{this.getType()};
    }

    public BValue getActionParameterDefault(Action ax) {
        if (ax == addComponent) {
            String newName = "component";
            int x = 0;
            while (!SlotPath.isValidName((String)newName)) {
                newName = "component" + x++;
            }
            return BComponentConfig.make(BTypeSpec.make((Type)BComponent.TYPE), this.drivers, newName);
        }
        if (ax == addHaystackTags) {
            return BHaystackConfig.make(BOrd.make((String)"slot:/Drivers/"), "");
        }
        if (ax == addDeviceFromTemplate) {
            return BTemplateConfig.make(BOrd.make((String)"file:^templates/Panduit"), this.drivers, "newTemplateDevice");
        }
        return super.getActionParameterDefault(ax);
    }

    public BString doAddComponent(BComponentConfig arg, Context cx) {
        try {
            System.out.println("config serialized:" + arg.encodeToString());
        }
        catch (IOException e) {
            System.out.println("config serialized error for " + arg.toString(cx));
        }
        BValue val = this.getValueFromTypeSpec(arg.getTypeToAdd());
        this.setMessage("Created new component " + val.getTypeDisplayName(cx));
        try {
            BComponent target = arg.getTargetOrd().resolve((BObject)this.getHost()).getComponent();
            this.setMessage("Resolving target component");
            String name = (arg.getUseTypeName() ? arg.getTypeToAdd().getTypeName() : arg.getNewName()) + "?";
            if (arg.getTypeToAdd().toString().equals("nhaystack:HDict")) {
                name = HAYSTACK_PROPERTY;
            }
            Property pr = target.add(name, val, cx);
            this.setMessage("Added " + arg.getTypeToAdd().getTypeName() + " as '" + target.get(pr.getName()).asComponent().getSlotPath() + "'");
        }
        catch (UnresolvedException u) {
            this.setMessage("Ord is unresolved");
        }
        catch (SyntaxException s) {
            this.setMessage("Syntax error with ord '" + arg.getTargetOrd().toString() + "'");
        }
        catch (Exception ex) {
            this.setMessage(ex.toString());
        }
        return BString.make((String)this.getMessage());
    }

    public BString doAddHaystackTags(BHaystackConfig arg, Context cx) {
        this.getValueFromTypeSpec(arg.getTypeToAdd());
        if (this.getMessage().indexOf(ERR) == -1) {
            try {
                BComponent target = arg.getTargetOrd().resolve().getComponent();
                Property tags = target.getProperty(HAYSTACK_PROPERTY);
                if (tags == null) {
                    this.setMessage(this.doAddComponent(BHaystackConfig.make(arg.getTargetOrd(), arg.getNewName()), cx).toString());
                    this.setMessage("Added 'haystack' to " + target.getName());
                }
                tags = target.getProperty(HAYSTACK_PROPERTY);
                if (arg.getTags() != null && arg.getTags().length() > 0) {
                    target.set(tags, (BValue)arg.getTypeToAdd().getResolvedType().getTypeClass().getMethod("make", String.class).invoke((Object)tags, (Object[])new String[]{arg.getTags().toString()}));
                    this.setMessage("Added 'haystack' tags '" + arg.getTags() + "' to " + target.getName());
                }
                tags = target.getProperty(HAYSTACK_PROPERTY);
            }
            catch (Exception ex) {
                Log log = Log.getLog((String)"lkc");
                StackTraceElement[] stack = ex.getStackTrace();
                for (int s = 0; s < stack.length; ++s) {
                    if (log.isTraceOn()) {
                        System.out.println((s < 10 ? "0" : "") + s + " -- " + stack[s]);
                    }
                    if (stack[s].toString().indexOf("lynxspring") > 1) break;
                }
                this.setMessage(ex.getMessage());
            }
        } else {
            this.setMessage("Error loading or accessing the NHaystack module (" + this.getMessage() + ")");
        }
        System.out.println(arg.getTags());
        return BString.make((String)this.getMessage());
    }

    public BString doAddDeviceFromTemplate(BTemplateConfig arg, Context cx) {
        try {
            System.out.println("config serialized:" + arg.encodeToString());
        }
        catch (IOException e) {
            System.out.println("config serialized error for " + arg.toString(cx));
        }
        try {
            BComponent c = this.getComponentFromTemplate(arg.getSourceOrd());
            if (c != null) {
                BComponent target = arg.getTargetOrd().resolve().getComponent();
                Property pr = target.add(arg.getNewName() + "?", (BValue)c, cx);
                this.setMessage("Successfully added device template as '" + pr.getName() + "'");
            }
        }
        catch (Exception ex) {
            this.setMessage(ex.toString());
        }
        return BString.make((String)this.getMessage());
    }

    public BValue getValueFromTypeSpec(BTypeSpec spec) {
        BValue val = null;
        Type type = null;
        try {
            type = spec.getResolvedType();
            this.setMessage("Resolving TypeSpec " + spec);
            System.out.println("resolved type: " + type);
            val = (BValue)type.getInstance();
        }
        catch (TypeNotFoundException tnf) {
            this.setMessage("ERR: Type Not Found (" + spec.getTypeName() + ")");
        }
        catch (TypeException t) {
            this.setMessage("ERR: Problem loading or accessing type (" + spec.getTypeName() + ")");
        }
        catch (ModuleNotFoundException mnf) {
            this.setMessage("ERR: Problem loading module (" + spec.getModuleName() + ")");
        }
        catch (ModuleException m) {
            this.setMessage("ERR: Module Not Found (" + spec.getModuleName() + ")");
        }
        System.out.println("GET: " + this.getMessage());
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BComponent getComponentFromTemplate(BOrd path) {
        BIFile file = (BIFile)path.get();
        try (ValueDocDecoder d = null;){
            d = new ValueDocDecoder((InputStream)new BufferedInputStream(file.getInputStream()));
        }
        BComponent graph = null;
        try {
            graph = (BComponent)d.decodeDocument();
        }
        catch (Exception e) {
            this.setMessage("Error decoding template file");
        }
        if (((BObject[])graph.getChildren(BObject.class)).length > 0) {
            this.setMessage("Successfully loaded component for template " + path);
            return ((BComplex)((BObject[])graph.getChildren(BObject.class))[0]).newCopy().asComponent();
        }
        this.setMessage("Error, could not get component for template " + path);
        return null;
    }

    public BIcon getIcon() {
        return icon;
    }
}

