/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.util;

import javax.baja.license.LicenseManager;
import javax.baja.log.Log;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.LinkCheck;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.util.Lexicon;

public class Util {
    private static final String[] licensedBrands = new String[]{"AAON", "AAONOpen", "Accurex", "airfixture", "Backbox", "DegreeC", "Greenheck", "GreenheckFactory", "HBA", "JENEsys", "JENEsysCL", "lynxspring", "mcquaycontrols", "munters", "snap", "thermozone", "Valent", "Viconics"};
    public static final Lexicon lex = Lexicon.make(Util.class);
    public static final String module = Util.lex.module.getModuleName();
    public static final String noLicense = lex.getText("notLicensed", (Object[])new String[]{module});
    public static final Log log = Log.getLog((String)module);
    private static final LicenseManager license = Sys.getLicenseManager();

    public static void linkFactory(BComponent source, String sourceSlot, BComponent target, String targetSlot) {
        Util.linkFactory(source, source.getSlot(sourceSlot), target, target.getSlot(targetSlot), false);
    }

    public static void linkFactory(BComponent source, Slot sourceSlot, BComponent target, String targetSlot) {
        Util.linkFactory(source, sourceSlot, target, target.getSlot(targetSlot), false);
    }

    public static void linkFactory(BComponent source, String sourceSlot, BComponent target, Slot targetSlot) {
        Util.linkFactory(source, source.getSlot(sourceSlot), target, targetSlot, false);
    }

    public static void linkFactory(BComponent source, Slot sourceSlot, BComponent target, Slot targetSlot) {
        Util.linkFactory(source, sourceSlot, target, targetSlot, false);
    }

    public static void linkFactory(BComponent source, Slot sourceSlot, BComponent target, Slot targetSlot, boolean override) {
        BasicContext cx = new BasicContext();
        LinkCheck check = target.checkLink(source, sourceSlot, targetSlot, (Context)cx);
        if (check.isValid()) {
            BLink link = target.makeLink(source, sourceSlot, targetSlot, (Context)cx);
            target.add(null, (BValue)link);
            link.activate();
        } else if (override) {
            target.getLinks(targetSlot)[0].setSourceOrd(source.getSlotPathOrd());
            target.getLinks(targetSlot)[0].setSourceSlotName(sourceSlot.getName());
        } else {
            log.message("Invalid link not added: " + check.getInvalidReason());
        }
    }

    public static boolean checkLicense() {
        boolean licensed = false;
        try {
            license.checkFeature("Lynxspring", module);
            licensed = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!licensed) {
            try {
                license.checkFeature("Lynxspring", "on");
                licensed = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!licensed) {
                try {
                    String brand = license.checkFeature("Tridium", "brand").get("brandId");
                    for (int i = 0; i < licensedBrands.length; ++i) {
                        if (!brand.equalsIgnoreCase(licensedBrands[i])) continue;
                        licensed = true;
                    }
                }
                catch (Exception e) {
                    log.message(noLicense);
                }
            }
        }
        return licensed;
    }

    public static void notLicensed() {
        log.error(noLicense);
    }

    public static BIcon getIcon(BComplex parent) {
        BIcon bicon;
        BValue bvalue = parent.get("icon");
        if (bvalue instanceof BIcon) {
            return (BIcon)bvalue;
        }
        String icon = lex.getText(parent.getType().getTypeName() + ".icon");
        if (!icon.equals(parent.getType().getTypeName() + ".icon") && !(bicon = BIcon.make((String)icon)).isNull()) {
            return bicon;
        }
        return BIcon.DEFAULT;
    }
}

