/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;
import javax.baja.log.Log;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BTcpTunnel
extends BComponent {
    public static final Property inAddress = BTcpTunnel.newProperty((int)0, (String)"", null);
    public static final Property maxConnections = BTcpTunnel.newProperty((int)0, (int)10, null);
    public static final Property outPort = BTcpTunnel.newProperty((int)0, (int)8855, null);
    public static final Action open = BTcpTunnel.newAction((int)0, null);
    public static final Action close = BTcpTunnel.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BTcpTunnel.class);
    private static final Log log = Log.getLog((String)"TcpTunnel");
    private ServerSocket server;
    private boolean closed = true;
    private Vector tunnels = new Vector();

    public String getInAddress() {
        return this.getString(inAddress);
    }

    public void setInAddress(String v) {
        this.setString(inAddress, v, null);
    }

    public int getMaxConnections() {
        return this.getInt(maxConnections);
    }

    public void setMaxConnections(int v) {
        this.setInt(maxConnections, v, null);
    }

    public int getOutPort() {
        return this.getInt(outPort);
    }

    public void setOutPort(int v) {
        this.setInt(outPort, v, null);
    }

    public void open() {
        this.invoke(open, null, null);
    }

    public void close() {
        this.invoke(close, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.open();
    }

    public void stopped() {
        this.close();
    }

    public void doOpen() {
        this.closed = false;
        try {
            this.server = new ServerSocket(this.getOutPort());
            new Thread(){

                @Override
                public void run() {
                    block3: {
                        try {
                            while (!BTcpTunnel.this.closed) {
                                BTcpTunnel.this.addTunnel(BTcpTunnel.this.server.accept());
                            }
                        }
                        catch (Exception e) {
                            if (BTcpTunnel.this.closed) break block3;
                            log.error("Error creating tunnel", (Throwable)e);
                        }
                    }
                    BTcpTunnel.this.doClose();
                }
            }.start();
        }
        catch (Exception e) {
            log.error("Error opening server socket", (Throwable)e);
        }
    }

    public void doClose() {
        this.closed = true;
        if (this.server == null) {
            log.warning("TCP Tunnel Connection already closed");
        } else {
            Object[] obj = this.tunnels.toArray();
            for (int i = 0; i < obj.length; ++i) {
                ((Tunnel)obj[i]).close();
            }
            try {
                this.server.close();
            }
            catch (Exception e) {
                log.error("Error closing server socket", (Throwable)e);
            }
            this.server = null;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    private void addTunnel(Socket sock) throws IOException {
        if (this.tunnels.size() < this.getMaxConnections()) {
            this.tunnels.add(new Tunnel(sock));
        } else {
            log.message("Exceeded connection count, ignoring request");
        }
    }

    private class TunnelThread
    extends Thread {
        private byte[] buf = new byte[4096];
        InputStream in;
        OutputStream out;
        Tunnel tunnel;

        TunnelThread(Tunnel tunnel, InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
            this.tunnel = tunnel;
        }

        @Override
        public void run() {
            block4: {
                try {
                    int r;
                    while (!BTcpTunnel.this.closed && (r = this.in.read(this.buf)) != -1) {
                        this.out.write(this.buf, 0, r);
                    }
                }
                catch (Exception e) {
                    if (this.tunnel.closed) break block4;
                    e.printStackTrace();
                }
            }
            if (!this.tunnel.closed) {
                this.tunnel.close();
            }
        }

        void close() {
            try {
                this.in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class Tunnel {
        private boolean closed = false;
        private TunnelThread inThread;
        private TunnelThread outThread;
        private Socket serv;

        Tunnel(Socket client) throws IOException {
            log.message("New connection");
            String[] addr = TextUtil.split((String)BTcpTunnel.this.getInAddress(), (char)':');
            this.serv = new Socket(addr[0], Integer.parseInt(addr[1], 10));
            this.inThread = new TunnelThread(this, client.getInputStream(), this.serv.getOutputStream());
            this.outThread = new TunnelThread(this, this.serv.getInputStream(), client.getOutputStream());
            this.inThread.start();
            this.outThread.start();
        }

        void close() {
            this.closed = true;
            log.message("Closed connection");
            this.inThread.close();
            this.outThread.close();
            try {
                this.serv.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (BTcpTunnel.this.tunnels.contains(this)) {
                BTcpTunnel.this.tunnels.remove(this);
            }
        }
    }
}

