/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Random;
import javax.baja.log.Log;
import javax.baja.nre.util.Base64;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.sys.BIComparable;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BEncryptedString
extends BSimple
implements BIComparable {
    public static final BEncryptedString DEFAULT = new BEncryptedString("");
    public static final Type TYPE = Sys.loadType(BEncryptedString.class);
    private static Log log = Log.getLog((String)"lynxKitControl");
    private String value;
    private static final byte[] secret = new byte[]{-112, 44, -73, 64, -68, -111, 38, 103, -127, 102, 78, -83, -28, 98, -73, 55, 106, -45, 76, -88, -45, 28, -101, 15, 99, 5, 53, 111, -55, -95, -73, 70, -111, -125, -24, -67, -1, 64, -34, -43, -88, 100, 37, 38, -14, 27, -13, -103, -74, -82, -97, -32, 120, -69, -90, -6, -118, -91, -109, -75, 77, 24, 99, 93, 43, -58, 35, 123, -21, 102, 53, 26, 68, -27, -29, 71, -11, 124, 101, 118, 113, -113, 36, 105, 122, 54, -96, -1, -59, -75, -116, -126, -40, -21, -53, 12, 15, -82, -86, -123, 7, 93, -93, -128, -95, -19, 27, 50, -103, -123, -83, 104, -91, 118, -80, -12, -78, 36, -57, 15, 71, 3, -92, -87, -72, 118, -41, -1, 64, 95, 12, 80, -97, 58, -115, -30, 121, 103, -57, -122, -16, -78, -42, 28, -18, -96, 33, -3, -4, 114, 64, 107, -8, -110, -6, 100, -32, -126, 87, 68, -107, -34, 0, -5, 66, 73, 46, 22, 126, -69, -20, 78, -19, -57, 61, -6, 0, -27, -21, -24, -70, -96, -63, -40, -16, 99, -110, -89, 102, 26, -93, -128, 58, -40, -52, -88, 66, -119, 106, 18, -45, 59, 76, -124, -24, 37, 22, -66, 31, 98, 98, 57, 80, 12, -73, 107, 0, 2, 88, 106, 3, -24, 72, 104, 47, -74, -25, 101, 55, 70, -67, -13, -109, 94, 96, 106, 29, -75, 17, -125, -91, 126, 24, -2, -87, 79, 55, 103, 41, -24, -37, 56, -106, 39, 125, 3};
    private static Random random = new Random();
    private static int randomCount = 0;

    public static BEncryptedString make(String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        return new BEncryptedString(value);
    }

    private BEncryptedString(String value) {
        this.value = value;
    }

    public String getString() {
        return this.value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof BEncryptedString) {
            return this.value.equals(((BEncryptedString)((Object)obj)).value);
        }
        return false;
    }

    public int compareTo(Object obj) {
        return this.value.compareTo(((BEncryptedString)((Object)obj)).getString());
    }

    public String toString(Context context) {
        return "--encrypted--";
    }

    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    public BObject decode(DataInput in) throws IOException {
        String s = in.readUTF();
        if (s.equals("")) {
            return DEFAULT;
        }
        return this.decodeFromString(s);
    }

    public String encodeToString() throws IOException {
        if (this.value.equals("")) {
            return "";
        }
        try {
            return BEncryptedString.encrypt(this.value);
        }
        catch (Exception e) {
            if (log.isTraceOn()) {
                e.printStackTrace();
                log.trace(e.getMessage());
            }
            return "";
        }
    }

    public BObject decodeFromString(String s) throws IOException {
        if (s.equals("")) {
            return DEFAULT;
        }
        try {
            return BEncryptedString.make(BEncryptedString.decrypt(s));
        }
        catch (Exception e) {
            if (log.isTraceOn()) {
                e.printStackTrace();
                log.trace(e.getMessage());
            }
            return BEncryptedString.make("");
        }
    }

    public Type getType() {
        return TYPE;
    }

    public static String encrypt(String s) throws IOException {
        byte[] data = BEncryptedString.encryptScheme0(s);
        byte[] wrapper = new byte[data.length + 1];
        wrapper[0] = 0;
        System.arraycopy(data, 0, wrapper, 1, data.length);
        String r = Base64.encode((byte[])wrapper, (int)-1);
        return r;
    }

    public static String decrypt(String s) throws IOException {
        ByteBuffer buf = new ByteBuffer(Base64.decode((String)s));
        int scheme = buf.read();
        byte[] data = new byte[buf.getLength() - 1];
        buf.read(data);
        switch (scheme) {
            case 0: {
                return BEncryptedString.decryptScheme0(data);
            }
        }
        throw new IOException("Bad password");
    }

    public static byte[] encryptScheme0(String s) {
        int rawLength = s.length() * 2;
        int len = 4 + rawLength + rawLength % 16;
        byte[] data = new byte[len];
        int slen = secret.length;
        int si = Math.abs(random.nextInt() + randomCount) % slen;
        randomCount *= 11;
        int esi = ((si << 17) + 374573) * 3 ^ 0x7E9AB3E2;
        data[0] = (byte)(esi >>> 24 & 0xFF);
        data[1] = (byte)(esi >>> 16 & 0xFF);
        data[2] = (byte)(esi >>> 8 & 0xFF);
        data[3] = (byte)(esi & 0xFF);
        int n = 4;
        for (int i = s.length() - 1; i >= 0; --i) {
            char c = s.charAt(i);
            if (c == '\u0000') {
                throw new IllegalStateException("Illegal string");
            }
            data[n++] = (byte)(c >>> 8 & 0xFF);
            data[n++] = (byte)(c & 0xFF);
        }
        int pad = randomCount;
        randomCount += 3;
        n += 2;
        while (n < data.length) {
            data[n++] = (byte)(pad ^ secret[n % secret.length]);
        }
        int i = 4;
        while (i < data.length) {
            int n2 = i++;
            data[n2] = (byte)(data[n2] ^ secret[si++ % slen]);
        }
        return data;
    }

    public static String decryptScheme0(byte[] data) {
        int n;
        int slen = secret.length;
        int esi = ((data[0] & 0xFF) << 24) + ((data[1] & 0xFF) << 16) + ((data[2] & 0xFF) << 8) + (data[3] & 0xFF);
        int si = (esi ^ 0x7E9AB3E2) / 3 - 374573 >> 17;
        int i = 4;
        while (i < data.length) {
            int n2 = i++;
            data[n2] = (byte)(data[n2] ^ secret[si++ % slen]);
        }
        for (n = 4; n < data.length && (data[n] != 0 || data[n + 1] != 0); ++n) {
        }
        int len = (n - 4) / 2;
        char[] chars = new char[len];
        for (int i2 = 0; i2 < len; ++i2) {
            char c;
            int x = i2 * 2 + 4;
            chars[len - i2 - 1] = c = (char)(((data[x] & 0xFF) << 8) + (data[x + 1] & 0xFF));
        }
        return new String(chars);
    }
}

