/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.util;

import com.lynxspring.control.util.BDynamicHistoryRecord;
import javax.baja.agent.AgentList;
import javax.baja.data.BIDataValue;
import javax.baja.history.BCollectionInterval;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.BIHistorySource;
import javax.baja.history.BStringTrendRecord;
import javax.baja.history.HistoryException;
import javax.baja.history.HistoryNotFoundException;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.space.BComponentSpace;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BFormat;
import javax.baja.util.BTypeSpec;

public class BDynamicHistoryComponent
extends BComponent
implements BIHistorySource {
    public static final Property status = BDynamicHistoryComponent.newProperty((int)3, (BValue)BStatus.ok, null);
    public static final Property faultCause = BDynamicHistoryComponent.newProperty((int)3, (String)"", null);
    public static final Property enabled = BDynamicHistoryComponent.newProperty((int)64, (boolean)false, null);
    public static final Property interval = BDynamicHistoryComponent.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)15), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)1L)));
    public static final Property dyn1 = BDynamicHistoryComponent.newProperty((int)8, (BValue)new BStatusNumeric(), null);
    public static final Property dyn1Facets = BDynamicHistoryComponent.newProperty((int)0, (BValue)BFacets.makeNumeric((int)1), null);
    public static final Property dyn2 = BDynamicHistoryComponent.newProperty((int)8, (BValue)new BStatusNumeric(), null);
    public static final Property dyn2Facets = BDynamicHistoryComponent.newProperty((int)0, (BValue)BFacets.makeNumeric((int)1), null);
    public static final Property dyn3 = BDynamicHistoryComponent.newProperty((int)8, (BValue)new BStatusNumeric(), null);
    public static final Property dyn3Facets = BDynamicHistoryComponent.newProperty((int)0, (BValue)BFacets.makeNumeric((int)1), null);
    public static final Property dyn4 = BDynamicHistoryComponent.newProperty((int)8, (BValue)new BStatusNumeric(), null);
    public static final Property dyn4Facets = BDynamicHistoryComponent.newProperty((int)0, (BValue)BFacets.makeNumeric((int)1), null);
    public static final Property dyn5 = BDynamicHistoryComponent.newProperty((int)8, (BValue)new BStatusNumeric(), null);
    public static final Property dyn5Facets = BDynamicHistoryComponent.newProperty((int)0, (BValue)BFacets.makeNumeric((int)1), null);
    public static final Property dyn6 = BDynamicHistoryComponent.newProperty((int)8, (BValue)new BStatusNumeric(), null);
    public static final Property dyn6Facets = BDynamicHistoryComponent.newProperty((int)0, (BValue)BFacets.makeNumeric((int)1), null);
    public static final Property historyName = BDynamicHistoryComponent.newProperty((int)0, (BValue)BFormat.make((String)"%name%"), null);
    public static final Property historyConfig = BDynamicHistoryComponent.newProperty((int)0, (BValue)new BHistoryConfig(), null);
    public static final Property lastRecord = BDynamicHistoryComponent.newProperty((int)1, (BValue)new BStringTrendRecord(), null);
    public static final Action updateHistoryId = BDynamicHistoryComponent.newAction((int)16, null);
    public static final Action syncConfig = BDynamicHistoryComponent.newAction((int)20, null);
    public static final Action intervalElapsed = BDynamicHistoryComponent.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BDynamicHistoryComponent.class);
    private static final BIcon icon = BIcon.std((String)"history.png");
    public static final Log log = Log.getLog((String)"vav.trend");
    private boolean start = true;
    private BIHistory history;
    private HistorySpaceConnection ghsc = null;
    private boolean initHistorySuccessful = false;
    private BAbsTime nextValidThreshold = null;
    private Clock.Ticket intervalTicket;
    private Object lock = new Object();
    private BDynamicHistoryRecord rec = new BDynamicHistoryRecord();
    private BHistoryService service;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BRelTime getInterval() {
        return (BRelTime)this.get(interval);
    }

    public void setInterval(BRelTime v) {
        this.set(interval, (BValue)v, null);
    }

    public BStatusNumeric getDyn1() {
        return (BStatusNumeric)this.get(dyn1);
    }

    public void setDyn1(BStatusNumeric v) {
        this.set(dyn1, (BValue)v, null);
    }

    public BFacets getDyn1Facets() {
        return (BFacets)this.get(dyn1Facets);
    }

    public void setDyn1Facets(BFacets v) {
        this.set(dyn1Facets, (BValue)v, null);
    }

    public BStatusNumeric getDyn2() {
        return (BStatusNumeric)this.get(dyn2);
    }

    public void setDyn2(BStatusNumeric v) {
        this.set(dyn2, (BValue)v, null);
    }

    public BFacets getDyn2Facets() {
        return (BFacets)this.get(dyn2Facets);
    }

    public void setDyn2Facets(BFacets v) {
        this.set(dyn2Facets, (BValue)v, null);
    }

    public BStatusNumeric getDyn3() {
        return (BStatusNumeric)this.get(dyn3);
    }

    public void setDyn3(BStatusNumeric v) {
        this.set(dyn3, (BValue)v, null);
    }

    public BFacets getDyn3Facets() {
        return (BFacets)this.get(dyn3Facets);
    }

    public void setDyn3Facets(BFacets v) {
        this.set(dyn3Facets, (BValue)v, null);
    }

    public BStatusNumeric getDyn4() {
        return (BStatusNumeric)this.get(dyn4);
    }

    public void setDyn4(BStatusNumeric v) {
        this.set(dyn4, (BValue)v, null);
    }

    public BFacets getDyn4Facets() {
        return (BFacets)this.get(dyn4Facets);
    }

    public void setDyn4Facets(BFacets v) {
        this.set(dyn4Facets, (BValue)v, null);
    }

    public BStatusNumeric getDyn5() {
        return (BStatusNumeric)this.get(dyn5);
    }

    public void setDyn5(BStatusNumeric v) {
        this.set(dyn5, (BValue)v, null);
    }

    public BFacets getDyn5Facets() {
        return (BFacets)this.get(dyn5Facets);
    }

    public void setDyn5Facets(BFacets v) {
        this.set(dyn5Facets, (BValue)v, null);
    }

    public BStatusNumeric getDyn6() {
        return (BStatusNumeric)this.get(dyn6);
    }

    public void setDyn6(BStatusNumeric v) {
        this.set(dyn6, (BValue)v, null);
    }

    public BFacets getDyn6Facets() {
        return (BFacets)this.get(dyn6Facets);
    }

    public void setDyn6Facets(BFacets v) {
        this.set(dyn6Facets, (BValue)v, null);
    }

    public BFormat getHistoryName() {
        return (BFormat)this.get(historyName);
    }

    public void setHistoryName(BFormat v) {
        this.set(historyName, (BValue)v, null);
    }

    public BHistoryConfig getHistoryConfig() {
        return (BHistoryConfig)this.get(historyConfig);
    }

    public void setHistoryConfig(BHistoryConfig v) {
        this.set(historyConfig, (BValue)v, null);
    }

    public BHistoryRecord getLastRecord() {
        return (BHistoryRecord)this.get(lastRecord);
    }

    public void setLastRecord(BHistoryRecord v) {
        this.set(lastRecord, (BValue)v, null);
    }

    public void updateHistoryId() {
        this.invoke(updateHistoryId, null, null);
    }

    public void syncConfig() {
        this.invoke(syncConfig, null, null);
    }

    public void intervalElapsed() {
        this.invoke(intervalElapsed, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BOrd getSourceOrd() {
        BComponentSpace cs = this.getComponentSpace();
        if (cs == null) {
            return null;
        }
        BOrd base = cs.getOrdInSession();
        if (base == null) {
            return null;
        }
        return BOrd.make((BOrd)base, (BOrd)this.getSlotPathOrd());
    }

    public void started() throws Exception {
        super.started();
        BTypeSpec ts = BDynamicHistoryRecord.TYPE.getTypeSpec();
        BHistoryConfig config = this.getHistoryConfig();
        if (!config.getRecordType().equals((Object)ts)) {
            config.setRecordType(ts);
        }
        if (this.isValidInterval(this.getInterval())) {
            BCollectionInterval collectionInterval = BCollectionInterval.make((BRelTime)this.getInterval());
            if (!this.getHistoryConfig().getInterval().equals((Object)collectionInterval)) {
                this.getHistoryConfig().setInterval(collectionInterval);
            }
        }
    }

    public void atSteadyState() {
        this.init();
    }

    private void init() {
        if (this.getEnabled()) {
            try {
                this.initHistory();
            }
            catch (Exception ex) {
                this.setFault(ex);
                return;
            }
        }
        this.updateStatus();
        this.scheduleCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopped() throws Exception {
        super.stopped();
        this.history = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.intervalTicket != null) {
                this.intervalTicket.cancel();
                this.intervalTicket = null;
            }
        }
    }

    public void changed(Property p, Context c) {
        if (c == Context.decoding) {
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        if (this.service == null) {
            try {
                this.service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            }
            catch (ServiceNotFoundException e) {
                return;
            }
        }
        if (p.equals(enabled)) {
            if (this.getEnabled()) {
                this.init();
            } else {
                this.history = null;
                this.updateStatus();
            }
        } else if (p.equals(historyName)) {
            this.initHistory();
        } else if (p.equals(interval)) {
            if (!this.isValidInterval(this.getInterval())) {
                return;
            }
            this.getHistoryConfig().setInterval(BCollectionInterval.make((BRelTime)this.getInterval()));
            this.scheduleCollection();
        } else if (!p.equals(status) && !p.equals(faultCause)) {
            this.updateStatus();
        }
    }

    public void updateStatus() {
        if (!this.getEnabled()) {
            this.setStatus(BStatus.disabled);
            this.setFaultCause("");
        } else {
            boolean validName = this.getHistoryConfig().getId().isValid();
            if (!validName) {
                this.setStatus(BStatus.fault);
                this.setFaultCause("Invalid history name.");
            } else if (this.initHistorySuccessful) {
                if (this.nextValidThreshold != null) {
                    this.setStatus(BStatus.fault);
                    this.setFaultCause("Cannot append out-of-order or duplicate record. This could occur on a backwards system clock change. Next append can occur after " + this.nextValidThreshold);
                } else {
                    this.setStatus(BStatus.ok);
                    this.setFaultCause("");
                }
            } else {
                this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)false));
            }
        }
        if (this.getStatus().isFault()) {
            return;
        }
        if (!this.isValidInterval(this.getInterval())) {
            BStatus newStatus = BStatus.makeFault((BStatus)this.getStatus(), (boolean)true);
            if (!this.getStatus().equals((Object)newStatus)) {
                this.setStatus(newStatus);
                this.setFaultCause("Invalid interval: " + this.getInterval().toString());
            }
        } else {
            this.setFaultCause("");
        }
    }

    public BIHistory getHistory() {
        return this.history;
    }

    public String resolveHistoryName() {
        BFormat pattern = this.getHistoryName();
        return SlotPath.escape((String)SlotPath.unescape((String)pattern.format((Object)this)));
    }

    private synchronized void initHistory() throws ServiceNotFoundException {
        this.initHistorySuccessful = false;
        try {
            BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            BHistoryDatabase db = service.getDatabase();
            HistorySpaceConnection hsc = db.getConnection(Context.NULL);
            HistoryDatabaseConnection hdc = db.getDbConnection(Context.NULL);
            BHistoryConfig config = this.getHistoryConfig();
            BOrdList source = BOrdList.make((BOrd)this.getSourceOrd());
            BOrd handleOrd = this.getHandleOrd();
            if (!config.getSource().equals((Object)source)) {
                config.setSource(source);
            }
            if (!config.getSourceHandle().equals((Object)handleOrd)) {
                config.setSourceHandle(handleOrd);
            }
            if (!config.getTimeZone().equals((Object)BTimeZone.getLocal())) {
                config.setTimeZone(BTimeZone.getLocal());
            }
            String historyName = this.resolveHistoryName();
            BHistoryId.validateName((String)historyName);
            BHistoryId newId = BHistoryId.make((String)Sys.getStation().getStationName(), (String)historyName);
            BHistoryId id = config.getId();
            if (!id.getHistoryName().equals(newId.getHistoryName()) && !id.isNull()) {
                this.renameAttachedHistory(db, id, newId);
            }
            if (!id.equals((Object)newId)) {
                config.setId(newId);
                id = newId;
            }
            if (!hsc.exists(id) && this.getEnabled()) {
                hsc.createHistory(config);
            } else if (hsc.exists(id)) {
                BIHistory existing = hsc.getHistory(id);
                BHistoryConfig existingCfg = existing.getConfig();
                BOrdList historySrc = existingCfg.getSource();
                if (historySrc.size() != 1) {
                    throw new HistoryException("Duplicate history id: " + config.getId() + ". Source mismatch.");
                }
                BOrd extOrd = historySrc.get(0);
                BObject src = null;
                try {
                    src = extOrd.resolve((BObject)this).get();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (src != null && src != this) {
                    throw new HistoryException("Duplicate history id: " + config.getId());
                }
                hdc.reconfigureHistory(config);
            }
            if (this.getEnabled()) {
                this.history = hsc.getHistory(id);
                this.ghsc = hsc;
                if (this.history == null) {
                    throw new HistoryException("Cannot open history: " + id);
                }
            }
        }
        catch (Exception ex) {
            this.setFault(ex);
            return;
        }
        this.setFault(false, "");
        if (this.getEnabled()) {
            this.initHistorySuccessful = true;
        }
    }

    public void historyConfigChanged(BHistoryConfig config, Property p) {
        if (!this.isRunning()) {
            return;
        }
        if (config != this.getHistoryConfig()) {
            return;
        }
        this.updateStatus();
        this.syncConfig();
    }

    private void renameAttachedHistory(BHistoryDatabase db, BHistoryId oldId, BHistoryId newId) {
        HistorySpaceConnection hsc = db.getConnection(Context.NULL);
        BIHistory newHistory = hsc.getHistory(newId);
        if (newHistory != null) {
            BHistoryConfig newCfg = newHistory.getConfig();
            BOrdList newSrc = newCfg.getSource();
            BOrd newHandle = newCfg.getSourceHandle();
            if (newSrc.size() != 1 || !newHandle.isNull() && !newHandle.equals((Object)this.getHandleOrd())) {
                throw new HistoryException("Cannot rename attached history.  The target id is already in use.");
            }
            log.warning("Rename failed for " + oldId + ".  New data will be written to " + newId);
            return;
        }
        BIHistory oldHistory = hsc.getHistory(oldId);
        if (oldHistory == null) {
            return;
        }
        BHistoryConfig config = oldHistory.getConfig();
        BOrdList src = config.getSource();
        BOrd handle = config.getSourceHandle();
        if (src.size() != 1) {
            return;
        }
        if (!handle.isNull() && !handle.equals((Object)this.getHandleOrd())) {
            return;
        }
        hsc.renameHistory(oldId, newId.getHistoryName());
    }

    public void doUpdateHistoryId() {
        BHistoryId newId;
        String newName = this.resolveHistoryName();
        BHistoryId id = this.getHistoryConfig().getId();
        if (!id.equals((Object)(newId = BHistoryId.make((String)Sys.getStation().getStationName(), (String)newName)))) {
            this.initHistory();
        }
    }

    public synchronized void doSyncConfig() {
        if (this.initHistorySuccessful) {
            BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            HistoryDatabaseConnection dbc = service.getDatabase().getDbConnection(Context.NULL);
            dbc.reconfigureHistory(this.getHistoryConfig());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRecord() {
        if (!this.getEnabled()) {
            return;
        }
        if (this.isRunning() && Sys.atSteadyState()) {
            this.rec.set(BAbsTime.make(), this.writeVal(this.getDyn1().toString((Context)this.getDyn1Facets())), this.writeVal(this.getDyn2().toString((Context)this.getDyn2Facets())), this.writeVal(this.getDyn3().toString((Context)this.getDyn3Facets())), this.writeVal(this.getDyn4().toString((Context)this.getDyn4Facets())), this.writeVal(this.getDyn5().toString((Context)this.getDyn5Facets())), this.writeVal(this.getDyn6().toString((Context)this.getDyn6Facets())), this.start);
            for (int i = 0; i < 2; ++i) {
                try {
                    BDynamicHistoryComponent bDynamicHistoryComponent = this;
                    synchronized (bDynamicHistoryComponent) {
                        if (this.history == null) {
                            this.initHistory();
                        }
                        if (this.history != null) {
                            BAbsTime recTimestamp = this.rec.getTimestamp();
                            BAbsTime lastTimestamp = this.ghsc.getLastTimestamp(this.history);
                            this.nextValidThreshold = lastTimestamp != null && !lastTimestamp.isNull() && !recTimestamp.isAfter(lastTimestamp.add(BRelTime.makeMinutes((int)1))) ? lastTimestamp : null;
                            if (this.nextValidThreshold == null) {
                                this.ghsc.append(this.history, (BIHistoryRecordSet)this.rec);
                                this.start = false;
                                this.setLastRecord((BHistoryRecord)this.rec.newCopy());
                            }
                        }
                    }
                    if (this.history == null) break;
                    this.updateStatus();
                    break;
                }
                catch (HistoryNotFoundException ex) {
                    if (i == 0) {
                        this.initHistory();
                        continue;
                    }
                    boolean wasFault = this.getStatus().isFault();
                    this.setFault(ex);
                    if (wasFault) break;
                    throw ex;
                }
                catch (Exception ex) {
                    boolean wasFault = this.getStatus().isFault();
                    this.setFault(ex);
                    if (wasFault) break;
                    if (ex instanceof HistoryException) {
                        throw (HistoryException)ex;
                    }
                    throw new HistoryException((Throwable)ex);
                }
            }
        }
    }

    private String writeVal(String val) {
        return val.substring(0, val.indexOf(123) - 1);
    }

    private void setFault(boolean fault, String cause) {
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)fault));
        this.setFaultCause(cause);
    }

    private void setFault(Throwable ex) {
        String msg;
        if (!(ex instanceof HistoryException)) {
            log.error(this.getHistoryConfig().getId().toString(), ex);
        }
        if ((msg = ex.getMessage()) == null || msg.length() == 0) {
            msg = ex.getClass().getName();
        }
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
        this.setFaultCause(msg);
    }

    public AgentList getAgents(Context cx) {
        AgentList list = super.getAgents(cx);
        list.toTop("workbench:PropertySheet");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleCollection() {
        BAbsTime start = null;
        BRelTime interval = this.getInterval();
        try {
            if (!this.isValidInterval(interval)) {
                return;
            }
            BAbsTime now = BAbsTime.make();
            start = now.subtract(BRelTime.make((long)now.getMillisecond()));
            start = start.subtract(BRelTime.makeSeconds((int)start.getSecond()));
            start = start.subtract(BRelTime.makeMinutes((int)start.getMinute()));
            while (start.isBefore(now)) {
                start = start.add(interval);
            }
            if (this.start && BAbsTime.make().add(BRelTime.makeMinutes((int)1)).isAfter(start)) {
                start = start.add(interval);
            }
            String s = "Collection scheduled. (start=" + start.toString((Context)BHistoryRecord.TIMESTAMP_FACETS) + ", interval=" + this.getInterval().toString((Context)BHistoryRecord.TIMESTAMP_FACETS) + ")";
            log.message(s);
        }
        catch (RuntimeException e) {
            Object object = this.lock;
            synchronized (object) {
                if (this.intervalTicket != null) {
                    this.intervalTicket.cancel();
                    this.intervalTicket = null;
                }
            }
            throw e;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.intervalTicket != null) {
                this.intervalTicket.cancel();
                this.intervalTicket = null;
            }
            if (this.isRunning()) {
                if (this.start) {
                    this.writeRecord();
                }
                this.intervalTicket = Clock.schedulePeriodically((BComponent)this, (BAbsTime)start, (BRelTime)interval, (Action)intervalElapsed, null);
            }
        }
    }

    public void doIntervalElapsed() {
        try {
            this.writeRecord();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clockChanged(BRelTime shift) throws Exception {
        super.clockChanged(shift);
        this.scheduleCollection();
    }

    private boolean isValidInterval(BRelTime interval) {
        return interval.getMillis() > 0L;
    }

    public BFacets getSlotFacets(Slot s) {
        if (s == dyn1) {
            return this.getDyn1Facets();
        }
        if (s == dyn2) {
            return this.getDyn2Facets();
        }
        if (s == dyn3) {
            return this.getDyn3Facets();
        }
        if (s == dyn4) {
            return this.getDyn4Facets();
        }
        if (s == dyn5) {
            return this.getDyn5Facets();
        }
        if (s == dyn6) {
            return this.getDyn6Facets();
        }
        return super.getSlotFacets(s);
    }

    public BIcon getIcon() {
        return icon;
    }
}

