/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.util;

import javax.baja.status.BStatusBoolean;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

public class BBooleanTrigger
extends BComponent {
    public static final Property in = BBooleanTrigger.newProperty((int)8, (boolean)false, null);
    public static final Property trueTopicValue = BBooleanTrigger.newProperty((int)0, (BValue)new BStatusBoolean(true), null);
    public static final Property falseTopicValue = BBooleanTrigger.newProperty((int)0, (BValue)new BStatusBoolean(false), null);
    public static final Property triggerInterval = BBooleanTrigger.newProperty((int)0, (BValue)BRelTime.make((long)0L), null);
    public static final Action trigger = BBooleanTrigger.newAction((int)4, null);
    public static final Topic trueTrigger = BBooleanTrigger.newTopic((int)8, null);
    public static final Topic falseTrigger = BBooleanTrigger.newTopic((int)8, null);
    public static final Type TYPE = Sys.loadType(BBooleanTrigger.class);
    private Clock.Ticket triggerTicket;

    public boolean getIn() {
        return this.getBoolean(in);
    }

    public void setIn(boolean v) {
        this.setBoolean(in, v, null);
    }

    public BValue getTrueTopicValue() {
        return this.get(trueTopicValue);
    }

    public void setTrueTopicValue(BValue v) {
        this.set(trueTopicValue, v, null);
    }

    public BValue getFalseTopicValue() {
        return this.get(falseTopicValue);
    }

    public void setFalseTopicValue(BValue v) {
        this.set(falseTopicValue, v, null);
    }

    public BRelTime getTriggerInterval() {
        return (BRelTime)this.get(triggerInterval);
    }

    public void setTriggerInterval(BRelTime v) {
        this.set(triggerInterval, (BValue)v, null);
    }

    public void trigger() {
        this.invoke(trigger, null, null);
    }

    public void fireTrueTrigger(BValue event) {
        this.fire(trueTrigger, event, null);
    }

    public void fireFalseTrigger(BValue event) {
        this.fire(falseTrigger, event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning() || cx == Context.decoding) {
            return;
        }
        if (p == in) {
            this.doTrigger();
        }
        if (p == triggerInterval) {
            if (!this.triggerTicket.isExpired()) {
                this.triggerTicket.cancel();
                this.triggerTicket = Clock.expiredTicket;
            }
            if (this.getTriggerInterval() != BRelTime.DEFAULT) {
                this.triggerTicket = Clock.schedule((BComponent)this, (BRelTime)this.getTriggerInterval(), (Action)trigger, null);
            }
        }
    }

    public void started() throws Exception {
        this.triggerTicket = Clock.expiredTicket;
        super.started();
    }

    public void doTrigger() {
        if (!this.triggerTicket.isExpired()) {
            this.triggerTicket.cancel();
            this.triggerTicket = Clock.expiredTicket;
        }
        if (this.getIn()) {
            this.fireTrueTrigger(this.getTrueTopicValue());
        } else {
            this.fireFalseTrigger(this.getFalseTopicValue());
        }
        if (this.getTriggerInterval() != BRelTime.DEFAULT) {
            this.triggerTicket = Clock.schedule((BComponent)this, (BRelTime)this.getTriggerInterval(), (Action)trigger, null);
        }
    }
}

