/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.select;

import com.lynxspring.control.BLicensedComponent;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLink;
import javax.baja.sys.BModule;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public abstract class BNarySelect
extends BLicensedComponent {
    public static final Property facets = BNarySelect.newProperty((int)0, (BValue)BFacets.DEFAULT, null);
    public static final Property propagateFlags = BNarySelect.newProperty((int)0, (BValue)BStatus.nullStatus, null);
    public static final Property select = BNarySelect.newProperty((int)266, (BValue)new BStatusEnum(), null);
    public static final Property inputCount = BNarySelect.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt((int)0, (int)Integer.MAX_VALUE));
    public static final Property zeroBasedSelect = BNarySelect.newProperty((int)0, (boolean)false, null);
    public static final Action setNumberOfInputs = BNarySelect.newAction((int)0, (BValue)BInteger.make((int)0), null);
    public static final Type TYPE = Sys.loadType(BNarySelect.class);
    private static final BIcon icon = BIcon.std((String)"control/util/switch.png");
    private static final String inPrefix = "In$20";
    private static final String invalidFacet = Lexicon.make((BModule)TYPE.getModule(), (String)Sys.getLanguage()).getText("invalidSelect");

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    public BStatus getPropagateFlags() {
        return (BStatus)this.get(propagateFlags);
    }

    public void setPropagateFlags(BStatus v) {
        this.set(propagateFlags, (BValue)v, null);
    }

    public BStatusEnum getSelect() {
        return (BStatusEnum)this.get(select);
    }

    public void setSelect(BStatusEnum v) {
        this.set(select, (BValue)v, null);
    }

    public int getInputCount() {
        return this.getInt(inputCount);
    }

    public void setInputCount(int v) {
        this.setInt(inputCount, v, null);
    }

    public boolean getZeroBasedSelect() {
        return this.getBoolean(zeroBasedSelect);
    }

    public void setZeroBasedSelect(boolean v) {
        this.setBoolean(zeroBasedSelect, v, null);
    }

    public void setNumberOfInputs(BInteger arg) {
        this.invoke(setNumberOfInputs, (BValue)arg, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() {
        this.checkInputs();
        super.started();
        if (!this.isRunning() || !this.isLicensed()) {
            return;
        }
    }

    public void changed(Property p, Context cx) {
        if (cx == Context.decoding) {
            return;
        }
        if (p == inputCount) {
            this.checkInputs();
        }
        if (!this.isRunning() || !this.isLicensed()) {
            return;
        }
        if (p.getName().startsWith(inPrefix) || p.equals(select) || p.equals(propagateFlags) || p.equals(zeroBasedSelect)) {
            this.calculate();
        }
    }

    private void checkInputs() {
        int min;
        int inCount = 0;
        Property[] props = this.getDynamicPropertiesArray();
        for (int i = 0; i < props.length; ++i) {
            if (!this.get(props[i]).getType().is(this.getInputType()) || !props[i].getName().startsWith(inPrefix)) continue;
            ++inCount;
        }
        if (inCount == this.getInputCount()) {
            return;
        }
        int max = Math.max(inCount, this.getInputCount()) + 1;
        for (int i = min = Math.min(inCount, this.getInputCount()) + 1; i < max; ++i) {
            if (i > this.getInputCount()) {
                this.remove(inPrefix + i);
                continue;
            }
            this.add(inPrefix + i, (BValue)this.initStatusValue(), 8);
        }
    }

    public void removed(Property p, BValue v, Context cx) {
        BValue in;
        if (v instanceof BLink && ((BLink)v).getTargetSlotName().startsWith(inPrefix) && (in = this.get(((BLink)v).getTargetSlotName())) instanceof BStatusValue) {
            ((BStatusValue)in).setStatus(BStatus.nullStatus);
        }
    }

    public void doSetNumberOfInputs(BInteger value) {
        this.setInputCount(value.getInt());
    }

    public BValue getActionParameterDefault(Action action) {
        if (action == setNumberOfInputs) {
            int result = this.getInputCount();
            if (result < 2) {
                result = 2;
            }
            return BInteger.make((int)result);
        }
        return super.getActionParameterDefault(action);
    }

    public abstract BStatusValue initStatusValue();

    public abstract BStatus getOutStatus();

    public abstract void setOutStatus(BStatus var1);

    public abstract void setOutput(BStatusValue var1);

    public abstract Type getInputType();

    public void calculate() {
        if (this.getSelect().getStatus().isValid()) {
            int selectValue = this.getSelect().getValue().getOrdinal();
            if (this.getZeroBasedSelect()) {
                ++selectValue;
            }
            int maxSelect = this.getInputCount();
            if (selectValue < 1) {
                selectValue = 1;
            } else if (selectValue >= maxSelect) {
                selectValue = maxSelect;
            }
            BStatusValue workingValue = (BStatusValue)this.get(inPrefix + selectValue);
            workingValue = workingValue == null ? this.initStatusValue() : (BStatusValue)workingValue.newCopy();
            workingValue.setStatus(this.propagate(workingValue.getStatus()));
            this.setOutput(workingValue);
            BStatus s = this.getOutStatus();
            this.setOutStatus(BStatus.make((int)s.getBits(), (BFacets)BFacets.makeRemove((BFacets)s.getFacets(), (String)invalidFacet)));
        } else {
            this.setOutStatus(BStatus.make((BStatus)this.getOutStatus(), (String)invalidFacet, (boolean)true));
        }
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.getName().startsWith("out")) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }

    public BStatus propagate(BStatus s) {
        return BStatus.make((int)(s.getBits() & this.getPropagateFlags().getBits()));
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }
}

