/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.security;

import com.lynxspring.control.BLicensedComponent;
import com.lynxspring.control.util.BEncryptedString;
import javax.baja.nre.util.TextUtil;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSecureBrandStatus
extends BLicensedComponent {
    public static final Property validBrands = BSecureBrandStatus.newProperty((int)0, (BValue)BEncryptedString.make("lynxspring"), null);
    public static final Property branded = BSecureBrandStatus.newProperty((int)10, (BValue)new BStatusBoolean(false), null);
    public static final Type TYPE = Sys.loadType(BSecureBrandStatus.class);
    private boolean isValid = false;

    public BEncryptedString getValidBrands() {
        return (BEncryptedString)this.get(validBrands);
    }

    public void setValidBrands(BEncryptedString v) {
        this.set(validBrands, (BValue)v, null);
    }

    public BStatusBoolean getBranded() {
        return (BStatusBoolean)this.get(branded);
    }

    public void setBranded(BStatusBoolean v) {
        this.set(branded, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() {
        super.started();
        if (!this.isRunning()) {
            return;
        }
        this.setBranded(new BStatusBoolean(this.valid()));
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (p == validBrands) {
            String str = this.getValidBrands().getString();
            if (!(str.equals("lynxspring;") || str.startsWith("lynxspring;") || str.endsWith(";lynxspring") || str.indexOf(";lynxspring;") >= 0)) {
                str = str + ";lynxspring";
                this.setValidBrands(BEncryptedString.make(str));
            }
            this.isValid = false;
        }
    }

    private boolean valid() {
        if (this.isValid) {
            return true;
        }
        try {
            String brand = Sys.getLicenseManager().checkFeature("Tridium", "brand").get("brandId", "").trim();
            if (brand.length() > 0) {
                String[] brands = TextUtil.split((String)this.getValidBrands().getString(), (char)';');
                for (int i = 0; !this.isValid && i < brands.length; ++i) {
                    if (!brands[i].equals("*") && !brands[i].equals(brand)) continue;
                    this.isValid = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.isValid;
    }
}

