/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.security;

import com.lynxspring.control.BLicensedComponent;
import com.lynxspring.control.security.BSecureNode;
import com.lynxspring.control.util.BEncryptedString;
import com.lynxspring.control.util.Util;
import javax.baja.agent.AgentList;
import javax.baja.naming.BLocalHost;
import javax.baja.nav.BINavNode;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSecureBrandFolder
extends BLicensedComponent {
    public static final Property validBrands = BSecureBrandFolder.newProperty((int)0, (BValue)BEncryptedString.make("lynxspring"), null);
    public static final Action getBrands = BSecureBrandFolder.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BSecureBrandFolder.class);
    private boolean inPalette = false;
    private boolean isValid = false;
    private AgentList agents;

    public BEncryptedString getValidBrands() {
        return (BEncryptedString)this.get(validBrands);
    }

    public void setValidBrands(BEncryptedString v) {
        this.set(validBrands, (BValue)v, null);
    }

    public BString getBrands() {
        return (BString)this.invoke(getBrands, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BString doGetBrands() {
        if (this.isRunning() && !this.checkLicense()) {
            return BString.DEFAULT;
        }
        return BString.make((String)this.getValidBrands().getString());
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (p == validBrands) {
            this.isValid = false;
        }
    }

    public AgentList getAgents(Context cx) {
        if (this.agents != null) {
            return this.agents;
        }
        this.agents = super.getAgents(cx);
        int prop = this.agents.indexOf("workbench:PropertySheet");
        int ws = this.agents.indexOf("wiresheet:WireSheet");
        if (prop >= 0 && prop < ws) {
            this.agents.swap(prop, ws);
        }
        if (!this.valid()) {
            int size = this.agents.size();
            for (int i = size - 1; i >= 0; --i) {
                this.agents.remove(i);
            }
        }
        if (this.agents.size() == 0) {
            this.agents.add(Sys.getType((String)"lynxKitControl:SecureFolderView").getTypeInfo().getAgentInfo());
        }
        return this.agents;
    }

    public String getNavDisplayName(Context cx) {
        if (!this.isInPalette() && !this.valid()) {
            return Util.lex.getText("secure.brand");
        }
        return super.getNavDisplayName(cx);
    }

    public BINavNode[] getNavChildren() {
        if (!this.valid()) {
            if (!this.isInPalette()) {
                return new BINavNode[0];
            }
            return new BINavNode[]{BSecureNode.make(this.getNavOrd(), Util.lex.getText("secure.brand.msg"))};
        }
        return super.getNavChildren();
    }

    private boolean valid() {
        if (this.isValid) {
            return true;
        }
        try {
            String brand = Sys.getLicenseManager().checkFeature("Tridium", "brand").get("brandId", "").trim();
            if (this.getBrands().getString().equals("*") || brand.equals("lynxspring")) {
                this.isValid = true;
            }
            if (!this.isValid && brand.length() > 0) {
                String[] brands = TextUtil.split((String)this.getBrands().getString(), (char)';');
                for (int i = 0; !this.isValid && i < brands.length; ++i) {
                    if (!brands[i].equals(brand)) continue;
                    this.isValid = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.isValid;
    }

    private boolean isInPalette() {
        if (this.inPalette) {
            return true;
        }
        BComplex checkForPalette = this.getParent();
        if (checkForPalette != null) {
            checkForPalette = checkForPalette.getParent();
        }
        if (checkForPalette != null && this.getSession() instanceof BLocalHost && checkForPalette.getParent() == null && checkForPalette.getName() == null && checkForPalette.getDisplayName(null).equals("module.palette")) {
            this.inPalette = true;
        } else if (checkForPalette == null) {
            this.inPalette = true;
        }
        return this.inPalette;
    }
}

