/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.rollup;

import com.lynxspring.control.rollup.BSDHistoryRollupRecord;
import com.lynxspring.control.rollup.SDCollectiveRollupValue;
import com.lynxspring.control.rollup.SDHistoryRollupColumns;
import com.tridium.history.HistoryTableCursor;
import com.tridium.history.collection.PropertyColumn;
import com.tridium.history.rollup.BHistoryRollup;
import com.tridium.history.rollup.BRollupInterval;
import com.tridium.history.rollup.RollupCursor;
import com.tridium.history.rollup.RollupValue;
import java.lang.reflect.Array;
import java.util.ArrayList;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.history.BHistoryRecord;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.util.IFilter;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Cursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSDHistoryRollup
extends BHistoryRollup {
    public static final Type TYPE = Sys.loadType(BSDHistoryRollup.class);
    private BITable table;
    private BRelTime rollupRelTimeInterval;
    private BRollupInterval rollupDefInterval;
    private ArrayList list;
    private ColumnList columns;
    private IFilter filter;
    private BFacets tableFacets;

    public Type getType() {
        return TYPE;
    }

    public static BITable rollup(BITable bitable, BRelTime breltime) {
        return BHistoryRollup.rollup(null, (BITable)bitable, (BRelTime)breltime);
    }

    public static BITable rollup(OrdTarget ordtarget, BITable bitable, BRelTime breltime) {
        if (bitable != null && breltime != null) {
            return new BSDHistoryRollup(bitable, breltime);
        }
        return null;
    }

    public static BITable rollup(OrdTarget ordtarget, BITable bitable, BRollupInterval brollupinterval) {
        if (bitable != null && brollupinterval != null) {
            return new BSDHistoryRollup(bitable, brollupinterval);
        }
        return null;
    }

    public static BITable rollup(OrdTarget ordtarget, BRelTime breltime) {
        if (breltime == null) {
            return null;
        }
        BObject bobject = ordtarget.get();
        if (bobject instanceof BITable) {
            return BHistoryRollup.rollup((OrdTarget)ordtarget, (BITable)((BITable)bobject), (BRelTime)breltime);
        }
        return null;
    }

    public static BITable rollup(OrdTarget ordtarget, BRollupInterval brollupinterval) {
        if (brollupinterval == null || ordtarget == null) {
            return null;
        }
        BObject bobject = ordtarget.get();
        if (bobject instanceof BITable) {
            return BHistoryRollup.rollup((OrdTarget)ordtarget, (BITable)((BITable)bobject), (BRollupInterval)brollupinterval);
        }
        return null;
    }

    public TableCursor cursor() {
        RollupCursor rollupcursor = null;
        rollupcursor = this.rollupDefInterval != null ? new RollupCursor((RollupValue)new SDCollectiveRollupValue(), this.table, this.rollupDefInterval) : new RollupCursor((RollupValue)new SDCollectiveRollupValue(), this.table, this.rollupRelTimeInterval);
        return new HistoryTableCursor((BITable)this, (Cursor)rollupcursor, this.filter);
    }

    public BITable filter(IFilter ifilter) {
        return new BSDHistoryRollup(this.table, this.rollupRelTimeInterval, ifilter);
    }

    public BITable toList() {
        return this;
    }

    public int size() {
        this.load();
        return this.list.size();
    }

    public BObject get(int i) {
        this.load();
        return (BObject)this.list.get(i);
    }

    public BObject[] list() {
        this.load();
        Class class1 = BSDHistoryRollupRecord.TYPE.getTypeClass();
        return (BObject[])this.list.toArray((Object[])Array.newInstance(class1, this.list.size()));
    }

    public BObject[] list(BObject[] abobject) {
        this.load();
        return this.list.toArray(abobject);
    }

    public BITable toTable() {
        return this;
    }

    public ColumnList getColumns() {
        if (this.columns == null) {
            this.columns = SDHistoryRollupColumns.getColumns(this.table);
        }
        return this.columns;
    }

    public BObject get(int i, Column column) {
        this.load();
        return ((PropertyColumn)column).get((BObject)this.list.get(i));
    }

    public String getString(int i, Column column) {
        this.load();
        return ((PropertyColumn)column).getString((BObject)this.list.get(i));
    }

    public double getDouble(int i, Column column) {
        this.load();
        return ((PropertyColumn)column).getDouble((BObject)this.list.get(i));
    }

    public float getFloat(int i, Column column) {
        this.load();
        return ((PropertyColumn)column).getFloat((BObject)this.list.get(i));
    }

    public int getInt(int i, Column column) {
        this.load();
        return ((PropertyColumn)column).getInt((BObject)this.list.get(i));
    }

    public long getLong(int i, Column column) {
        this.load();
        return ((PropertyColumn)column).getLong((BObject)this.list.get(i));
    }

    public boolean getBoolean(int i, Column column) {
        this.load();
        return ((PropertyColumn)column).getBoolean((BObject)this.list.get(i));
    }

    public int getFlags(int i, Column column) {
        this.load();
        return ((PropertyColumn)column).getFlags((BObject)this.list.get(i));
    }

    public BFacets getFacets(int i, Column column) {
        this.load();
        return ((PropertyColumn)column).getFacets((BObject)this.list.get(i));
    }

    public BFacets getTableFacets() {
        return this.tableFacets;
    }

    private final synchronized void load() {
        if (this.list != null) {
            return;
        }
        TableCursor cursor1 = this.cursor();
        this.list = new ArrayList(128);
        while (cursor1.next()) {
            BHistoryRecord bhistoryrecord = (BHistoryRecord)cursor1.get();
            if (this.filter != null && !this.filter.accept((Object)bhistoryrecord)) continue;
            this.list.add(bhistoryrecord.newCopy(true));
        }
    }

    public BSDHistoryRollup(BITable bitable, BRelTime breltime) {
        this(bitable, breltime, null);
    }

    private BSDHistoryRollup(BITable bitable, BRollupInterval brollupinterval) {
        this(bitable, brollupinterval, null);
    }

    private BSDHistoryRollup(BITable bitable, BRelTime breltime, IFilter ifilter) {
        super(bitable, breltime);
        this.table = bitable;
        this.rollupRelTimeInterval = breltime;
        this.filter = ifilter;
        this.tableFacets = bitable.getTableFacets();
    }

    private BSDHistoryRollup(BITable bitable, BRollupInterval brollupinterval, IFilter ifilter) {
        super(bitable, BRelTime.DEFAULT);
        this.table = bitable;
        this.rollupRelTimeInterval = BRelTime.DEFAULT;
        this.filter = ifilter;
        this.tableFacets = bitable.getTableFacets();
        this.rollupDefInterval = brollupinterval;
    }
}

