/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.point;

import javax.baja.control.BNumericPoint;
import javax.baja.control.BPointExtension;
import javax.baja.log.Log;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BNumericDiscreteIntervalProxyExt
extends BPointExtension {
    public static final Property intervalValue = BNumericDiscreteIntervalProxyExt.newProperty((int)9, (BValue)new BStatusNumeric(0.0), null);
    public static final Property lastTotalValue = BNumericDiscreteIntervalProxyExt.newProperty((int)5, (BValue)new BStatusNumeric(0.0), null);
    public static final Property lastUpdate = BNumericDiscreteIntervalProxyExt.newProperty((int)5, (BValue)BAbsTime.DEFAULT, null);
    public static final Property interval = BNumericDiscreteIntervalProxyExt.newProperty((int)8, (BValue)BRelTime.makeMinutes((int)5), null);
    public static final Property rolloverValue = BNumericDiscreteIntervalProxyExt.newProperty((int)8, (int)0, null);
    public static final Property synchAtTopOfHour = BNumericDiscreteIntervalProxyExt.newProperty((int)8, (boolean)false, null);
    public static final Property timeOfLastReset = BNumericDiscreteIntervalProxyExt.newProperty((int)5, (BValue)BAbsTime.DEFAULT, null);
    public static final Property out = BNumericDiscreteIntervalProxyExt.newProperty((int)5, (BValue)new BStatusNumeric(0.0), null);
    public static final Action update = BNumericDiscreteIntervalProxyExt.newAction((int)4, null);
    public static final Action reset = BNumericDiscreteIntervalProxyExt.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BNumericDiscreteIntervalProxyExt.class);
    private Clock.Ticket ticket = Clock.expiredTicket;

    public BStatusNumeric getIntervalValue() {
        return (BStatusNumeric)this.get(intervalValue);
    }

    public void setIntervalValue(BStatusNumeric v) {
        this.set(intervalValue, (BValue)v, null);
    }

    public BStatusNumeric getLastTotalValue() {
        return (BStatusNumeric)this.get(lastTotalValue);
    }

    public void setLastTotalValue(BStatusNumeric v) {
        this.set(lastTotalValue, (BValue)v, null);
    }

    public BAbsTime getLastUpdate() {
        return (BAbsTime)this.get(lastUpdate);
    }

    public void setLastUpdate(BAbsTime v) {
        this.set(lastUpdate, (BValue)v, null);
    }

    public BRelTime getInterval() {
        return (BRelTime)this.get(interval);
    }

    public void setInterval(BRelTime v) {
        this.set(interval, (BValue)v, null);
    }

    public int getRolloverValue() {
        return this.getInt(rolloverValue);
    }

    public void setRolloverValue(int v) {
        this.setInt(rolloverValue, v, null);
    }

    public boolean getSynchAtTopOfHour() {
        return this.getBoolean(synchAtTopOfHour);
    }

    public void setSynchAtTopOfHour(boolean v) {
        this.setBoolean(synchAtTopOfHour, v, null);
    }

    public BAbsTime getTimeOfLastReset() {
        return (BAbsTime)this.get(timeOfLastReset);
    }

    public void setTimeOfLastReset(BAbsTime v) {
        this.set(timeOfLastReset, (BValue)v, null);
    }

    public BStatusNumeric getOut() {
        return (BStatusNumeric)this.get(out);
    }

    public void setOut(BStatusNumeric v) {
        this.set(out, (BValue)v, null);
    }

    public void update() {
        this.invoke(update, null, null);
    }

    public void reset() {
        this.invoke(reset, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void onExecute(BStatusValue sv, Context cx) {
        BStatusNumeric out = (BStatusNumeric)sv;
        this.getOut().setValue(out.getValue());
    }

    public boolean isParentLegal(BComponent parent) {
        if (!super.isParentLegal(parent)) {
            return false;
        }
        return parent instanceof BNumericPoint;
    }

    public void doReset() {
        this.getIntervalValue().setValue(0.0);
        this.setTimeOfLastReset(BAbsTime.now());
    }

    public void doUpdate() {
        this.ticket.cancel();
        double val = 0.0;
        double out = this.getOut().getValue();
        double last = this.getLastTotalValue().getValue();
        val = last < this.getLastTotalValue().getValue() ? (double)this.getRolloverValue() - this.getLastTotalValue().getValue() - last : last - this.getLastTotalValue().getValue();
        if (val < 0.0) {
            val = this.getLastTotalValue().getValue() - last;
        }
        this.getIntervalValue().setValue(val);
        this.getLastTotalValue().setValue(last);
        this.setLastUpdate(BAbsTime.now());
        this.ticket = Clock.schedule((BComponent)this, (BRelTime)this.getInterval(), (Action)update, null);
    }

    public void synchInterval(int seconds) {
        Log.getLog((String)"lkc").trace("synch interval with " + seconds + " seconds");
        if (seconds == 0) {
            Log.getLog((String)"lkc").trace("synch with 0 seconds");
            return;
        }
        if (3600.0 / (double)seconds != (double)(3600 / seconds)) {
            BRelTime adj = BRelTime.make((long)((long)(3600 / (3600 / seconds + 1)) * 1000L));
            Log.getLog((String)"lkc").trace("adjust to " + adj);
            this.setInterval(adj);
        }
    }

    public void started() {
        this.getLastTotalValue().setValue(this.getOut().getValue());
        BAbsTime now = BAbsTime.now();
        this.setLastUpdate(now);
        BAbsTime next = this.getNextTime(this.getLastUpdate(), this.getSynchAtTopOfHour());
        Log.getLog((String)"lkc").message("started, next interval at " + next + " every " + this.getInterval());
        this.ticket = Clock.schedule((BComponent)this, (BAbsTime)next, (Action)update, null);
    }

    public void changed(Property pr, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (pr.equals(interval)) {
            this.doReset();
            if (this.getSynchAtTopOfHour()) {
                this.synchInterval(this.getInterval().getSeconds());
            }
        } else if (pr.equals(synchAtTopOfHour)) {
            this.synchInterval(this.getInterval().getSeconds());
            BAbsTime next = this.getNextTime(this.getLastUpdate(), this.getSynchAtTopOfHour());
            Log.getLog((String)"lkc").trace("next at " + next);
            this.ticket = Clock.schedule((BComponent)this, (BAbsTime)next, (Action)update, null);
        }
        super.changed(pr, cx);
    }

    public void stopped() {
        this.ticket.cancel();
    }

    public BAbsTime getNextTime(boolean synch) {
        return this.getNextTime(BAbsTime.now(), synch);
    }

    public BAbsTime getNextTime(BAbsTime from, boolean synch) {
        if (from.add(this.getInterval()).isBefore(BAbsTime.now())) {
            return BAbsTime.now().add(this.getInterval());
        }
        BRelTime adj = BRelTime.make((long)this.getInterval().getMillis());
        if (this.getSynchAtTopOfHour()) {
            adj = BRelTime.makeSeconds((int)(3600 % this.getInterval().getSeconds()));
        }
        BAbsTime next = BAbsTime.make((long)(from.getMillis() - (long)from.getMillisecond())).add(adj);
        Log.getLog((String)"lkc").trace("next time at " + next + " (" + adj + ")");
        return next;
    }
}

