/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.override;

import com.lynxspring.control.BExecutableComponent;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BAbstractOverrideControl
extends BExecutableComponent {
    public static final Property active = BAbstractOverrideControl.newProperty((int)520, (BValue)new BStatusBoolean(), null);
    public static final Property nullOnInactive = BAbstractOverrideControl.newProperty((int)0, (boolean)false, null);
    public static final Property nullRestoreTime = BAbstractOverrideControl.newProperty((int)0, (BValue)BRelTime.DEFAULT, null);
    public static final Property facets = BAbstractOverrideControl.newProperty((int)0, (BValue)BFacets.NULL, null);
    public static final Action nullRestore = BAbstractOverrideControl.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BAbstractOverrideControl.class);
    Clock.Ticket nullTicket;

    public BStatusBoolean getActive() {
        return (BStatusBoolean)this.get(active);
    }

    public void setActive(BStatusBoolean v) {
        this.set(active, (BValue)v, null);
    }

    public boolean getNullOnInactive() {
        return this.getBoolean(nullOnInactive);
    }

    public void setNullOnInactive(boolean v) {
        this.setBoolean(nullOnInactive, v, null);
    }

    public BRelTime getNullRestoreTime() {
        return (BRelTime)this.get(nullRestoreTime);
    }

    public void setNullRestoreTime(BRelTime v) {
        this.set(nullRestoreTime, (BValue)v, null);
    }

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    public void nullRestore() {
        this.invoke(nullRestore, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void doNullRestore() {
        if (this.getActive().getValue()) {
            return;
        }
        BStatusValue res = (BStatusValue)this.get(this.getRestoreValProp()).newCopy();
        res.setStatus(64);
        this.setOut(res);
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot == this.getCurValInProp() || slot == this.getRestoreValProp() || slot == this.getOutProp() || slot == this.getAdjustmentProp()) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }

    public abstract void setOut(BStatusValue var1);

    public abstract void setRestoreVal(BStatusValue var1);

    public abstract Property getCurValInProp();

    public abstract Property getRestoreValProp();

    public abstract Property getOutProp();

    public abstract Property getAdjustmentProp();

    @Override
    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (p != active && !this.getActive().getValue()) {
            if (!this.getNullOnInactive()) {
                if (p == this.getCurValInProp() || p == nullOnInactive) {
                    this.setOut((BStatusValue)this.get(this.getCurValInProp()).newCopy());
                }
            } else if (p == nullOnInactive) {
                ((BStatusValue)this.get(this.getOutProp())).setStatus(BStatus.nullStatus);
            }
        }
    }

    protected BStatusValue getOverriddenValue() {
        return (BStatusValue)this.get(this.getAdjustmentProp()).newCopy();
    }

    private void goActive() {
        if (this.nullTicket != null && !this.nullTicket.isExpired()) {
            this.nullTicket.cancel();
        }
        this.setRestoreVal((BStatusValue)this.get(this.getCurValInProp()).newCopy());
        this.setOut(this.getOverriddenValue());
    }

    private void goInactive() {
        BStatusValue res = (BStatusValue)this.get(this.getRestoreValProp()).newCopy();
        if (this.getNullOnInactive()) {
            if (this.getNullRestoreTime().getMillis() > 0L) {
                this.nullTicket = Clock.schedule((BComponent)this, (BRelTime)this.getNullRestoreTime(), (Action)nullRestore, null);
            } else {
                res.setStatus(64);
            }
        }
        this.setOut(res);
    }

    @Override
    public void doExecute() {
        if (this.getActive().getValue()) {
            this.goActive();
        } else {
            this.goInactive();
        }
    }
}

