/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.math;

import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BRuntimeCalculator
extends BComponent {
    public static final Property totalHoursThisStart = BRuntimeCalculator.newProperty((int)0, (int)0, null);
    public static final Property totalHoursToday = BRuntimeCalculator.newProperty((int)0, (int)0, null);
    public static final Property runtimeMinutes = BRuntimeCalculator.newProperty((int)0, (int)0, null);
    public static final Property totalHoursYesterday = BRuntimeCalculator.newProperty((int)0, (int)0, null);
    public static final Property totalHoursThisMonth = BRuntimeCalculator.newProperty((int)0, (int)0, null);
    public static final Property totalHoursLastMonth = BRuntimeCalculator.newProperty((int)0, (int)0, null);
    public static final Property inputRuntime = BRuntimeCalculator.newProperty((int)0, (BValue)new BStatusBoolean(false, BStatus.ok), null);
    public static final Property activeValue = BRuntimeCalculator.newProperty((int)0, (boolean)true, null);
    public static final Property lastUpdate = BRuntimeCalculator.newProperty((int)1, (BValue)BAbsTime.DEFAULT, null);
    public static final Action update = BRuntimeCalculator.newAction((int)0, null);
    public static final Action minuteUpdate = BRuntimeCalculator.newAction((int)0, null);
    public static final Action reset = BRuntimeCalculator.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BRuntimeCalculator.class);
    Clock.Ticket ticket;
    Clock.Ticket minTicket;
    int runMins = 0;

    public double getTotalHoursThisStart() {
        return this.getDouble(totalHoursThisStart);
    }

    public void setTotalHoursThisStart(double v) {
        this.setDouble(totalHoursThisStart, v, null);
    }

    public double getTotalHoursToday() {
        return this.getDouble(totalHoursToday);
    }

    public void setTotalHoursToday(double v) {
        this.setDouble(totalHoursToday, v, null);
    }

    public double getRuntimeMinutes() {
        return this.getDouble(runtimeMinutes);
    }

    public void setRuntimeMinutes(double v) {
        this.setDouble(runtimeMinutes, v, null);
    }

    public double getTotalHoursYesterday() {
        return this.getDouble(totalHoursYesterday);
    }

    public void setTotalHoursYesterday(double v) {
        this.setDouble(totalHoursYesterday, v, null);
    }

    public double getTotalHoursThisMonth() {
        return this.getDouble(totalHoursThisMonth);
    }

    public void setTotalHoursThisMonth(double v) {
        this.setDouble(totalHoursThisMonth, v, null);
    }

    public double getTotalHoursLastMonth() {
        return this.getDouble(totalHoursLastMonth);
    }

    public void setTotalHoursLastMonth(double v) {
        this.setDouble(totalHoursLastMonth, v, null);
    }

    public BStatusBoolean getInputRuntime() {
        return (BStatusBoolean)this.get(inputRuntime);
    }

    public void setInputRuntime(BStatusBoolean v) {
        this.set(inputRuntime, (BValue)v, null);
    }

    public boolean getActiveValue() {
        return this.getBoolean(activeValue);
    }

    public void setActiveValue(boolean v) {
        this.setBoolean(activeValue, v, null);
    }

    public BAbsTime getLastUpdate() {
        return (BAbsTime)this.get(lastUpdate);
    }

    public void setLastUpdate(BAbsTime v) {
        this.set(lastUpdate, (BValue)v, null);
    }

    public void update() {
        this.invoke(update, null, null);
    }

    public void minuteUpdate() {
        this.invoke(minuteUpdate, null, null);
    }

    public void reset() {
        this.invoke(reset, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning() || !Sys.isStationStarted()) {
            return;
        }
        if (property == inputRuntime) {
            if (this.getActiveValue() == this.getInputRuntime().getBoolean()) {
                this.scheduleNextMinuteUpdate();
                this.setTotalHoursThisStart(0.0);
            } else if (this.minTicket != null) {
                this.minTicket.cancel();
            }
        }
    }

    public void started() throws Exception {
        this.doUpdate();
    }

    public void scheduleNextUpdate() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.ticket = Clock.schedule((BComponent)this, (BAbsTime)BAbsTime.now().nextDay().timeOfDay(0, 0, 0, 0), (Action)update, null);
    }

    public void doUpdate() {
        if (this.getLastUpdate().getDay() != BAbsTime.now().getDay()) {
            this.setTotalHoursYesterday(this.getTotalHoursToday());
            this.setTotalHoursToday(0.0);
        }
        if (this.getLastUpdate().getMonth() != BAbsTime.now().getMonth()) {
            this.setTotalHoursLastMonth(this.getTotalHoursThisMonth());
            this.setTotalHoursThisMonth(0.0);
        }
        this.setLastUpdate(BAbsTime.now());
        this.scheduleNextUpdate();
    }

    public void doMinuteUpdate() {
        ++this.runMins;
        if (this.runMins >= 60) {
            this.runMins = 0;
        }
        this.setTotalHoursToday(this.getTotalHoursToday() + 0.016667);
        this.setTotalHoursThisStart(this.getTotalHoursThisStart() + 0.016667);
        this.setTotalHoursThisMonth(this.getTotalHoursThisMonth() + 0.016667);
        this.setRuntimeMinutes(this.runMins);
        if (this.getActiveValue() == this.getInputRuntime().getBoolean()) {
            this.scheduleNextMinuteUpdate();
        }
    }

    private void scheduleNextMinuteUpdate() {
        if (this.minTicket != null) {
            this.minTicket.cancel();
        }
        this.minTicket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.makeMinutes((int)1), (Action)minuteUpdate, null);
    }

    public void doReset() {
        this.setTotalHoursLastMonth(0.0);
        this.setTotalHoursThisMonth(0.0);
        this.setTotalHoursThisStart(0.0);
        this.setTotalHoursToday(0.0);
        this.setTotalHoursYesterday(0.0);
        this.setRuntimeMinutes(0.0);
        this.runMins = 0;
    }
}

