/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.math;

import com.lynxspring.control.global.BGlobalMathMasterExtension;
import com.lynxspring.control.global.BGlobalMathSlaveExtension;
import com.lynxspring.control.util.Util;
import com.tridium.kitControl.math.BMath;
import com.tridium.util.ArrayUtil;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.naming.BOrd;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BNaryMath
extends BMath {
    public static final Property inputCount = BNaryMath.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt((int)0, (int)Integer.MAX_VALUE));
    public static final Property calculateTimer = BNaryMath.newProperty((int)0, (BValue)BRelTime.make((long)0L), null);
    public static final Property ignoreNan = BNaryMath.newProperty((int)512, (boolean)false, null);
    public static final Property ignoreInf = BNaryMath.newProperty((int)512, (boolean)false, null);
    public static final Action setNumberOfInputs = BNaryMath.newAction((int)0, (BValue)BInteger.make((int)0), null);
    public static final Type TYPE = Sys.loadType(BNaryMath.class);
    private BAbsTime lastExecuteTime;
    private boolean licensed = false;
    private static final String inPrefix = "In$20";

    public int getInputCount() {
        return this.getInt(inputCount);
    }

    public void setInputCount(int v) {
        this.setInt(inputCount, v, null);
    }

    public BRelTime getCalculateTimer() {
        return (BRelTime)this.get(calculateTimer);
    }

    public void setCalculateTimer(BRelTime v) {
        this.set(calculateTimer, (BValue)v, null);
    }

    public boolean getIgnoreNan() {
        return this.getBoolean(ignoreNan);
    }

    public void setIgnoreNan(boolean v) {
        this.setBoolean(ignoreNan, v, null);
    }

    public boolean getIgnoreInf() {
        return this.getBoolean(ignoreInf);
    }

    public void setIgnoreInf(boolean v) {
        this.setBoolean(ignoreInf, v, null);
    }

    public void setNumberOfInputs(BInteger arg) {
        this.invoke(setNumberOfInputs, (BValue)arg, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.checkInputs();
        this.licensed = Util.checkLicense();
        if (this.licensed) {
            this.execute();
        }
    }

    public void changed(Property p, Context cx) {
        if (cx == Context.decoding) {
            return;
        }
        if (p == inputCount) {
            this.checkInputs();
        }
    }

    public void clockChanged(BRelTime shift) {
        this.lastExecuteTime = null;
    }

    public void onExecute(BStatusValue o, Context cx) {
        if (!this.licensed) {
            Util.notLicensed();
            return;
        }
        if (this.getCalculateTimer().getMillis() > 0L && this.lastExecuteTime != null && this.lastExecuteTime.add(this.getCalculateTimer()).isAfter(BAbsTime.now())) {
            o.setValueValue(this.getOut().getValueValue());
            o.setStatus(this.getOut().getStatus());
            return;
        }
        this.lastExecuteTime = BAbsTime.now();
        boolean forceNull = false;
        int propStatus = 0;
        Property[] props = this.getDynamicPropertiesArray();
        Object[] calcValues = new BStatusNumeric[]{};
        for (int i = 0; i < props.length; ++i) {
            BValue val = this.get(props[i]);
            if (val instanceof BStatusNumeric && props[i].getName().startsWith(inPrefix)) {
                BStatusNumeric tmpIn = (BStatusNumeric)val;
                if (tmpIn.getStatus().isValid()) {
                    calcValues = (BStatusNumeric[])ArrayUtil.addOne((Object[])calcValues, (Object)tmpIn);
                }
                propStatus |= tmpIn.getStatus().getBits();
                continue;
            }
            if (!(val instanceof BGlobalMathMasterExtension)) continue;
            String qry = "slot:/|bql:select * from lynxKitControl:GlobalMathSlaveExtension where masterName = '" + ((BGlobalMathMasterExtension)val).getMasterName() + "'";
            TableCursor c = ((BITable)BOrd.make((String)qry).get((BObject)this)).cursor();
            while (c.next()) {
                BStatusValue statusVal = ((BGlobalMathSlaveExtension)((Object)c.get())).getParentPoint().getOutStatusValue();
                if (!(statusVal instanceof BStatusNumeric)) continue;
                BStatusNumeric tmpIn = (BStatusNumeric)statusVal;
                if (tmpIn.getStatus().isValid()) {
                    calcValues = (BStatusNumeric[])ArrayUtil.addOne((Object[])calcValues, (Object)tmpIn);
                }
                propStatus |= tmpIn.getStatus().getBits();
            }
        }
        if (calcValues.length < this.minInputs()) {
            forceNull = true;
        }
        BStatusNumeric out = (BStatusNumeric)o;
        if (forceNull) {
            out.setValue(Double.NaN);
            out.setStatus(BStatus.nullStatus);
        } else {
            out.setValue(this.calculate((BStatusNumeric[])calcValues));
            out.setStatus(this.propagate(BStatus.make((int)propStatus)));
        }
    }

    private void checkInputs() {
        int min;
        int inCount = 0;
        Property[] props = this.getDynamicPropertiesArray();
        for (int i = 0; i < props.length; ++i) {
            if (!(this.get(props[i]) instanceof BStatusNumeric) || !props[i].getName().startsWith(inPrefix)) continue;
            ++inCount;
        }
        if (inCount == this.getInputCount()) {
            return;
        }
        int max = Math.max(inCount, this.getInputCount()) + 1;
        for (int i = min = Math.min(inCount, this.getInputCount()) + 1; i < max; ++i) {
            if (i > this.getInputCount()) {
                this.remove(inPrefix + i);
                continue;
            }
            this.add(inPrefix + i, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), 8);
        }
    }

    public void removed(Property p, BValue v, Context cx) {
        BValue in;
        if (v instanceof BLink && ((BLink)v).getTargetSlotName().startsWith(inPrefix) && (in = this.get(((BLink)v).getTargetSlotName())) instanceof BStatusNumeric) {
            ((BStatusNumeric)in).setValue(Double.NaN);
            ((BStatusNumeric)in).setStatus(BStatus.nullStatus);
        }
    }

    public void doSetNumberOfInputs(BInteger value) {
        this.setInputCount(value.getInt());
    }

    public BValue getActionParameterDefault(Action action) {
        if (action == setNumberOfInputs) {
            int result = this.getInputCount();
            if (result < 2) {
                result = 2;
            }
            return BInteger.make((int)result);
        }
        return super.getActionParameterDefault(action);
    }

    public BIcon getIcon() {
        BIcon icon = Util.getIcon((BComplex)this);
        if (icon.equivalent((Object)BIcon.DEFAULT)) {
            return super.getIcon();
        }
        return icon;
    }

    protected abstract double calculate(BStatusNumeric[] var1);

    public abstract int minInputs();
}

