/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.math;

import com.lynxspring.control.math.BNaryMath;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BMultiply
extends BNaryMath {
    public static final Type TYPE = Sys.loadType(BMultiply.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    protected double calculate(BStatusNumeric[] values) {
        double result = 1.0;
        for (int i = 0; i < values.length; ++i) {
            double value = values[i].getNumeric();
            if (Double.isNaN(value)) {
                if (this.getIgnoreNan()) continue;
                result = Double.NaN;
                break;
            }
            if (Double.isInfinite(value) && this.getIgnoreInf()) continue;
            result *= value;
        }
        return result;
    }

    @Override
    public int minInputs() {
        return 1;
    }
}

