/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.math;

import com.lynxspring.control.BExecutableComponent;
import com.lynxspring.control.global.BGlobalMathMasterExtension;
import com.lynxspring.control.global.BGlobalMathSlaveExtension;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BMinMaxAvg
extends BExecutableComponent {
    public static final Property facets = BMinMaxAvg.newProperty((int)0, (BValue)BFacets.DEFAULT, null);
    public static final Property min = BMinMaxAvg.newProperty((int)267, (BValue)new BStatusNumeric(), null);
    public static final Property max = BMinMaxAvg.newProperty((int)267, (BValue)new BStatusNumeric(), null);
    public static final Property avg = BMinMaxAvg.newProperty((int)267, (BValue)new BStatusNumeric(), null);
    public static final Property inputCount = BMinMaxAvg.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt((int)0, (int)Integer.MAX_VALUE));
    public static final Property propagateFlags = BMinMaxAvg.newProperty((int)512, (BValue)BStatus.ok, (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"kitControl:PropagateFlagsFE")));
    public static final Property ignoreNaNs = BMinMaxAvg.newProperty((int)512, (boolean)false, null);
    public static final Property ignoreInfs = BMinMaxAvg.newProperty((int)512, (boolean)false, null);
    public static final Action setNumberOfInputs = BMinMaxAvg.newAction((int)0, (BValue)BInteger.make((int)0), null);
    public static final Type TYPE = Sys.loadType(BMinMaxAvg.class);
    private static final String inPrefix = "In$20";

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    public BStatusNumeric getMin() {
        return (BStatusNumeric)this.get(min);
    }

    public void setMin(BStatusNumeric v) {
        this.set(min, (BValue)v, null);
    }

    public BStatusNumeric getMax() {
        return (BStatusNumeric)this.get(max);
    }

    public void setMax(BStatusNumeric v) {
        this.set(max, (BValue)v, null);
    }

    public BStatusNumeric getAvg() {
        return (BStatusNumeric)this.get(avg);
    }

    public void setAvg(BStatusNumeric v) {
        this.set(avg, (BValue)v, null);
    }

    public int getInputCount() {
        return this.getInt(inputCount);
    }

    public void setInputCount(int v) {
        this.setInt(inputCount, v, null);
    }

    public BStatus getPropagateFlags() {
        return (BStatus)this.get(propagateFlags);
    }

    public void setPropagateFlags(BStatus v) {
        this.set(propagateFlags, (BValue)v, null);
    }

    public boolean getIgnoreNaNs() {
        return this.getBoolean(ignoreNaNs);
    }

    public void setIgnoreNaNs(boolean v) {
        this.setBoolean(ignoreNaNs, v, null);
    }

    public boolean getIgnoreInfs() {
        return this.getBoolean(ignoreInfs);
    }

    public void setIgnoreInfs(boolean v) {
        this.setBoolean(ignoreInfs, v, null);
    }

    public void setNumberOfInputs(BInteger arg) {
        this.invoke(setNumberOfInputs, (BValue)arg, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() {
        super.started();
        this.checkInputs();
    }

    @Override
    public void changed(Property p, Context cx) {
        if (p == inputCount && cx != Context.decoding) {
            this.checkInputs();
        } else {
            super.changed(p, cx);
        }
    }

    private void checkInputs() {
        int inCount = 0;
        Property[] props = this.getDynamicPropertiesArray();
        for (int i = 0; i < props.length; ++i) {
            if (!(this.get(props[i]) instanceof BStatusNumeric) || !props[i].getName().startsWith(inPrefix)) continue;
            ++inCount;
        }
        if (inCount != this.getInputCount()) {
            int min;
            int max = Math.max(inCount, this.getInputCount()) + 1;
            for (int i = min = Math.min(inCount, this.getInputCount()) + 1; i < max; ++i) {
                if (i > this.getInputCount()) {
                    this.remove(inPrefix + i);
                    continue;
                }
                this.add(inPrefix + i, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), 520);
            }
        }
        this.execute();
    }

    public void removed(Property p, BValue v, Context cx) {
        BValue in;
        if (v instanceof BLink && ((BLink)v).getTargetSlotName().startsWith(inPrefix) && (in = this.get(((BLink)v).getTargetSlotName())) instanceof BStatusNumeric) {
            ((BStatusNumeric)in).setValue(Double.NaN);
            ((BStatusNumeric)in).setStatus(BStatus.nullStatus);
        }
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot == min || slot == max || slot == avg) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }

    public void doSetNumberOfInputs(BInteger value) {
        this.setInputCount(value.getInt());
    }

    public BValue getActionParameterDefault(Action action) {
        if (action == setNumberOfInputs) {
            int result = this.getInputCount();
            if (result < 2) {
                result = 2;
            }
            return BInteger.make((int)result);
        }
        return super.getActionParameterDefault(action);
    }

    @Override
    public void doExecute() {
        if (!this.isLicensed()) {
            return;
        }
        int propStatus = 0;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        double avg = 0.0;
        int avgCount = 0;
        Property[] props = this.getDynamicPropertiesArray();
        for (int i = 0; i < props.length; ++i) {
            BValue val = this.get(props[i]);
            if (val instanceof BStatusNumeric && props[i].getName().startsWith(inPrefix)) {
                BStatusNumeric tmpIn = (BStatusNumeric)val;
                if (!(!tmpIn.getStatus().isValid() || this.getIgnoreNaNs() && Double.isNaN(tmpIn.getNumeric()) || this.getIgnoreInfs() && Double.isInfinite(tmpIn.getNumeric()))) {
                    min = Math.min(min, tmpIn.getNumeric());
                    max = Math.max(max, tmpIn.getNumeric());
                    avg += tmpIn.getNumeric();
                    ++avgCount;
                }
                propStatus |= tmpIn.getStatus().getBits();
                continue;
            }
            if (!(val instanceof BGlobalMathMasterExtension)) continue;
            String qry = "slot:/|bql:select * from lynxKitControl:GlobalMathSlaveExtension where masterName = '" + ((BGlobalMathMasterExtension)val).getMasterName() + "'";
            TableCursor c = ((BITable)BOrd.make((String)qry).get((BObject)this)).cursor();
            while (c.next()) {
                BStatusValue statusVal = ((BGlobalMathSlaveExtension)((Object)c.get())).getParentPoint().getOutStatusValue();
                if (!(statusVal instanceof BStatusNumeric)) continue;
                BStatusNumeric tmpIn = (BStatusNumeric)statusVal;
                if (!(!tmpIn.getStatus().isValid() || this.getIgnoreNaNs() && Double.isNaN(tmpIn.getNumeric()) || this.getIgnoreInfs() && Double.isInfinite(tmpIn.getNumeric()))) {
                    min = Math.min(min, tmpIn.getNumeric());
                    max = Math.max(max, tmpIn.getNumeric());
                    avg += tmpIn.getNumeric();
                    ++avgCount;
                }
                propStatus |= tmpIn.getStatus().getBits();
            }
        }
        if (avgCount < 1) {
            this.getMin().setValue(Double.NaN);
            this.getMin().setStatus(BStatus.nullStatus);
            this.getMax().setValue(Double.NaN);
            this.getMax().setStatus(BStatus.nullStatus);
            this.getAvg().setValue(Double.NaN);
            this.getAvg().setStatus(BStatus.nullStatus);
        } else {
            BStatus propogate = BStatus.make((int)(BStatus.make((int)propStatus).getBits() & this.getPropagateFlags().getBits()));
            this.getMin().setValue(min);
            this.getMin().setStatus(propogate);
            this.getMax().setValue(max);
            this.getMax().setStatus(propogate);
            this.getAvg().setValue(avg / (double)avgCount);
            this.getAvg().setStatus(propogate);
        }
    }
}

