/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.math;

import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BBinaryTotalCalculator
extends BComponent {
    public static final Property totalToday = BBinaryTotalCalculator.newProperty((int)0, (int)0, null);
    public static final Property totalYesterday = BBinaryTotalCalculator.newProperty((int)0, (int)0, null);
    public static final Property totalThisMonth = BBinaryTotalCalculator.newProperty((int)0, (int)0, null);
    public static final Property totalLastMonth = BBinaryTotalCalculator.newProperty((int)0, (int)0, null);
    public static final Property input = BBinaryTotalCalculator.newProperty((int)0, (BValue)new BStatusBoolean(false, BStatus.ok), null);
    public static final Property edgeTrigger = BBinaryTotalCalculator.newProperty((int)0, (boolean)true, null);
    public static final Property direction = BBinaryTotalCalculator.newProperty((int)0, (boolean)true, null);
    public static final Property lastUpdate = BBinaryTotalCalculator.newProperty((int)1, (BValue)BAbsTime.DEFAULT, null);
    public static final Action update = BBinaryTotalCalculator.newAction((int)0, null);
    public static final Action reset = BBinaryTotalCalculator.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BBinaryTotalCalculator.class);
    Clock.Ticket ticket;

    public double getTotalToday() {
        return this.getDouble(totalToday);
    }

    public void setTotalToday(double v) {
        this.setDouble(totalToday, v, null);
    }

    public double getTotalYesterday() {
        return this.getDouble(totalYesterday);
    }

    public void setTotalYesterday(double v) {
        this.setDouble(totalYesterday, v, null);
    }

    public double getTotalThisMonth() {
        return this.getDouble(totalThisMonth);
    }

    public void setTotalThisMonth(double v) {
        this.setDouble(totalThisMonth, v, null);
    }

    public double getTotalLastMonth() {
        return this.getDouble(totalLastMonth);
    }

    public void setTotalLastMonth(double v) {
        this.setDouble(totalLastMonth, v, null);
    }

    public BStatusBoolean getInput() {
        return (BStatusBoolean)this.get(input);
    }

    public void setInput(BStatusBoolean v) {
        this.set(input, (BValue)v, null);
    }

    public boolean getEdgeTrigger() {
        return this.getBoolean(edgeTrigger);
    }

    public void setEdgeTrigger(boolean v) {
        this.setBoolean(edgeTrigger, v, null);
    }

    public boolean getDirection() {
        return this.getBoolean(direction);
    }

    public void setDirection(boolean v) {
        this.setBoolean(direction, v, null);
    }

    public BAbsTime getLastUpdate() {
        return (BAbsTime)this.get(lastUpdate);
    }

    public void setLastUpdate(BAbsTime v) {
        this.set(lastUpdate, (BValue)v, null);
    }

    public void update() {
        this.invoke(update, null, null);
    }

    public void reset() {
        this.invoke(reset, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        if (property == input && this.getEdgeTrigger() == this.getInput().getBoolean()) {
            if (this.getDirection()) {
                this.setTotalToday(this.getTotalToday() + 1.0);
                this.setTotalThisMonth(this.getTotalThisMonth() + 1.0);
            } else {
                this.setTotalThisMonth(this.getTotalThisMonth() - 1.0);
                this.setTotalToday(this.getTotalToday() - 1.0);
            }
        }
    }

    public void started() throws Exception {
        this.doUpdate();
    }

    public void scheduleNextUpdate() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.ticket = Clock.schedule((BComponent)this, (BAbsTime)BAbsTime.now().nextDay().timeOfDay(0, 0, 0, 0), (Action)update, null);
    }

    public void doUpdate() {
        if (this.getLastUpdate().getDayOfYear() != BAbsTime.now().getDayOfYear()) {
            this.setTotalYesterday(this.getTotalToday());
            this.setTotalToday(0.0);
        }
        if (this.getLastUpdate().getMonth() != BAbsTime.now().getMonth()) {
            this.setTotalLastMonth(this.getTotalThisMonth());
            this.setTotalThisMonth(0.0);
        }
        this.scheduleNextUpdate();
        this.setLastUpdate(BAbsTime.now());
    }

    public void doReset() {
        this.setTotalToday(0.0);
        this.setTotalYesterday(0.0);
        this.setTotalLastMonth(0.0);
        this.setTotalThisMonth(0.0);
    }
}

