/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.math;

import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BAverageRunningLoadAmpCalculator
extends BComponent {
    public static final Property averageRunningLoadAmpsToday = BAverageRunningLoadAmpCalculator.newProperty((int)0, (int)0, null);
    public static final Property averageRunningLoadAmpsYesterday = BAverageRunningLoadAmpCalculator.newProperty((int)0, (int)0, null);
    public static final Property averageRunningLoadAmpsThisMonth = BAverageRunningLoadAmpCalculator.newProperty((int)0, (int)0, null);
    public static final Property averageRunningLoadAmpsLastMonth = BAverageRunningLoadAmpCalculator.newProperty((int)0, (int)0, null);
    public static final Property inputRunning = BAverageRunningLoadAmpCalculator.newProperty((int)0, (BValue)new BStatusBoolean(false, BStatus.ok), null);
    public static final Property inputRunningLoadAmps = BAverageRunningLoadAmpCalculator.newProperty((int)0, (BValue)new BStatusNumeric(0.0, BStatus.ok), null);
    public static final Property lastUpdate = BAverageRunningLoadAmpCalculator.newProperty((int)1, (BValue)BAbsTime.DEFAULT, null);
    public static final Property samplesToday = BAverageRunningLoadAmpCalculator.newProperty((int)0, (int)0, null);
    public static final Property samplesMonth = BAverageRunningLoadAmpCalculator.newProperty((int)0, (int)0, null);
    public static final Property totalMonth = BAverageRunningLoadAmpCalculator.newProperty((int)0, (int)0, null);
    public static final Property totalToday = BAverageRunningLoadAmpCalculator.newProperty((int)0, (int)0, null);
    public static final Property ignoreNan = BAverageRunningLoadAmpCalculator.newProperty((int)512, (boolean)false, null);
    public static final Property ignoreInf = BAverageRunningLoadAmpCalculator.newProperty((int)512, (boolean)false, null);
    public static final Action update = BAverageRunningLoadAmpCalculator.newAction((int)0, null);
    public static final Action minuteUpdate = BAverageRunningLoadAmpCalculator.newAction((int)0, null);
    public static final Action resetToday = BAverageRunningLoadAmpCalculator.newAction((int)0, null);
    public static final Action resetMonth = BAverageRunningLoadAmpCalculator.newAction((int)0, null);
    public static final Action resetPastTotals = BAverageRunningLoadAmpCalculator.newAction((int)0, null);
    public static final Action resetAll = BAverageRunningLoadAmpCalculator.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BAverageRunningLoadAmpCalculator.class);
    Clock.Ticket ticket;
    Clock.Ticket minTicket;

    public double getAverageRunningLoadAmpsToday() {
        return this.getDouble(averageRunningLoadAmpsToday);
    }

    public void setAverageRunningLoadAmpsToday(double v) {
        this.setDouble(averageRunningLoadAmpsToday, v, null);
    }

    public double getAverageRunningLoadAmpsYesterday() {
        return this.getDouble(averageRunningLoadAmpsYesterday);
    }

    public void setAverageRunningLoadAmpsYesterday(double v) {
        this.setDouble(averageRunningLoadAmpsYesterday, v, null);
    }

    public double getAverageRunningLoadAmpsThisMonth() {
        return this.getDouble(averageRunningLoadAmpsThisMonth);
    }

    public void setAverageRunningLoadAmpsThisMonth(double v) {
        this.setDouble(averageRunningLoadAmpsThisMonth, v, null);
    }

    public double getAverageRunningLoadAmpsLastMonth() {
        return this.getDouble(averageRunningLoadAmpsLastMonth);
    }

    public void setAverageRunningLoadAmpsLastMonth(double v) {
        this.setDouble(averageRunningLoadAmpsLastMonth, v, null);
    }

    public BStatusBoolean getInputRunning() {
        return (BStatusBoolean)this.get(inputRunning);
    }

    public void setInputRunning(BStatusBoolean v) {
        this.set(inputRunning, (BValue)v, null);
    }

    public BStatusNumeric getInputRunningLoadAmps() {
        return (BStatusNumeric)this.get(inputRunningLoadAmps);
    }

    public void setInputRunningLoadAmps(BStatusNumeric v) {
        this.set(inputRunningLoadAmps, (BValue)v, null);
    }

    public BAbsTime getLastUpdate() {
        return (BAbsTime)this.get(lastUpdate);
    }

    public void setLastUpdate(BAbsTime v) {
        this.set(lastUpdate, (BValue)v, null);
    }

    public int getSamplesToday() {
        return this.getInt(samplesToday);
    }

    public void setSamplesToday(int v) {
        this.setInt(samplesToday, v, null);
    }

    public int getSamplesMonth() {
        return this.getInt(samplesMonth);
    }

    public void setSamplesMonth(int v) {
        this.setInt(samplesMonth, v, null);
    }

    public double getTotalMonth() {
        return this.getDouble(totalMonth);
    }

    public void setTotalMonth(double v) {
        this.setDouble(totalMonth, v, null);
    }

    public double getTotalToday() {
        return this.getDouble(totalToday);
    }

    public void setTotalToday(double v) {
        this.setDouble(totalToday, v, null);
    }

    public boolean getIgnoreNan() {
        return this.getBoolean(ignoreNan);
    }

    public void setIgnoreNan(boolean v) {
        this.setBoolean(ignoreNan, v, null);
    }

    public boolean getIgnoreInf() {
        return this.getBoolean(ignoreInf);
    }

    public void setIgnoreInf(boolean v) {
        this.setBoolean(ignoreInf, v, null);
    }

    public void update() {
        this.invoke(update, null, null);
    }

    public void minuteUpdate() {
        this.invoke(minuteUpdate, null, null);
    }

    public void resetToday() {
        this.invoke(resetToday, null, null);
    }

    public void resetMonth() {
        this.invoke(resetMonth, null, null);
    }

    public void resetPastTotals() {
        this.invoke(resetPastTotals, null, null);
    }

    public void resetAll() {
        this.invoke(resetAll, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        if (property == inputRunning) {
            if (this.getInputRunning().getBoolean()) {
                this.scheduleNextMinuteUpdate();
            } else if (this.minTicket != null) {
                this.minTicket.cancel();
            }
        }
    }

    public void started() throws Exception {
        this.doUpdate();
    }

    public void scheduleNextUpdate() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.ticket = Clock.schedule((BComponent)this, (BAbsTime)BAbsTime.now().nextDay().timeOfDay(0, 0, 0, 0), (Action)update, null);
    }

    public void doUpdate() {
        if (this.getLastUpdate().getDay() != BAbsTime.now().getDay()) {
            this.setAverageRunningLoadAmpsYesterday(this.getAverageRunningLoadAmpsToday());
            if (this.getInputRunning().getBoolean()) {
                this.setAverageRunningLoadAmpsToday(this.getInputRunningLoadAmps().getNumeric());
                this.setSamplesToday(1);
                this.setTotalToday(this.getInputRunningLoadAmps().getNumeric());
            } else {
                this.setAverageRunningLoadAmpsToday(0.0);
                this.setSamplesToday(0);
                this.setTotalToday(0.0);
            }
        }
        if (this.getLastUpdate().getMonth() != BAbsTime.now().getMonth()) {
            this.setAverageRunningLoadAmpsLastMonth(this.getAverageRunningLoadAmpsThisMonth());
            if (this.getInputRunning().getBoolean()) {
                this.setAverageRunningLoadAmpsThisMonth(this.getInputRunningLoadAmps().getNumeric());
                this.setSamplesMonth(1);
                this.setTotalMonth(this.getInputRunningLoadAmps().getNumeric());
            } else {
                this.setAverageRunningLoadAmpsThisMonth(0.0);
                this.setSamplesMonth(0);
                this.setTotalMonth(0.0);
            }
        }
        this.setLastUpdate(BAbsTime.now());
        this.scheduleNextUpdate();
    }

    public void doMinuteUpdate() {
        double value = this.getInputRunningLoadAmps().getNumeric();
        if (!(Double.isNaN(value) && this.getIgnoreNan() || Double.isInfinite(value) && this.getIgnoreInf())) {
            this.setSamplesToday(this.getSamplesToday() + 1);
            this.setSamplesMonth(this.getSamplesMonth() + 1);
            this.setTotalToday(this.getTotalToday() + this.getInputRunningLoadAmps().getNumeric());
            this.setTotalMonth(this.getTotalMonth() + this.getInputRunningLoadAmps().getNumeric());
            this.setAverageRunningLoadAmpsToday(this.getTotalToday() / (double)this.getSamplesToday());
            this.setAverageRunningLoadAmpsThisMonth(this.getTotalMonth() / (double)this.getSamplesMonth());
        }
        this.scheduleNextMinuteUpdate();
    }

    private void scheduleNextMinuteUpdate() {
        if (this.minTicket != null) {
            this.minTicket.cancel();
        }
        this.minTicket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.makeMinutes((int)1), (Action)minuteUpdate, null);
    }

    public void doResetAll() {
        this.doResetMonth();
        this.doResetToday();
        this.doResetPastTotals();
    }

    public void doResetToday() {
        this.setAverageRunningLoadAmpsToday(0.0);
        this.setSamplesToday(0);
        this.setTotalToday(0.0);
    }

    public void doResetMonth() {
        this.setAverageRunningLoadAmpsThisMonth(0.0);
        this.setSamplesMonth(0);
        this.setTotalMonth(0.0);
    }

    public void doResetPastTotals() {
        this.setAverageRunningLoadAmpsLastMonth(0.0);
        this.setAverageRunningLoadAmpsYesterday(0.0);
    }
}

