/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.logic;

import com.lynxspring.control.util.Util;
import com.tridium.kitControl.logic.BLogic;
import com.tridium.util.ArrayUtil;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLink;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BNaryLogic
extends BLogic {
    public static final Property inputCount = BNaryLogic.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt((int)2, (int)Integer.MAX_VALUE));
    public static final Action setNumberOfInputs = BNaryLogic.newAction((int)0, (BValue)BInteger.make((int)0), null);
    public static final Type TYPE = Sys.loadType(BNaryLogic.class);
    private boolean licensed = false;
    private static final String inPrefix = "In$20";

    public int getInputCount() {
        return this.getInt(inputCount);
    }

    public void setInputCount(int v) {
        this.setInt(inputCount, v, null);
    }

    public void setNumberOfInputs(BInteger arg) {
        this.invoke(setNumberOfInputs, (BValue)arg, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.checkInputs();
        this.licensed = Util.checkLicense();
        if (this.licensed) {
            this.execute();
        }
    }

    public void changed(Property p, Context cx) {
        if (cx == Context.decoding) {
            return;
        }
        if (p == inputCount) {
            this.checkInputs();
        }
        if (this.isRunning()) {
            this.execute();
        }
    }

    public void onExecute(BStatusValue o, Context cx) {
        if (!this.licensed) {
            Util.notLicensed();
            return;
        }
        int nonNullCount = 0;
        boolean forceNull = false;
        int propStatus = 0;
        Property[] props = this.getDynamicPropertiesArray();
        Object[] calcValues = new BStatusBoolean[]{};
        for (int i = 0; i < props.length; ++i) {
            if (!(this.get(props[i]) instanceof BStatusBoolean) || !props[i].getName().startsWith(inPrefix)) continue;
            BStatusBoolean tmpIn = (BStatusBoolean)this.get(props[i]);
            if (tmpIn.getStatus().isValid()) {
                ++nonNullCount;
            }
            calcValues = (BStatusBoolean[])ArrayUtil.addOne((Object[])calcValues, (Object)tmpIn);
            propStatus |= tmpIn.getStatus().getBits();
        }
        if (nonNullCount < this.minInputs()) {
            forceNull = true;
        }
        BStatusBoolean out = (BStatusBoolean)o;
        if (forceNull) {
            out.setValue(false);
            out.setStatus(BStatus.nullStatus);
        } else {
            out.setValue(this.calculate((BStatusBoolean[])calcValues));
            out.setStatus(this.propagate(BStatus.make((int)propStatus)));
            if (this.getNullOnInactive() && !out.getValue()) {
                out.setStatusNull(true);
            }
        }
    }

    private void checkInputs() {
        int min;
        int inCount = 0;
        Property[] props = this.getDynamicPropertiesArray();
        for (int i = 0; i < props.length; ++i) {
            if (!(this.get(props[i]) instanceof BStatusBoolean) || !props[i].getName().startsWith(inPrefix)) continue;
            ++inCount;
        }
        if (inCount == this.getInputCount()) {
            return;
        }
        int max = Math.max(inCount, this.getInputCount()) + 1;
        for (int i = min = Math.min(inCount, this.getInputCount()) + 1; i < max; ++i) {
            if (i > this.getInputCount()) {
                this.remove(inPrefix + i);
                continue;
            }
            this.add(inPrefix + i, (BValue)new BStatusBoolean(false, BStatus.nullStatus), 8);
        }
    }

    public void removed(Property p, BValue v, Context cx) {
        BValue in;
        if (v instanceof BLink && ((BLink)v).getTargetSlotName().startsWith(inPrefix) && (in = this.get(((BLink)v).getTargetSlotName())) instanceof BStatusBoolean) {
            ((BStatusBoolean)in).setValue(false);
            ((BStatusBoolean)in).setStatus(BStatus.nullStatus);
        }
    }

    public void doSetNumberOfInputs(BInteger value) {
        this.setInputCount(value.getInt());
    }

    public BValue getActionParameterDefault(Action action) {
        if (action == setNumberOfInputs) {
            int result = this.getInputCount();
            if (result < 2) {
                result = 2;
            }
            return BInteger.make((int)result);
        }
        return super.getActionParameterDefault(action);
    }

    public BIcon getIcon() {
        BIcon icon = Util.getIcon((BComplex)this);
        if (icon.equivalent((Object)BIcon.DEFAULT)) {
            return super.getIcon();
        }
        return icon;
    }

    protected abstract boolean calculate(BStatusBoolean[] var1);

    public abstract int minInputs();
}

