/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.hvac;

import com.lynxspring.control.util.Util;
import com.tridium.kitControl.enums.BLoopAction;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BTstat
extends com.tridium.kitControl.hvac.BTstat {
    public static final Property diffMethod = BTstat.newProperty((int)0, (BValue)BTstat.defaultDiffMethod(), null);
    public static final Type TYPE = Sys.loadType(BTstat.class);
    private boolean licensed = false;

    public BDynamicEnum getDiffMethod() {
        return (BDynamicEnum)this.get(diffMethod);
    }

    public void setDiffMethod(BDynamicEnum v) {
        this.set(diffMethod, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (!this.isRunning()) {
            return;
        }
        this.licensed = Util.checkLicense();
    }

    protected boolean calculate() {
        double currentValue;
        if (!this.licensed) {
            Util.notLicensed();
            return false;
        }
        double diff = this.getDiff().getValue();
        double highValue = this.getSp().getValue();
        double lowValue = this.getSp().getValue();
        switch (this.getDiffMethod().getOrdinal()) {
            case 0: {
                double halfDiff = diff / 2.0;
                highValue += halfDiff;
                lowValue -= halfDiff;
                break;
            }
            case 1: {
                highValue += diff;
                lowValue -= diff;
                break;
            }
            case 2: {
                highValue += diff;
                break;
            }
            case 3: {
                lowValue -= diff;
            }
        }
        boolean returnValue = this.getOut().getValue();
        if (this.getAction() != BLoopAction.direct) {
            boolean bl = returnValue = !returnValue;
        }
        if ((currentValue = this.getCv().getValue()) >= highValue) {
            returnValue = true;
        } else if (currentValue <= lowValue) {
            returnValue = false;
        }
        if (this.getAction() != BLoopAction.direct) {
            returnValue = !returnValue;
        }
        return returnValue;
    }

    private static final BDynamicEnum defaultDiffMethod() {
        return BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((String[])new String[]{"Split", "High$2fLow", "High", "Low"}));
    }
}

