/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.hvac;

import com.lynxspring.control.BExecutableComponent;
import javax.baja.data.BIDataValue;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSequenceLinear
extends BExecutableComponent {
    public static final Property facets = BSequenceLinear.newProperty((int)0, (BValue)BFacets.makeBoolean(), null);
    public static final Property in = BSequenceLinear.newProperty((int)520, (BValue)new BStatusNumeric(), null);
    public static final Property inMinimum = BSequenceLinear.newProperty((int)0, (double)0.0, null);
    public static final Property inMaximum = BSequenceLinear.newProperty((int)0, (double)100.0, null);
    public static final Property numberOutputs = BSequenceLinear.newProperty((int)0, (int)1, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)1)));
    public static final Property Out1 = BSequenceLinear.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property delay = BSequenceLinear.newProperty((int)0, (BValue)BRelTime.make((long)1000L), null);
    public static final Property onDelayActive = BSequenceLinear.newProperty((int)515, (boolean)false, null);
    public static final Property offDelayActive = BSequenceLinear.newProperty((int)515, (boolean)false, null);
    public static final Property desiredStagesOn = BSequenceLinear.newProperty((int)3, (int)0, null);
    public static final Property currentStagesOn = BSequenceLinear.newProperty((int)3, (int)0, null);
    public static final Property nextStageOn = BSequenceLinear.newProperty((int)3, (int)0, null);
    public static final Property nextStageOff = BSequenceLinear.newProperty((int)3, (int)0, null);
    public static final Property action = BSequenceLinear.newProperty((int)0, (boolean)false, (BFacets)BFacets.makeBoolean((String)"rotating", (String)"linear"));
    public static final Property rotateTime = BSequenceLinear.newProperty((int)0, (BValue)BRelTime.make((long)1000L), null);
    public static final Property rotateTimerActive = BSequenceLinear.newProperty((int)515, (boolean)false, null);
    public static final Action onDelayTimerExpired = BSequenceLinear.newAction((int)4, null);
    public static final Action offDelayTimerExpired = BSequenceLinear.newAction((int)4, null);
    public static final Action rotateTimerExpired = BSequenceLinear.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BSequenceLinear.class);
    int numStagesOn;
    int curStagesOn;
    int nxtStageOn = 1;
    int nxtStageOff = 0;
    int numOutputs;
    int startStage = 1;
    boolean wasEqual = false;
    Clock.Ticket onTicket;
    Clock.Ticket offTicket;
    Clock.Ticket rotateTicket;
    int lastNumberOfOutputs = this.getNumberOutputs();

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    public BStatusNumeric getIn() {
        return (BStatusNumeric)this.get(in);
    }

    public void setIn(BStatusNumeric v) {
        this.set(in, (BValue)v, null);
    }

    public double getInMinimum() {
        return this.getDouble(inMinimum);
    }

    public void setInMinimum(double v) {
        this.setDouble(inMinimum, v, null);
    }

    public double getInMaximum() {
        return this.getDouble(inMaximum);
    }

    public void setInMaximum(double v) {
        this.setDouble(inMaximum, v, null);
    }

    public int getNumberOutputs() {
        return this.getInt(numberOutputs);
    }

    public void setNumberOutputs(int v) {
        this.setInt(numberOutputs, v, null);
    }

    public BStatusBoolean getOut1() {
        return (BStatusBoolean)this.get(Out1);
    }

    public void setOut1(BStatusBoolean v) {
        this.set(Out1, (BValue)v, null);
    }

    public BRelTime getDelay() {
        return (BRelTime)this.get(delay);
    }

    public void setDelay(BRelTime v) {
        this.set(delay, (BValue)v, null);
    }

    public boolean getOnDelayActive() {
        return this.getBoolean(onDelayActive);
    }

    public void setOnDelayActive(boolean v) {
        this.setBoolean(onDelayActive, v, null);
    }

    public boolean getOffDelayActive() {
        return this.getBoolean(offDelayActive);
    }

    public void setOffDelayActive(boolean v) {
        this.setBoolean(offDelayActive, v, null);
    }

    public int getDesiredStagesOn() {
        return this.getInt(desiredStagesOn);
    }

    public void setDesiredStagesOn(int v) {
        this.setInt(desiredStagesOn, v, null);
    }

    public int getCurrentStagesOn() {
        return this.getInt(currentStagesOn);
    }

    public void setCurrentStagesOn(int v) {
        this.setInt(currentStagesOn, v, null);
    }

    public int getNextStageOn() {
        return this.getInt(nextStageOn);
    }

    public void setNextStageOn(int v) {
        this.setInt(nextStageOn, v, null);
    }

    public int getNextStageOff() {
        return this.getInt(nextStageOff);
    }

    public void setNextStageOff(int v) {
        this.setInt(nextStageOff, v, null);
    }

    public boolean getAction() {
        return this.getBoolean(action);
    }

    public void setAction(boolean v) {
        this.setBoolean(action, v, null);
    }

    public BRelTime getRotateTime() {
        return (BRelTime)this.get(rotateTime);
    }

    public void setRotateTime(BRelTime v) {
        this.set(rotateTime, (BValue)v, null);
    }

    public boolean getRotateTimerActive() {
        return this.getBoolean(rotateTimerActive);
    }

    public void setRotateTimerActive(boolean v) {
        this.setBoolean(rotateTimerActive, v, null);
    }

    public void onDelayTimerExpired() {
        this.invoke(onDelayTimerExpired, null, null);
    }

    public void offDelayTimerExpired() {
        this.invoke(offDelayTimerExpired, null, null);
    }

    public void rotateTimerExpired() {
        this.invoke(rotateTimerExpired, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void changed(Property property, Context context) {
        if (this.isRunning()) {
            if (property == action) {
                if (!this.isRotating()) {
                    this.setFlags((Slot)rotateTime, 4, null);
                } else {
                    this.setFlags((Slot)rotateTime, 0, null);
                }
                if (this.rotateTicket != null) {
                    this.rotateTicket.cancel();
                }
                this.reinitialize();
            } else if (property == numberOutputs) {
                this.initNumberOutputs();
            }
        }
        super.changed(property, context);
    }

    public void doRotateTimerExpired() {
        if (!this.isRunning()) {
            return;
        }
        this.setRotateTimerActive(false);
        this.setOutputs();
    }

    @Override
    public void doExecute() {
        this.numOutputs = this.getNumberOutputs();
        double d = this.getInMaximum() - this.getInMinimum();
        double d1 = d / (double)this.numOutputs;
        double d2 = this.getIn().getValue();
        int i = this.numStagesOn;
        if (this.getIn().getStatus().isValid()) {
            this.numStagesOn = (int)((d2 - this.getInMinimum()) / d1);
            if (d2 > this.getInMinimum() && i > this.numStagesOn) {
                ++this.numStagesOn;
            }
        }
        if (this.numStagesOn < 0) {
            this.numStagesOn = 0;
        }
        this.setDesiredStagesOn(this.numStagesOn);
        this.setOutputs();
    }

    boolean isRotating() {
        return this.getAction();
    }

    public void setOutputs() {
        if (this.numStagesOn == this.curStagesOn) {
            if (this.isRotating() && this.isRotateTimeProgrammed() && this.numStagesOn > 0 && this.numStagesOn < this.numOutputs && !this.getRotateTimerActive()) {
                if (!this.wasEqual) {
                    this.startRotateTimer();
                    this.wasEqual = true;
                } else {
                    this.rotateNextStageOff();
                    this.rotateNextStageOn();
                    this.startRotateTimer();
                    this.setRotateTimerActive(true);
                }
            }
            return;
        }
        this.wasEqual = false;
        if (this.getRotateTimerActive()) {
            this.rotateTicket.cancel();
            this.rotateTicket = null;
            this.setRotateTimerActive(false);
        }
        if (this.numStagesOn > this.curStagesOn) {
            if (this.getOnDelayActive()) {
                return;
            }
            if (this.isDelayProgrammed()) {
                this.setNextStageOn();
                this.startOnDelayTimer();
            } else {
                while (this.numStagesOn > this.curStagesOn) {
                    this.setNextStageOn();
                }
            }
        } else if (this.numStagesOn < this.curStagesOn) {
            if (this.getOffDelayActive()) {
                return;
            }
            if (this.isDelayProgrammed()) {
                this.setNextStageOff();
                this.startOffDelayTimer();
            } else {
                while (this.numStagesOn < this.curStagesOn) {
                    this.setNextStageOff();
                }
            }
        }
        this.setCurrentStagesOn(this.curStagesOn);
        if (this.numStagesOn == this.curStagesOn && this.isRotating() && this.isRotateTimeProgrammed() && this.numStagesOn > 0 && this.numStagesOn < this.numOutputs) {
            this.startRotateTimer();
            this.wasEqual = true;
        }
    }

    void setNextStageOn() {
        if (this.isRotating()) {
            this.rotateNextStageOn();
        } else {
            this.linearNextStageOn();
        }
    }

    void setNextStageOff() {
        if (this.isRotating()) {
            this.rotateNextStageOff();
        } else {
            this.linearNextStageOff();
        }
    }

    void linearNextStageOn() {
        this.nxtStageOff = this.nxtStageOn;
        this.curStagesOn = this.nxtStageOn;
        this.getStatusOutput(this.nxtStageOff).setValue(true);
        this.nxtStageOn = this.nxtStageOff + 1;
        this.setNextStageOff(this.nxtStageOff);
        this.setNextStageOn(this.nxtStageOn);
    }

    void linearNextStageOff() {
        this.nxtStageOn = this.nxtStageOff;
        this.curStagesOn = this.nxtStageOff - 1;
        this.getStatusOutput(this.nxtStageOff).setValue(false);
        --this.nxtStageOff;
        this.setNextStageOff(this.nxtStageOff);
        this.setNextStageOn(this.nxtStageOn);
    }

    void rotateNextStageOn() {
        if (this.curStagesOn == 0) {
            this.nxtStageOff = this.nxtStageOn;
            this.setNextStageOff(this.nxtStageOff);
            this.startStage = this.nxtStageOn;
        }
        this.getStatusOutput(this.nxtStageOn).setValue(true);
        ++this.curStagesOn;
        this.incNextStageOn();
    }

    void incNextStageOn() {
        this.nxtStageOn = this.nxtStageOn < this.getNumberOutputs() ? ++this.nxtStageOn : (this.curStagesOn == this.numOutputs ? 0 : 1);
        this.setNextStageOn(this.nxtStageOn);
    }

    void rotateNextStageOff() {
        if (this.curStagesOn == this.numOutputs) {
            this.nxtStageOn = this.nxtStageOff;
            this.setNextStageOn(this.nxtStageOn);
        }
        this.getStatusOutput(this.nxtStageOff).setValue(false);
        --this.curStagesOn;
        this.incNextStageOff();
    }

    void incNextStageOff() {
        this.nxtStageOff = this.nxtStageOff < this.getNumberOutputs() ? ++this.nxtStageOff : (this.curStagesOn == 0 ? 0 : 1);
        if (this.curStagesOn == 0) {
            this.startStage = this.startStage < this.numOutputs ? ++this.startStage : 1;
            this.nxtStageOn = this.startStage;
            this.setNextStageOn(this.nxtStageOn);
        }
        this.setNextStageOff(this.nxtStageOff);
    }

    boolean isRotateTimeProgrammed() {
        return this.getRotateTime().getMillis() != 0L;
    }

    void startRotateTimer() {
        if (this.rotateTicket != null) {
            this.rotateTicket.cancel();
        }
        this.setRotateTimerActive(true);
        this.rotateTicket = Clock.schedule((BComponent)this, (BRelTime)this.getRotateTime(), (Action)rotateTimerExpired, null);
    }

    @Override
    public void started() {
        super.started();
        this.initNumberOutputs();
        this.numStagesOn = 0;
        this.curStagesOn = 0;
        this.setDesiredStagesOn(0);
        this.setCurrentStagesOn(0);
        this.nxtStageOn = 1;
        this.nxtStageOff = 0;
        this.setNextStageOn(1);
        this.setNextStageOff(0);
        this.setOutputsOff();
        this.execute();
    }

    public void reinitialize() {
        if (this.offTicket != null) {
            this.offTicket.cancel();
        }
        if (this.onTicket != null) {
            this.onTicket.cancel();
        }
        this.setOnDelayActive(false);
        this.setOffDelayActive(false);
        this.started();
    }

    public void initNumberOutputs() {
        int loop;
        if (this.getNumberOutputs() < 1) {
            this.setNumberOutputs(1);
        }
        if ((loop = this.getNumberOutputs()) < this.lastNumberOfOutputs) {
            loop = this.lastNumberOfOutputs;
        }
        for (int i = 1; i <= loop; ++i) {
            if (i > this.getNumberOutputs()) {
                if (i <= 1) continue;
                this.remove("Out" + i);
                continue;
            }
            BValue out = this.get("Out" + i);
            if (out != null) continue;
            this.setFlags((Slot)this.add("Out" + i, (BValue)new BStatusBoolean()), 9, null);
        }
        this.lastNumberOfOutputs = this.getNumberOutputs();
    }

    public void doOnDelayTimerExpired() {
        if (!this.isRunning()) {
            return;
        }
        this.setOnDelayActive(false);
        this.setOutputs();
    }

    public void doOffDelayTimerExpired() {
        if (!this.isRunning()) {
            return;
        }
        this.setOffDelayActive(false);
        this.setOutputs();
    }

    public BStatusBoolean getStatusOutput(int i) {
        if (i < 1) {
            return this.getOut1();
        }
        BValue out = this.get("Out" + i);
        if (out != null) {
            return (BStatusBoolean)out;
        }
        return (BStatusBoolean)this.get("Out" + this.getNumberOutputs());
    }

    public void setOutputsOff() {
        for (int i = 1; i <= this.getNumberOutputs(); ++i) {
            try {
                this.getStatusOutput(i).setValue(false);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isDelayProgrammed() {
        return this.getDelay().getMillis() != 0L;
    }

    public void startOnDelayTimer() {
        if (this.onTicket != null) {
            this.onTicket.cancel();
        }
        this.setOnDelayActive(true);
        this.onTicket = Clock.schedule((BComponent)this, (BRelTime)this.getDelay(), (Action)onDelayTimerExpired, null);
    }

    public void startOffDelayTimer() {
        if (this.offTicket != null) {
            this.offTicket.cancel();
        }
        this.setOffDelayActive(true);
        this.offTicket = Clock.schedule((BComponent)this, (BRelTime)this.getDelay(), (Action)offDelayTimerExpired, null);
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.getName().startsWith("out")) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }
}

