/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.hvac;

import com.lynxspring.control.BExecutableComponent;
import javax.baja.naming.SlotPath;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BLeadLagRuntime
extends BExecutableComponent {
    public static final Property facets = BLeadLagRuntime.newProperty((int)0, (BValue)BFacets.makeBoolean(), null);
    public static final Property in = BLeadLagRuntime.newProperty((int)520, (BValue)new BStatusBoolean(), null);
    public static final Property currentLead = BLeadLagRuntime.newProperty((int)8, (BValue)BDynamicEnum.DEFAULT, null);
    public static final Property failedLeadMode = BLeadLagRuntime.newProperty((int)0, (boolean)false, (BFacets)BFacets.makeBoolean((String)"Lead stays enabled", (String)"Lead switches to lag"));
    public static final Property numberOutputs = BLeadLagRuntime.newProperty((int)0, (int)2, (BFacets)BFacets.makeInt(null, (int)2, (int)10));
    public static final Property runTimeDelay = BLeadLagRuntime.newProperty((int)0, (BValue)BRelTime.make((long)5000L), null);
    public static final Property maxRuntime = BLeadLagRuntime.newProperty((int)0, (BValue)BRelTime.make((long)360000L), null);
    public static final Property feedbackDelay = BLeadLagRuntime.newProperty((int)0, (BValue)BRelTime.make((long)5000L), null);
    public static final Property outA = BLeadLagRuntime.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property outB = BLeadLagRuntime.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property outC = BLeadLagRuntime.newProperty((int)6, (BValue)new BStatusBoolean(), null);
    public static final Property outD = BLeadLagRuntime.newProperty((int)6, (BValue)new BStatusBoolean(), null);
    public static final Property outE = BLeadLagRuntime.newProperty((int)6, (BValue)new BStatusBoolean(), null);
    public static final Property outF = BLeadLagRuntime.newProperty((int)6, (BValue)new BStatusBoolean(), null);
    public static final Property outG = BLeadLagRuntime.newProperty((int)6, (BValue)new BStatusBoolean(), null);
    public static final Property outH = BLeadLagRuntime.newProperty((int)6, (BValue)new BStatusBoolean(), null);
    public static final Property outI = BLeadLagRuntime.newProperty((int)6, (BValue)new BStatusBoolean(), null);
    public static final Property outJ = BLeadLagRuntime.newProperty((int)6, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackA = BLeadLagRuntime.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackB = BLeadLagRuntime.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackC = BLeadLagRuntime.newProperty((int)6, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackD = BLeadLagRuntime.newProperty((int)6, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackE = BLeadLagRuntime.newProperty((int)6, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackF = BLeadLagRuntime.newProperty((int)6, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackG = BLeadLagRuntime.newProperty((int)6, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackH = BLeadLagRuntime.newProperty((int)6, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackI = BLeadLagRuntime.newProperty((int)6, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackJ = BLeadLagRuntime.newProperty((int)6, (BValue)new BStatusBoolean(), null);
    public static final Property runtimeA = BLeadLagRuntime.newProperty((int)9, (BValue)BRelTime.make((long)0L), null);
    public static final Property runtimeB = BLeadLagRuntime.newProperty((int)9, (BValue)BRelTime.make((long)0L), null);
    public static final Property runtimeC = BLeadLagRuntime.newProperty((int)5, (BValue)BRelTime.make((long)0L), null);
    public static final Property runtimeD = BLeadLagRuntime.newProperty((int)5, (BValue)BRelTime.make((long)0L), null);
    public static final Property runtimeE = BLeadLagRuntime.newProperty((int)5, (BValue)BRelTime.make((long)0L), null);
    public static final Property runtimeF = BLeadLagRuntime.newProperty((int)5, (BValue)BRelTime.make((long)0L), null);
    public static final Property runtimeG = BLeadLagRuntime.newProperty((int)5, (BValue)BRelTime.make((long)0L), null);
    public static final Property runtimeH = BLeadLagRuntime.newProperty((int)5, (BValue)BRelTime.make((long)0L), null);
    public static final Property runtimeI = BLeadLagRuntime.newProperty((int)5, (BValue)BRelTime.make((long)0L), null);
    public static final Property runtimeJ = BLeadLagRuntime.newProperty((int)5, (BValue)BRelTime.make((long)0L), null);
    public static final Property estRuntimeRemaining = BLeadLagRuntime.newProperty((int)9, (BValue)BRelTime.make((long)0L), null);
    public static final Action runtimeTimerExpired = BLeadLagRuntime.newAction((int)4, null);
    public static final Action lagRuntimeTimerExpired = BLeadLagRuntime.newAction((int)4, null);
    public static final Action feedbackExpired = BLeadLagRuntime.newAction((int)4, (BValue)BInteger.make((int)0), null);
    public static final Action trigger = BLeadLagRuntime.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BLeadLagRuntime.class);
    private int numOutputs;
    private boolean wasOn = false;
    private boolean outputsOn = false;
    private boolean[] feedbacks = new boolean[10];
    int curLead = 0;
    int curLag = -1;
    private long start;
    private Clock.Ticket runtimeTicket;
    private long lagStart;
    private Clock.Ticket lagRuntimeTicket;
    Clock.Ticket feedbackATicket;
    Clock.Ticket feedbackBTicket;
    Clock.Ticket feedbackCTicket;
    Clock.Ticket feedbackDTicket;
    Clock.Ticket feedbackETicket;
    Clock.Ticket feedbackFTicket;
    Clock.Ticket feedbackGTicket;
    Clock.Ticket feedbackHTicket;
    Clock.Ticket feedbackITicket;
    Clock.Ticket feedbackJTicket;
    BEnumRange leadEnumRange;
    private boolean atSteadyState = false;

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    public BStatusBoolean getIn() {
        return (BStatusBoolean)this.get(in);
    }

    public void setIn(BStatusBoolean v) {
        this.set(in, (BValue)v, null);
    }

    public BDynamicEnum getCurrentLead() {
        return (BDynamicEnum)this.get(currentLead);
    }

    public void setCurrentLead(BDynamicEnum v) {
        this.set(currentLead, (BValue)v, null);
    }

    public boolean getFailedLeadMode() {
        return this.getBoolean(failedLeadMode);
    }

    public void setFailedLeadMode(boolean v) {
        this.setBoolean(failedLeadMode, v, null);
    }

    public int getNumberOutputs() {
        return this.getInt(numberOutputs);
    }

    public void setNumberOutputs(int v) {
        this.setInt(numberOutputs, v, null);
    }

    public BRelTime getRunTimeDelay() {
        return (BRelTime)this.get(runTimeDelay);
    }

    public void setRunTimeDelay(BRelTime v) {
        this.set(runTimeDelay, (BValue)v, null);
    }

    public BRelTime getMaxRuntime() {
        return (BRelTime)this.get(maxRuntime);
    }

    public void setMaxRuntime(BRelTime v) {
        this.set(maxRuntime, (BValue)v, null);
    }

    public BRelTime getFeedbackDelay() {
        return (BRelTime)this.get(feedbackDelay);
    }

    public void setFeedbackDelay(BRelTime v) {
        this.set(feedbackDelay, (BValue)v, null);
    }

    public BStatusBoolean getOutA() {
        return (BStatusBoolean)this.get(outA);
    }

    public void setOutA(BStatusBoolean v) {
        this.set(outA, (BValue)v, null);
    }

    public BStatusBoolean getOutB() {
        return (BStatusBoolean)this.get(outB);
    }

    public void setOutB(BStatusBoolean v) {
        this.set(outB, (BValue)v, null);
    }

    public BStatusBoolean getOutC() {
        return (BStatusBoolean)this.get(outC);
    }

    public void setOutC(BStatusBoolean v) {
        this.set(outC, (BValue)v, null);
    }

    public BStatusBoolean getOutD() {
        return (BStatusBoolean)this.get(outD);
    }

    public void setOutD(BStatusBoolean v) {
        this.set(outD, (BValue)v, null);
    }

    public BStatusBoolean getOutE() {
        return (BStatusBoolean)this.get(outE);
    }

    public void setOutE(BStatusBoolean v) {
        this.set(outE, (BValue)v, null);
    }

    public BStatusBoolean getOutF() {
        return (BStatusBoolean)this.get(outF);
    }

    public void setOutF(BStatusBoolean v) {
        this.set(outF, (BValue)v, null);
    }

    public BStatusBoolean getOutG() {
        return (BStatusBoolean)this.get(outG);
    }

    public void setOutG(BStatusBoolean v) {
        this.set(outG, (BValue)v, null);
    }

    public BStatusBoolean getOutH() {
        return (BStatusBoolean)this.get(outH);
    }

    public void setOutH(BStatusBoolean v) {
        this.set(outH, (BValue)v, null);
    }

    public BStatusBoolean getOutI() {
        return (BStatusBoolean)this.get(outI);
    }

    public void setOutI(BStatusBoolean v) {
        this.set(outI, (BValue)v, null);
    }

    public BStatusBoolean getOutJ() {
        return (BStatusBoolean)this.get(outJ);
    }

    public void setOutJ(BStatusBoolean v) {
        this.set(outJ, (BValue)v, null);
    }

    public BStatusBoolean getFeedbackA() {
        return (BStatusBoolean)this.get(feedbackA);
    }

    public void setFeedbackA(BStatusBoolean v) {
        this.set(feedbackA, (BValue)v, null);
    }

    public BStatusBoolean getFeedbackB() {
        return (BStatusBoolean)this.get(feedbackB);
    }

    public void setFeedbackB(BStatusBoolean v) {
        this.set(feedbackB, (BValue)v, null);
    }

    public BStatusBoolean getFeedbackC() {
        return (BStatusBoolean)this.get(feedbackC);
    }

    public void setFeedbackC(BStatusBoolean v) {
        this.set(feedbackC, (BValue)v, null);
    }

    public BStatusBoolean getFeedbackD() {
        return (BStatusBoolean)this.get(feedbackD);
    }

    public void setFeedbackD(BStatusBoolean v) {
        this.set(feedbackD, (BValue)v, null);
    }

    public BStatusBoolean getFeedbackE() {
        return (BStatusBoolean)this.get(feedbackE);
    }

    public void setFeedbackE(BStatusBoolean v) {
        this.set(feedbackE, (BValue)v, null);
    }

    public BStatusBoolean getFeedbackF() {
        return (BStatusBoolean)this.get(feedbackF);
    }

    public void setFeedbackF(BStatusBoolean v) {
        this.set(feedbackF, (BValue)v, null);
    }

    public BStatusBoolean getFeedbackG() {
        return (BStatusBoolean)this.get(feedbackG);
    }

    public void setFeedbackG(BStatusBoolean v) {
        this.set(feedbackG, (BValue)v, null);
    }

    public BStatusBoolean getFeedbackH() {
        return (BStatusBoolean)this.get(feedbackH);
    }

    public void setFeedbackH(BStatusBoolean v) {
        this.set(feedbackH, (BValue)v, null);
    }

    public BStatusBoolean getFeedbackI() {
        return (BStatusBoolean)this.get(feedbackI);
    }

    public void setFeedbackI(BStatusBoolean v) {
        this.set(feedbackI, (BValue)v, null);
    }

    public BStatusBoolean getFeedbackJ() {
        return (BStatusBoolean)this.get(feedbackJ);
    }

    public void setFeedbackJ(BStatusBoolean v) {
        this.set(feedbackJ, (BValue)v, null);
    }

    public BRelTime getRuntimeA() {
        return (BRelTime)this.get(runtimeA);
    }

    public void setRuntimeA(BRelTime v) {
        this.set(runtimeA, (BValue)v, null);
    }

    public BRelTime getRuntimeB() {
        return (BRelTime)this.get(runtimeB);
    }

    public void setRuntimeB(BRelTime v) {
        this.set(runtimeB, (BValue)v, null);
    }

    public BRelTime getRuntimeC() {
        return (BRelTime)this.get(runtimeC);
    }

    public void setRuntimeC(BRelTime v) {
        this.set(runtimeC, (BValue)v, null);
    }

    public BRelTime getRuntimeD() {
        return (BRelTime)this.get(runtimeD);
    }

    public void setRuntimeD(BRelTime v) {
        this.set(runtimeD, (BValue)v, null);
    }

    public BRelTime getRuntimeE() {
        return (BRelTime)this.get(runtimeE);
    }

    public void setRuntimeE(BRelTime v) {
        this.set(runtimeE, (BValue)v, null);
    }

    public BRelTime getRuntimeF() {
        return (BRelTime)this.get(runtimeF);
    }

    public void setRuntimeF(BRelTime v) {
        this.set(runtimeF, (BValue)v, null);
    }

    public BRelTime getRuntimeG() {
        return (BRelTime)this.get(runtimeG);
    }

    public void setRuntimeG(BRelTime v) {
        this.set(runtimeG, (BValue)v, null);
    }

    public BRelTime getRuntimeH() {
        return (BRelTime)this.get(runtimeH);
    }

    public void setRuntimeH(BRelTime v) {
        this.set(runtimeH, (BValue)v, null);
    }

    public BRelTime getRuntimeI() {
        return (BRelTime)this.get(runtimeI);
    }

    public void setRuntimeI(BRelTime v) {
        this.set(runtimeI, (BValue)v, null);
    }

    public BRelTime getRuntimeJ() {
        return (BRelTime)this.get(runtimeJ);
    }

    public void setRuntimeJ(BRelTime v) {
        this.set(runtimeJ, (BValue)v, null);
    }

    public BRelTime getEstRuntimeRemaining() {
        return (BRelTime)this.get(estRuntimeRemaining);
    }

    public void setEstRuntimeRemaining(BRelTime v) {
        this.set(estRuntimeRemaining, (BValue)v, null);
    }

    public void runtimeTimerExpired() {
        this.invoke(runtimeTimerExpired, null, null);
    }

    public void lagRuntimeTimerExpired() {
        this.invoke(lagRuntimeTimerExpired, null, null);
    }

    public void feedbackExpired(BInteger arg) {
        this.invoke(feedbackExpired, (BValue)arg, null);
    }

    public void trigger() {
        this.invoke(trigger, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() {
        super.started();
        this.initNumberOutputs();
        if (Sys.atSteadyState()) {
            this.atSteadyState();
        }
    }

    public void atSteadyState() {
        this.atSteadyState = true;
        this.doExecute();
    }

    @Override
    public void changed(Property p, Context cx) {
        if (this.atSteadyState && this.isRunning()) {
            if (p == numberOutputs) {
                this.initNumberOutputs();
            } else if (p == maxRuntime) {
                this.setEstRuntimeRemaining(BRelTime.make((long)0L));
            } else if (p == currentLead) {
                int changedTo = this.getCurrentLead().getOrdinal();
                if (this.getIn().getValue() && changedTo < this.numOutputs && changedTo != this.curLead) {
                    this.changeLead(changedTo);
                } else if (changedTo != this.curLead) {
                    this.setCurrentLead(BDynamicEnum.make((int)this.curLead, (BEnumRange)this.leadEnumRange));
                }
            } else if (p == this.getProperty("displayNames")) {
                int[] enumOrds = new int[this.numOutputs];
                String[] enumTags = new String[this.numOutputs];
                for (int i = 0; i < this.numOutputs; ++i) {
                    enumOrds[i] = i;
                    enumTags[i] = SlotPath.escape((String)this.getStatusOutput(i).getDisplayName(null));
                }
                this.leadEnumRange = BEnumRange.make((int[])enumOrds, (String[])enumTags);
                this.setCurrentLead(BDynamicEnum.make((int)this.curLead, (BEnumRange)this.leadEnumRange));
            } else if (p == feedbackA || p == feedbackB || p == feedbackC || p == feedbackD || p == feedbackE || p == feedbackF || p == feedbackG || p == feedbackH || p == feedbackI || p == feedbackJ) {
                this.checkFeedback(p);
            }
        }
        super.changed(p, cx);
    }

    private void initNumberOutputs() {
        if (!this.isRunning()) {
            return;
        }
        this.numOutputs = this.getNumberOutputs();
        int displayFlag = 8;
        int[] enumOrds = new int[this.numOutputs];
        String[] enumTags = new String[this.numOutputs];
        block12: for (int i = 0; i < 10; ++i) {
            if (i >= this.numOutputs) {
                displayFlag = 4;
            } else {
                enumOrds[i] = i;
                enumTags[i] = SlotPath.escape((String)this.getStatusOutput(i).getDisplayName(null));
            }
            switch (i) {
                case 0: {
                    this.initSlot("outA", displayFlag | 2 | 1);
                    this.initSlot("runtimeA", displayFlag | 1);
                    this.initSlot("feedbackA", displayFlag | 2);
                    continue block12;
                }
                case 1: {
                    this.initSlot("outB", displayFlag | 2 | 1);
                    this.initSlot("runtimeB", displayFlag | 1);
                    this.initSlot("feedbackB", displayFlag | 2);
                    continue block12;
                }
                case 2: {
                    this.initSlot("outC", displayFlag | 2 | 1);
                    this.initSlot("runtimeC", displayFlag | 1);
                    this.initSlot("feedbackC", displayFlag | 2);
                    continue block12;
                }
                case 3: {
                    this.initSlot("outD", displayFlag | 2 | 1);
                    this.initSlot("runtimeD", displayFlag | 1);
                    this.initSlot("feedbackD", displayFlag | 2);
                    continue block12;
                }
                case 4: {
                    this.initSlot("outE", displayFlag | 2 | 1);
                    this.initSlot("runtimeE", displayFlag | 1);
                    this.initSlot("feedbackE", displayFlag | 2);
                    continue block12;
                }
                case 5: {
                    this.initSlot("outF", displayFlag | 2 | 1);
                    this.initSlot("runtimeF", displayFlag | 1);
                    this.initSlot("feedbackF", displayFlag | 2);
                    continue block12;
                }
                case 6: {
                    this.initSlot("outG", displayFlag | 2 | 1);
                    this.initSlot("runtimeG", displayFlag | 1);
                    this.initSlot("feedbackG", displayFlag | 2);
                    continue block12;
                }
                case 7: {
                    this.initSlot("outH", displayFlag | 2 | 1);
                    this.initSlot("runtimeH", displayFlag | 1);
                    this.initSlot("feedbackH", displayFlag | 2);
                    continue block12;
                }
                case 8: {
                    this.initSlot("outI", displayFlag | 2 | 1);
                    this.initSlot("runtimeI", displayFlag | 1);
                    this.initSlot("feedbackI", displayFlag | 2);
                    continue block12;
                }
                case 9: {
                    this.initSlot("outJ", displayFlag | 2 | 1);
                    this.initSlot("runtimeJ", displayFlag | 1);
                    this.initSlot("feedbackJ", displayFlag | 2);
                }
            }
        }
        this.leadEnumRange = BEnumRange.make((int[])enumOrds, (String[])enumTags);
        this.setCurrentLead(BDynamicEnum.make((int)this.curLead, (BEnumRange)this.leadEnumRange));
    }

    private void initSlot(String slot, int flags) {
        try {
            this.setFlags(this.getSlot(slot), flags, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void checkFeedback(Property p) {
        int feedbackIndex = -1;
        if (p == feedbackA) {
            feedbackIndex = 0;
        } else if (p == feedbackB) {
            feedbackIndex = 1;
        } else if (p == feedbackC) {
            feedbackIndex = 2;
        } else if (p == feedbackD) {
            feedbackIndex = 3;
        } else if (p == feedbackE) {
            feedbackIndex = 4;
        } else if (p == feedbackF) {
            feedbackIndex = 5;
        } else if (p == feedbackG) {
            feedbackIndex = 6;
        } else if (p == feedbackH) {
            feedbackIndex = 7;
        } else if (p == feedbackI) {
            feedbackIndex = 8;
        } else if (p == feedbackJ) {
            feedbackIndex = 9;
        }
        if (feedbackIndex < 0 || feedbackIndex >= this.numOutputs) {
            return;
        }
        boolean out = this.getOutValue(feedbackIndex);
        boolean feedback = this.getFeedbackValue(feedbackIndex);
        if (feedback == this.feedbacks[feedbackIndex]) {
            return;
        }
        this.feedbacks[feedbackIndex] = feedback;
        if (!Sys.atSteadyState() || !this.getIn().getValue()) {
            return;
        }
        BStatus status = BStatus.ok;
        int newLead = -1;
        boolean enableLag = false;
        if (feedback && !out) {
            status = BStatus.overridden;
            if (!this.getFailedLeadMode()) {
                this.stopOutput(false);
            }
        } else if (feedback) {
            this.stopFeedbackTimer(feedbackIndex);
            if (feedbackIndex == this.curLead) {
                this.start = BAbsTime.now().getMillis() - this.getRuntime(feedbackIndex);
                this.startRuntimeTimer();
                if (this.curLag > -1) {
                    this.getStatusOutput(this.curLag).setValue(false);
                    this.stopFeedbackTimer(this.curLag);
                    this.stopLagRuntimeTimer();
                    this.curLag = -1;
                }
            } else if (feedbackIndex == this.curLag) {
                this.lagStart = BAbsTime.now().getMillis() - this.getRuntime(feedbackIndex);
                this.startLagRuntimeTimer();
            }
        } else if (out) {
            status = BStatus.alarm;
            if (this.getFailedLeadMode()) {
                enableLag = true;
            } else {
                newLead = this.curLead + 1;
                if (newLead >= this.numOutputs) {
                    newLead = 0;
                }
            }
        } else {
            this.stopFeedbackTimer(feedbackIndex);
            if (this.getStatusOutput(feedbackIndex).getStatus().isOverridden() && !this.outputsOn) {
                this.startOutput();
            }
        }
        this.setStatus(feedbackIndex, status);
        if (newLead > -1) {
            this.changeLead(newLead);
        } else if (enableLag) {
            this.enableLag(this.curLag);
        }
    }

    public void doFeedbackExpired(BInteger bindex) {
        if (!this.isRunning() || !this.outputsOn) {
            return;
        }
        int index = bindex.getInt();
        if (this.getOutValue(index) && !this.getFeedbackValue(index)) {
            this.setStatus(index, BStatus.alarm);
            this.enableLag(index);
        } else if (!this.getOutValue(index) && this.getFeedbackValue(index)) {
            if (!this.getFailedLeadMode()) {
                this.stopOutput(false);
            }
            this.setStatus(index, BStatus.overridden);
        } else {
            this.setStatus(index, BStatus.ok);
            this.checkRuntimeTimer(index);
        }
    }

    private void enableLag(int index) {
        this.stopLagRuntimeTimer();
        if (!this.getFailedLeadMode()) {
            this.changeLead(index);
        } else {
            if (this.curLag > -1) {
                this.getStatusOutput(this.curLag).setValue(false);
            } else {
                this.curLag = this.curLead;
            }
            ++this.curLag;
            if (this.curLag >= this.numOutputs) {
                this.curLag = 0;
            }
            if (this.curLag == this.curLead) {
                ++this.curLag;
            }
            if (this.curLag >= this.numOutputs) {
                this.curLag = 0;
            }
            this.getStatusOutput(this.curLag).setValue(true);
            this.startFeedbackTimer(this.curLag);
        }
    }

    private void setStatus(int index, BStatus status) {
        if (!this.getStatusOutput(index).equivalent((Object)status)) {
            this.getStatusOutput(index).setStatus(status);
        }
    }

    public void doRuntimeTimerExpired() {
        if (!this.isRunning() || !this.outputsOn) {
            return;
        }
        this.setRuntime(this.curLead, BRelTime.make((long)(BAbsTime.now().getMillis() - this.start)));
        this.startOutput();
        this.startRuntimeTimer();
    }

    public void doLagRuntimeTimerExpired() {
        if (!this.isRunning() || !this.outputsOn || this.curLag < 0) {
            return;
        }
        long runTime = BAbsTime.now().getMillis() - this.lagStart;
        if (runTime < this.getMaxRuntime().getMillis()) {
            this.setRuntime(this.curLag, BRelTime.make((long)runTime));
            this.startLagRuntimeTimer();
        } else {
            this.enableLag(this.curLag);
            this.setRuntime(this.curLag, BRelTime.DEFAULT);
        }
    }

    @Override
    public void doExecute() {
        if (this.getIn().getValue()) {
            if (!this.wasOn) {
                this.startOutput();
                this.wasOn = true;
            }
        } else if (this.wasOn) {
            this.stopOutput(true);
            this.wasOn = false;
        }
    }

    public void doTrigger() {
        if (!this.isRunning() || !this.atSteadyState || this.getIn().isNull() || !this.getIn().getBoolean()) {
            return;
        }
        int index = this.curLead + 1;
        if (index >= this.numOutputs) {
            index = 0;
        }
        this.changeLead(index);
    }

    private long getRuntime(int index) {
        switch (index) {
            case 0: {
                return this.getRuntimeA().getMillis();
            }
            case 1: {
                return this.getRuntimeB().getMillis();
            }
            case 2: {
                return this.getRuntimeC().getMillis();
            }
            case 3: {
                return this.getRuntimeD().getMillis();
            }
            case 4: {
                return this.getRuntimeE().getMillis();
            }
            case 5: {
                return this.getRuntimeF().getMillis();
            }
            case 6: {
                return this.getRuntimeG().getMillis();
            }
            case 7: {
                return this.getRuntimeH().getMillis();
            }
            case 8: {
                return this.getRuntimeI().getMillis();
            }
            case 9: {
                return this.getRuntimeJ().getMillis();
            }
        }
        return Long.MAX_VALUE;
    }

    private boolean getOutValue(int index) {
        switch (index) {
            case 0: {
                return this.getOutA().getValue();
            }
            case 1: {
                return this.getOutB().getValue();
            }
            case 2: {
                return this.getOutC().getValue();
            }
            case 3: {
                return this.getOutD().getValue();
            }
            case 4: {
                return this.getOutE().getValue();
            }
            case 5: {
                return this.getOutF().getValue();
            }
            case 6: {
                return this.getOutG().getValue();
            }
            case 7: {
                return this.getOutH().getValue();
            }
            case 8: {
                return this.getOutI().getValue();
            }
            case 9: {
                return this.getOutJ().getValue();
            }
        }
        return false;
    }

    private boolean getFeedbackValue(int index) {
        switch (index) {
            case 0: {
                return this.getFeedbackA().getValue();
            }
            case 1: {
                return this.getFeedbackB().getValue();
            }
            case 2: {
                return this.getFeedbackC().getValue();
            }
            case 3: {
                return this.getFeedbackD().getValue();
            }
            case 4: {
                return this.getFeedbackE().getValue();
            }
            case 5: {
                return this.getFeedbackF().getValue();
            }
            case 6: {
                return this.getFeedbackG().getValue();
            }
            case 7: {
                return this.getFeedbackH().getValue();
            }
            case 8: {
                return this.getFeedbackI().getValue();
            }
            case 9: {
                return this.getFeedbackJ().getValue();
            }
        }
        return false;
    }

    private void resetRuntime(int index) {
        this.setRuntime(index, BRelTime.make((long)0L));
    }

    private void setRuntime(int index, BRelTime time) {
        if (this.getMaxRuntime().getMillis() > 0L && index == this.curLead) {
            this.setEstRuntimeRemaining(BRelTime.make((long)(this.getMaxRuntime().getMillis() - time.getMillis())));
        } else if (this.getMaxRuntime().getMillis() <= 0L && this.getEstRuntimeRemaining().getMillis() > 0L) {
            this.setEstRuntimeRemaining(BRelTime.make((long)0L));
        }
        switch (index) {
            case 0: {
                this.setRuntimeA(time);
                break;
            }
            case 1: {
                this.setRuntimeB(time);
                break;
            }
            case 2: {
                this.setRuntimeC(time);
                break;
            }
            case 3: {
                this.setRuntimeD(time);
                break;
            }
            case 4: {
                this.setRuntimeE(time);
                break;
            }
            case 5: {
                this.setRuntimeF(time);
                break;
            }
            case 6: {
                this.setRuntimeG(time);
                break;
            }
            case 7: {
                this.setRuntimeH(time);
                break;
            }
            case 8: {
                this.setRuntimeI(time);
                break;
            }
            case 9: {
                this.setRuntimeJ(time);
            }
        }
    }

    public void changeLead(int index) {
        if (index < 0 || index >= this.numOutputs) {
            return;
        }
        if (!this.getOutValue(index)) {
            this.stopFeedbackTimer(this.curLead);
            this.stopRuntimeTimer();
            if (this.curLead != index) {
                this.resetRuntime(this.curLead);
                this.curLead = index;
            }
            if (!this.getFeedbackValue(this.curLead)) {
                this.startFeedbackTimer(this.curLead);
            }
            for (int i = 0; i < this.numOutputs; ++i) {
                this.getStatusOutput(i).setValue(this.curLead == i);
            }
        }
        this.setCurrentLead(BDynamicEnum.make((int)this.curLead, (BEnumRange)this.leadEnumRange));
    }

    private void startOutput() {
        this.outputsOn = true;
        int index = 0;
        for (int i = 0; i < this.numOutputs; ++i) {
            if (this.getRuntime(i) <= 0L) continue;
            if (this.getMaxRuntime().getMillis() > 0L && this.getRuntime(i) >= this.getMaxRuntime().getMillis()) {
                this.resetRuntime(i);
                index = i + 1;
            } else {
                index = i;
            }
            if (index >= this.numOutputs) {
                index = 0;
            }
            ++i;
            while (i < this.numOutputs) {
                this.resetRuntime(i);
                ++i;
            }
        }
        if (this.curLag < 0) {
            this.changeLead(index);
        }
    }

    private void stopOutput(boolean setOK) {
        int i;
        this.outputsOn = false;
        if (this.runtimeTicket != null) {
            this.runtimeTicket.cancel();
        }
        for (i = 0; i < this.numOutputs; ++i) {
            this.getStatusOutput(i).setValue(false);
            if (!setOK) continue;
            this.getStatusOutput(i).setStatus(BStatus.ok);
        }
        for (i = 0; i < this.numOutputs; ++i) {
            this.stopFeedbackTimer(i);
        }
    }

    private BStatusBoolean getStatusOutput(int index) {
        switch (index) {
            case 0: {
                return this.getOutA();
            }
            case 1: {
                return this.getOutB();
            }
            case 2: {
                return this.getOutC();
            }
            case 3: {
                return this.getOutD();
            }
            case 4: {
                return this.getOutE();
            }
            case 5: {
                return this.getOutF();
            }
            case 6: {
                return this.getOutG();
            }
            case 7: {
                return this.getOutH();
            }
            case 8: {
                return this.getOutI();
            }
            case 9: {
                return this.getOutJ();
            }
        }
        return this.getOutA();
    }

    private void checkRuntimeTimer(int index) {
        if (this.runtimeTicket == null || this.runtimeTicket.isExpired()) {
            this.start = BAbsTime.now().getMillis() - this.getRuntime(index);
            this.runtimeTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getRunTimeDelay(), (Action)runtimeTimerExpired, null);
        }
    }

    private void startRuntimeTimer() {
        this.stopRuntimeTimer();
        this.runtimeTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getRunTimeDelay(), (Action)runtimeTimerExpired, null);
    }

    private void stopRuntimeTimer() {
        if (this.runtimeTicket != null) {
            this.runtimeTicket.cancel();
        }
    }

    private void startLagRuntimeTimer() {
        this.stopLagRuntimeTimer();
        this.lagRuntimeTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getRunTimeDelay(), (Action)lagRuntimeTimerExpired, null);
    }

    private void stopLagRuntimeTimer() {
        if (this.lagRuntimeTicket != null) {
            this.lagRuntimeTicket.cancel();
        }
    }

    private Clock.Ticket getFeedbackTimer(int index) {
        switch (index) {
            case 0: {
                return this.feedbackATicket;
            }
            case 1: {
                return this.feedbackBTicket;
            }
            case 2: {
                return this.feedbackCTicket;
            }
            case 3: {
                return this.feedbackDTicket;
            }
            case 4: {
                return this.feedbackETicket;
            }
            case 5: {
                return this.feedbackFTicket;
            }
            case 6: {
                return this.feedbackGTicket;
            }
            case 7: {
                return this.feedbackHTicket;
            }
            case 8: {
                return this.feedbackITicket;
            }
            case 9: {
                return this.feedbackJTicket;
            }
        }
        return null;
    }

    private void startFeedbackTimer(int index) {
        Clock.Ticket ticket = this.getFeedbackTimer(index);
        if (ticket != null) {
            ticket.cancel();
        }
        if (this.getFeedbackDelay().getMillis() > 0L) {
            ticket = Clock.schedule((BComponent)this, (BRelTime)this.getFeedbackDelay(), (Action)feedbackExpired, (BValue)BInteger.make((int)index));
        }
    }

    private void stopFeedbackTimer(int index) {
        Clock.Ticket ticket = this.getFeedbackTimer(index);
        if (ticket != null) {
            ticket.cancel();
        }
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.getName().startsWith("out")) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }
}

