/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.hvac;

import com.lynxspring.control.util.Util;
import com.tridium.kitControl.enums.BLoopAction;
import com.tridium.kitControl.logic.BLogic;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BHighLowTstat
extends BLogic {
    public static final Property cv = BHighLowTstat.newProperty((int)0, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), null);
    public static final Property sp = BHighLowTstat.newProperty((int)0, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), null);
    public static final Property lowDiff = BHighLowTstat.newProperty((int)0, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), null);
    public static final Property highDiff = BHighLowTstat.newProperty((int)0, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), null);
    public static final Property action = BHighLowTstat.newProperty((int)0, (BValue)BLoopAction.direct, null);
    public static final Type TYPE = Sys.loadType(BHighLowTstat.class);
    private boolean licensed = false;

    public BStatusNumeric getCv() {
        return (BStatusNumeric)this.get(cv);
    }

    public void setCv(BStatusNumeric v) {
        this.set(cv, (BValue)v, null);
    }

    public BStatusNumeric getSp() {
        return (BStatusNumeric)this.get(sp);
    }

    public void setSp(BStatusNumeric v) {
        this.set(sp, (BValue)v, null);
    }

    public BStatusNumeric getLowDiff() {
        return (BStatusNumeric)this.get(lowDiff);
    }

    public void setLowDiff(BStatusNumeric v) {
        this.set(lowDiff, (BValue)v, null);
    }

    public BStatusNumeric getHighDiff() {
        return (BStatusNumeric)this.get(highDiff);
    }

    public void setHighDiff(BStatusNumeric v) {
        this.set(highDiff, (BValue)v, null);
    }

    public BLoopAction getAction() {
        return (BLoopAction)this.get(action);
    }

    public void setAction(BLoopAction v) {
        this.set(action, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (!this.isRunning()) {
            return;
        }
        this.licensed = Util.checkLicense();
    }

    public void onExecute(BStatusValue o, Context cx) {
        if (!this.licensed) {
            Util.notLicensed();
            return;
        }
        BStatusNumeric controlVariable = this.getCv();
        BStatusNumeric setpoint = this.getSp();
        BStatusBoolean out = (BStatusBoolean)o;
        BStatus sa = controlVariable.getStatus();
        BStatus sb = setpoint.getStatus();
        if (sa.isNull() || sb.isNull()) {
            out.setValue(false);
            out.setStatus(BStatus.nullStatus);
        } else {
            out.setStatus(this.propagate(BStatus.make((int)(sa.getBits() | sb.getBits()))));
            if (!sa.isValid() || !sb.isValid()) {
                out.setValue(false);
            } else {
                out.setValue(this.calculate());
            }
            if (this.getNullOnInactive() && !out.getValue()) {
                out.setStatusNull(true);
            }
        }
    }

    protected boolean calculate() {
        double currentValue;
        double highValue = this.getSp().getValue() + this.getHighDiff().getValue();
        double lowValue = this.getSp().getValue() - this.getLowDiff().getValue();
        boolean returnValue = this.getOut().getValue();
        if (this.getAction() != BLoopAction.direct) {
            boolean bl = returnValue = !returnValue;
        }
        if ((currentValue = this.getCv().getValue()) >= highValue) {
            returnValue = true;
        } else if (currentValue <= lowValue) {
            returnValue = false;
        }
        if (this.getAction() != BLoopAction.direct) {
            returnValue = !returnValue;
        }
        return returnValue;
    }
}

