/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.http;

import com.lynxspring.control.BExecutableComponent;
import java.io.BufferedInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.baja.status.BStatusString;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BHttpGet
extends BExecutableComponent {
    private static final String STATUS_SLEEP = "Sleep";
    private static final String STATUS_REQ = "Request";
    private static final String STATUS_ERR = "Exception";
    private static final String STATUS_URL = "No Url";
    public static final Property url = BHttpGet.newProperty((int)520, (String)"", null);
    public static final Property requestPeriod = BHttpGet.newProperty((int)520, (BValue)BRelTime.makeMinutes((int)2), null);
    public static final Property retryPeriod = BHttpGet.newProperty((int)520, (BValue)BRelTime.makeMinutes((int)15), null);
    public static final Property lastPollTime = BHttpGet.newProperty((int)0, (BValue)BAbsTime.NULL, null);
    public static final Property lastPollSuccess = BHttpGet.newProperty((int)0, (BValue)BAbsTime.NULL, null);
    public static final Property state = BHttpGet.newProperty((int)9, (String)"Sleep", null);
    public static final Property result = BHttpGet.newProperty((int)9, (BValue)new BStatusString(), (BFacets)BFacets.make((String)"multiLine", (boolean)true));
    public static final Type TYPE = Sys.loadType(BHttpGet.class);
    Clock.Ticket ticket;

    public String getUrl() {
        return this.getString(url);
    }

    public void setUrl(String v) {
        this.setString(url, v, null);
    }

    public BRelTime getRequestPeriod() {
        return (BRelTime)this.get(requestPeriod);
    }

    public void setRequestPeriod(BRelTime v) {
        this.set(requestPeriod, (BValue)v, null);
    }

    public BRelTime getRetryPeriod() {
        return (BRelTime)this.get(retryPeriod);
    }

    public void setRetryPeriod(BRelTime v) {
        this.set(retryPeriod, (BValue)v, null);
    }

    public BAbsTime getLastPollTime() {
        return (BAbsTime)this.get(lastPollTime);
    }

    public void setLastPollTime(BAbsTime v) {
        this.set(lastPollTime, (BValue)v, null);
    }

    public BAbsTime getLastPollSuccess() {
        return (BAbsTime)this.get(lastPollSuccess);
    }

    public void setLastPollSuccess(BAbsTime v) {
        this.set(lastPollSuccess, (BValue)v, null);
    }

    public String getState() {
        return this.getString(state);
    }

    public void setState(String v) {
        this.setString(state, v, null);
    }

    public BStatusString getResult() {
        return (BStatusString)this.get(result);
    }

    public void setResult(BStatusString v) {
        this.set(result, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void stationStarted() {
        this.execute();
    }

    @Override
    public void doExecute() {
        if (this.getUrl().length() == 0) {
            this.setState(STATUS_URL);
            return;
        }
        try {
            int c;
            this.setState(STATUS_REQ);
            this.setLastPollTime(BAbsTime.now());
            String tResult = "";
            URL u = new URL(this.getUrl());
            HttpURLConnection huc = (HttpURLConnection)u.openConnection();
            BufferedInputStream buffer = new BufferedInputStream(huc.getInputStream());
            InputStreamReader r = new InputStreamReader(buffer);
            while ((c = ((Reader)r).read()) != -1) {
                tResult = tResult + (char)c;
            }
            this.setResult(new BStatusString(tResult));
            this.setLastPollSuccess(BAbsTime.now());
            this.setState(STATUS_SLEEP);
            this.startTicket(this.getRequestPeriod());
            ((Reader)r).close();
        }
        catch (Exception e) {
            this.setState(STATUS_ERR);
            this.startTicket(this.getRetryPeriod());
            e.printStackTrace();
        }
    }

    private void startTicket(BRelTime delay) {
        this.stopTicket();
        this.ticket = Clock.schedule((BComponent)this, (BRelTime)delay, (Action)execute, null);
    }

    private void stopTicket() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
    }
}

