/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.global;

import com.lynxspring.control.util.Util;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Queue;

public class BSelfLinkExt
extends BComponent {
    public static final Property masterOrd = BSelfLinkExt.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Property toSlot = BSelfLinkExt.newProperty((int)0, (String)"fallback", null);
    public static final Property removeOnLink = BSelfLinkExt.newProperty((int)0, (boolean)false, null);
    public static final Property linkOnStart = BSelfLinkExt.newProperty((int)0, (boolean)false, null);
    public static final Action linkFromMaster = BSelfLinkExt.newAction((int)0, null);
    public static final Action removeExt = BSelfLinkExt.newAction((int)20, null);
    public static final Type TYPE = Sys.loadType(BSelfLinkExt.class);
    static LinkThread linkThread;

    public BOrd getMasterOrd() {
        return (BOrd)this.get(masterOrd);
    }

    public void setMasterOrd(BOrd v) {
        this.set(masterOrd, (BValue)v, null);
    }

    public String getToSlot() {
        return this.getString(toSlot);
    }

    public void setToSlot(String v) {
        this.setString(toSlot, v, null);
    }

    public boolean getRemoveOnLink() {
        return this.getBoolean(removeOnLink);
    }

    public void setRemoveOnLink(boolean v) {
        this.setBoolean(removeOnLink, v, null);
    }

    public boolean getLinkOnStart() {
        return this.getBoolean(linkOnStart);
    }

    public void setLinkOnStart(boolean v) {
        this.setBoolean(linkOnStart, v, null);
    }

    public void linkFromMaster() {
        this.invoke(linkFromMaster, null, null);
    }

    public void removeExt() {
        this.invoke(removeExt, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        if (this.isRunning() && Sys.isStationStarted()) {
            this.stationStarted();
        }
    }

    public void stationStarted() {
        if (this.getLinkOnStart()) {
            this.linkFromMaster();
        }
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property == masterOrd) {
            this.removeLink();
            this.linkFromMaster();
        }
    }

    public void removeLink() {
        BLink[] links = this.getTheLinks();
        for (int i = 0; i < links.length; ++i) {
            links[i].getParent().asComponent().remove((BComplex)links[i]);
        }
    }

    public boolean isLinked() {
        return this.getTheLinks().length > 0;
    }

    private BLink[] getTheLinks() {
        BComponent p = this.getParent().asComponent();
        return p.getLinks(p.getSlot(this.getToSlot()));
    }

    public void doLinkFromMaster() {
        if (this.getMasterOrd().isNull() || this.isLinked()) {
            return;
        }
        this.checkThread();
        linkThread.addLink(this);
    }

    public void doRemoveExt() {
        this.getParent().asComponent().remove(this.getPropertyInParent());
    }

    public void checkThread() {
        if (linkThread == null || !BSelfLinkExt.linkThread.running) {
            linkThread = new LinkThread();
            BSelfLinkExt.linkThread.running = true;
            linkThread.start();
        }
    }

    static class LinkThread
    extends Thread {
        boolean running = false;
        Queue linkQueue = new Queue();

        LinkThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Util.log.message("STARTING SELF LINK THREAD");
            block7: while (true) {
                try {
                    Object obj;
                    while ((obj = this.linkQueue.dequeue()) != null) {
                        BSelfLinkExt self = (BSelfLinkExt)((Object)obj);
                        try {
                            String sOrd = self.getMasterOrd().relativizeToSession().encodeToString();
                            int lastSlash = sOrd.lastIndexOf(47);
                            BOrd linkFromOrd = BOrd.make((String)sOrd.substring(0, lastSlash));
                            String linkFromSlot = sOrd.substring(lastSlash + 1);
                            BObject resolvedObj = linkFromOrd.get((BObject)Sys.getStation());
                            if (resolvedObj != null && resolvedObj.isComponent()) {
                                BComponent s = self.getParent().asComponent();
                                BComponent m = resolvedObj.asComponent();
                                BLink link = s.makeLink(m, (Slot)m.getProperty(linkFromSlot), s.getSlot(self.getToSlot()), null);
                                s.add(null, (BValue)link);
                                link.activate();
                                if (!self.getRemoveOnLink()) continue block7;
                                self.removeExt();
                                continue block7;
                            }
                            Util.log.trace("No master found for " + self.getMasterOrd() + " [" + self.getSlotPath() + "]");
                            continue block7;
                        }
                        catch (Exception e) {
                            Util.log.error("Error creating link to master [" + self.getSlotPath() + "]", (Throwable)e);
                        }
                    }
                    LinkThread linkThread = BSelfLinkExt.linkThread;
                    synchronized (linkThread) {
                        while (BSelfLinkExt.linkThread.isEmpty()) {
                            this.wait(10000L);
                            if (!BSelfLinkExt.linkThread.isEmpty()) continue;
                            Util.log.message("STOPPING SELF LINK THREAD");
                            this.running = false;
                            return;
                        }
                    }
                }
                catch (Exception e) {
                    Util.log.error("Unhandled error in link queue", (Throwable)e);
                    this.running = false;
                    return;
                }
            }
        }

        boolean isEmpty() {
            return this.linkQueue.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addLink(BSelfLinkExt link) {
            this.linkQueue.enqueue((Object)link);
            LinkThread linkThread = BSelfLinkExt.linkThread;
            synchronized (linkThread) {
                BSelfLinkExt.linkThread.notify();
            }
        }
    }
}

