/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.global;

import com.lynxspring.control.global.BGlobalMasterLinkExt;
import com.lynxspring.control.util.Util;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Queue;

public class BGlobalSlaveLinkExt
extends BComponent {
    public static final Property masterName = BGlobalSlaveLinkExt.newProperty((int)0, (String)"", null);
    public static final Property toSlot = BGlobalSlaveLinkExt.newProperty((int)0, (String)"fallback", null);
    public static final Property removeOnLink = BGlobalSlaveLinkExt.newProperty((int)0, (boolean)false, null);
    public static final Property linkOnStart = BGlobalSlaveLinkExt.newProperty((int)0, (boolean)false, null);
    public static final Action linkFromMaster = BGlobalSlaveLinkExt.newAction((int)0, null);
    public static final Action removeExt = BGlobalSlaveLinkExt.newAction((int)20, null);
    public static final Type TYPE = Sys.loadType(BGlobalSlaveLinkExt.class);
    static LinkThread linkThread;

    public String getMasterName() {
        return this.getString(masterName);
    }

    public void setMasterName(String v) {
        this.setString(masterName, v, null);
    }

    public String getToSlot() {
        return this.getString(toSlot);
    }

    public void setToSlot(String v) {
        this.setString(toSlot, v, null);
    }

    public boolean getRemoveOnLink() {
        return this.getBoolean(removeOnLink);
    }

    public void setRemoveOnLink(boolean v) {
        this.setBoolean(removeOnLink, v, null);
    }

    public boolean getLinkOnStart() {
        return this.getBoolean(linkOnStart);
    }

    public void setLinkOnStart(boolean v) {
        this.setBoolean(linkOnStart, v, null);
    }

    public void linkFromMaster() {
        this.invoke(linkFromMaster, null, null);
    }

    public void removeExt() {
        this.invoke(removeExt, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        if (this.isRunning() && Sys.atSteadyState()) {
            this.atSteadyState();
        }
    }

    public void atSteadyState() {
        if (this.getLinkOnStart()) {
            this.linkFromMaster();
        }
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property == masterName) {
            this.removeLink();
            this.linkFromMaster();
        }
    }

    public void removeLink() {
        BLink[] links = this.getTheLinks();
        for (int i = 0; i < links.length; ++i) {
            links[i].getParent().asComponent().remove((BComplex)links[i]);
        }
    }

    public boolean isLinked() {
        return this.getTheLinks().length > 0;
    }

    private BLink[] getTheLinks() {
        BComponent p = this.getParent().asComponent();
        return p.getLinks(p.getSlot(this.getToSlot()));
    }

    public void doLinkFromMaster() {
        if (this.getMasterName().trim().length() == 0 || this.isLinked()) {
            return;
        }
        this.checkThread();
        linkThread.addLink(this);
    }

    public void doRemoveExt() {
        this.getParent().asComponent().remove(this.getPropertyInParent());
    }

    public void checkThread() {
        if (linkThread == null || !BGlobalSlaveLinkExt.linkThread.running) {
            linkThread = new LinkThread();
            BGlobalSlaveLinkExt.linkThread.running = true;
            linkThread.start();
        }
    }

    static class LinkThread
    extends Thread {
        boolean running = false;
        Queue linkQueue = new Queue();

        LinkThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Util.log.message("STARTING SLAVE LINK THREAD");
            block7: while (true) {
                try {
                    Object obj;
                    while ((obj = this.linkQueue.dequeue()) != null) {
                        BGlobalSlaveLinkExt slave = (BGlobalSlaveLinkExt)((Object)obj);
                        String qry = "slot:/|bql:select from lynxKitControl:GlobalMasterLinkExt where masterName = '" + slave.getMasterName() + "'";
                        try {
                            TableCursor c = ((BITable)BOrd.make((String)qry).get((BObject)slave)).cursor();
                            if (c.next()) {
                                Util.log.trace("Linking master " + slave.getMasterName() + " to " + slave.getSlotPath());
                                BGlobalMasterLinkExt master = (BGlobalMasterLinkExt)((Object)c.get());
                                BComponent s = slave.getParent().asComponent();
                                BComponent m = master.getParent().asComponent();
                                BLink link = s.makeLink(m, (Slot)m.getProperty(master.getFromSlot()), s.getSlot(slave.getToSlot()), null);
                                s.add(null, (BValue)link);
                                link.activate();
                                if (!slave.getRemoveOnLink()) continue block7;
                                slave.removeExt();
                                continue block7;
                            }
                            Util.log.trace("No master found for " + slave.getMasterName() + " [" + slave.getSlotPath() + "]");
                            continue block7;
                        }
                        catch (Exception e) {
                            Util.log.error("Error creating link to master [" + slave.getSlotPath() + "]", (Throwable)e);
                        }
                    }
                    LinkThread linkThread = BGlobalSlaveLinkExt.linkThread;
                    synchronized (linkThread) {
                        while (BGlobalSlaveLinkExt.linkThread.isEmpty()) {
                            this.wait(10000L);
                            if (!BGlobalSlaveLinkExt.linkThread.isEmpty()) continue;
                            Util.log.message("STOPPING SLAVE LINK THREAD");
                            this.running = false;
                            return;
                        }
                    }
                }
                catch (Exception e) {
                    Util.log.error("Unhandled error in link queue", (Throwable)e);
                    this.running = false;
                    return;
                }
            }
        }

        boolean isEmpty() {
            return this.linkQueue.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addLink(BGlobalSlaveLinkExt link) {
            this.linkQueue.enqueue((Object)link);
            LinkThread linkThread = BGlobalSlaveLinkExt.linkThread;
            synchronized (linkThread) {
                BGlobalSlaveLinkExt.linkThread.notify();
            }
        }
    }
}

