/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.global;

import com.lynxspring.control.global.BGlobalMasterExtension;
import com.lynxspring.control.util.Util;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.control.BPointExtension;
import javax.baja.naming.BOrd;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BGlobalSlaveExtension
extends BPointExtension {
    public static final Property masterName = BGlobalSlaveExtension.newProperty((int)0, (String)"", null);
    public static final Action setSlave = BGlobalSlaveExtension.newAction((int)4, (BValue)new BStatusBoolean(false, BStatus.nullStatus), null);
    public static final Action registerMaster = BGlobalSlaveExtension.newAction((int)0, null);
    public static final Action unregisterMaster = BGlobalSlaveExtension.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BGlobalSlaveExtension.class);
    private boolean licensed = false;
    private BStatusValue newValue = null;
    private BGlobalMasterExtension master;

    public String getMasterName() {
        return this.getString(masterName);
    }

    public void setMasterName(String v) {
        this.setString(masterName, v, null);
    }

    public void setSlave(BStatusValue arg) {
        this.invoke(setSlave, (BValue)arg, null);
    }

    public void registerMaster() {
        this.invoke(registerMaster, null, null);
    }

    public void unregisterMaster() {
        this.invoke(unregisterMaster, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (!this.isRunning() || !(this.licensed = Util.checkLicense())) {
            return;
        }
        if (this.master == null) {
            this.registerMaster();
        }
    }

    public void stopped() {
        this.unregisterMaster();
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning() || !this.licensed) {
            return;
        }
        if (p == masterName) {
            this.registerMaster();
        }
    }

    public void onExecute(BStatusValue out, Context cx) {
        if (!this.licensed || !this.validMasterName()) {
            return;
        }
        if (this.newValue != null) {
            if (this.newValue.getType().is(out.getType())) {
                if (!out.getValueValue().equals((Object)this.newValue.getValueValue())) {
                    out.setValueValue(this.newValue.getValueValue());
                }
                if (!out.getStatus().equals((Object)this.newValue.getStatus())) {
                    out.setStatus(this.newValue.getStatus());
                }
            } else {
                Util.log.message(Util.lex.getText("global.invalidType", (Object[])new String[]{this.newValue.getType().toString(), out.getType().toString(), this.getSlotPath().toString()}));
            }
        }
    }

    private boolean validMasterName() {
        return this.getMasterName().trim().length() > 0;
    }

    public void doRegisterMaster() {
        if (this.master != null) {
            this.doUnregisterMaster();
        }
        if (!this.validMasterName()) {
            return;
        }
        String qry = "slot:/|bql:select from lynxKitControl:GlobalMasterExtension where masterName = '" + this.getMasterName() + "' and outputType = '" + this.getParentPoint().getOutStatusValue().getType().getTypeSpec() + "'";
        TableCursor c = ((BITable)BOrd.make((String)qry).get((BObject)this)).cursor();
        if (c.next() && ((BGlobalMasterExtension)((Object)c.get())).activated) {
            this.registerMaster((BGlobalMasterExtension)((Object)c.get()));
        }
    }

    void registerMaster(BGlobalMasterExtension master) {
        this.master = master;
        master.registerSlave(this);
    }

    public void doUnregisterMaster() {
        if (this.master != null) {
            this.master.unregisterSlave(this);
        }
        this.master = null;
    }

    public void doSetSlave(BStatusValue value) {
        BStatusValue curValue = this.getParentPoint().getOutStatusValue();
        this.newValue = value;
        if (value.getStatus().equals((Object)curValue.getStatus()) && value.getValueValue().equals((Object)curValue.getValueValue())) {
            return;
        }
        this.executePoint();
    }

    protected boolean isSiblingLegal(BComponent sibling) {
        if (!this.isRunning()) {
            return true;
        }
        return super.isSiblingLegal(sibling);
    }

    public BIcon getIcon() {
        BIcon icon = Util.getIcon((BComplex)this);
        if (icon.equivalent((Object)BIcon.DEFAULT)) {
            return super.getIcon();
        }
        return icon;
    }
}

