/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.global;

import com.lynxspring.control.BLicensedComponent;
import com.lynxspring.control.global.BGlobalMasterExtension;
import com.lynxspring.control.global.BGlobalMasterLinkExt;
import com.lynxspring.control.global.BGlobalSlaveExtension;
import com.lynxspring.control.global.BGlobalSlaveLinkExt;
import com.lynxspring.control.global.BReplaceGlobalParams;
import com.lynxspring.control.global.BSelfLinkExt;
import com.tridium.util.ArrayUtil;
import java.io.File;
import java.io.FileFilter;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIService;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BGlobalService
extends BLicensedComponent
implements BIService {
    public static final Action linkGlobalSlaveLinks = BGlobalService.newAction((int)16, null);
    public static final Action linkSelfLinks = BGlobalService.newAction((int)16, null);
    public static final Action replaceGlobalsWithGlobalLinks = BGlobalService.newAction((int)0, (BValue)new BReplaceGlobalParams(), null);
    public static final Type TYPE = Sys.loadType(BGlobalService.class);
    static final BogFilter bogFilter = new BogFilter();

    public void linkGlobalSlaveLinks() {
        this.invoke(linkGlobalSlaveLinks, null, null);
    }

    public void linkSelfLinks() {
        this.invoke(linkSelfLinks, null, null);
    }

    public void replaceGlobalsWithGlobalLinks(BReplaceGlobalParams arg) {
        this.invoke(replaceGlobalsWithGlobalLinks, (BValue)arg, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public void serviceStarted() throws Exception {
    }

    public void serviceStopped() throws Exception {
    }

    public void doLinkGlobalSlaveLinks() {
        String qry = "slot:/|bql:select from lynxKitControl:GlobalSlaveLinkExt";
        TableCursor c = ((BITable)BOrd.make((String)qry).get((BObject)this)).cursor();
        while (c.next()) {
            ((BGlobalSlaveLinkExt)((Object)c.get())).linkFromMaster();
        }
    }

    public void doLinkSelfLinks() {
        String qry = "slot:/|bql:select from lynxKitControl:SelfLinkExt";
        TableCursor c = ((BITable)BOrd.make((String)qry).get((BObject)this)).cursor();
        while (c.next()) {
            ((BSelfLinkExt)((Object)c.get())).linkFromMaster();
        }
    }

    public void doReplaceGlobalsWithGlobalLinks(BReplaceGlobalParams params) {
        int i;
        Object[] exts = new Object[]{};
        String qry = "slot:/|bql:select from lynxKitControl:GlobalMasterExtension";
        TableCursor c = ((BITable)BOrd.make((String)qry).get((BObject)this)).cursor();
        while (c.next()) {
            exts = ArrayUtil.addOne((Object[])exts, (Object)c.get());
        }
        for (i = 0; i < exts.length; ++i) {
            this.replaceMaster((BGlobalMasterExtension)((Object)exts[i]), params.getMasterFromSlot());
        }
        exts = new Object[]{};
        qry = "slot:/|bql:select from lynxKitControl:GlobalSlaveExtension";
        c = ((BITable)BOrd.make((String)qry).get((BObject)this)).cursor();
        while (c.next()) {
            exts = ArrayUtil.addOne((Object[])exts, (Object)c.get());
        }
        for (i = 0; i < exts.length; ++i) {
            this.replaceSlave((BGlobalSlaveExtension)((Object)exts[i]), params.getSlaveToSlot());
        }
        File[] f = Sys.getStationHome().listFiles(bogFilter);
        for (int i2 = 0; i2 < f.length; ++i2) {
            this.processBogFile(f[i2], params);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processBogFile(File f, BReplaceGlobalParams params) {
        if (f.isDirectory()) {
            File[] kids = f.listFiles(bogFilter);
            for (int i = 0; i < kids.length; ++i) {
                this.processBogFile(kids[i], params);
            }
            return;
        } else {
            try (ValueDocDecoder vdd = null;){
                vdd = new ValueDocDecoder(f);
                BValue v = vdd.decodeDocument();
                if (!v.isComponent()) return;
                new ValueDocEncoder(f).encodeDocument((BValue)this.process(v.asComponent(), params));
                return;
            }
        }
    }

    private void replaceMaster(BGlobalMasterExtension m, String slot) {
        BGlobalMasterLinkExt link = new BGlobalMasterLinkExt();
        link.setMasterName(m.getMasterName());
        link.setFromSlot(slot);
        BComponent parent = m.getParent().asComponent();
        parent.add(null, (BValue)link);
        parent.remove(m.getPropertyInParent());
    }

    private void replaceSlave(BGlobalSlaveExtension s, String slot) {
        BGlobalSlaveLinkExt link = new BGlobalSlaveLinkExt();
        link.setMasterName(s.getMasterName());
        link.setToSlot(slot);
        BComponent parent = s.getParent().asComponent();
        parent.add(null, (BValue)link);
        parent.remove(s.getPropertyInParent());
    }

    private BComponent process(BComponent c, BReplaceGlobalParams params) {
        if (c.getType().is(BGlobalMasterExtension.TYPE)) {
            this.replaceMaster((BGlobalMasterExtension)c, params.getMasterFromSlot());
        } else if (c.getType().is(BGlobalSlaveExtension.TYPE)) {
            this.replaceSlave((BGlobalSlaveExtension)c, params.getSlaveToSlot());
        } else {
            BComponent[] kids = c.getChildComponents();
            for (int i = 0; i < kids.length; ++i) {
                this.process(kids[i], params);
            }
        }
        return c;
    }

    static class BogFilter
    implements FileFilter {
        BogFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || !f.getName().startsWith("config") && f.getName().endsWith(".bog");
        }
    }
}

