/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.global;

import com.lynxspring.control.global.BGlobalMathMasterExtension;
import com.lynxspring.control.util.Util;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BPointExtension;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BGlobalMathSlaveExtension
extends BPointExtension {
    public static final Property masterName = BGlobalMathSlaveExtension.newProperty((int)0, (String)"", null);
    public static final Property changeTolerance = BGlobalMathSlaveExtension.newProperty((int)0, (double)0.0, (BFacets)BFacets.make((String)"min", (BIDataValue)BFloat.make((float)0.0f)));
    public static final Type TYPE = Sys.loadType(BGlobalMathSlaveExtension.class);
    private BDouble lastValue = null;
    private boolean licensed = false;

    public String getMasterName() {
        return this.getString(masterName);
    }

    public void setMasterName(String v) {
        this.setString(masterName, v, null);
    }

    public double getChangeTolerance() {
        return this.getDouble(changeTolerance);
    }

    public void setChangeTolerance(double v) {
        this.setDouble(changeTolerance, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void onExecute(BStatusValue out, Context cx) {
        if (!(out.getValueValue() instanceof BDouble)) {
            return;
        }
        boolean valueChange = false;
        if (this.lastValue != null) {
            double dIn = this.lastValue.getDouble();
            double dOut = ((BDouble)out.getValueValue()).getDouble();
            if (Double.isNaN(dIn) && Double.isNaN(dOut)) {
                valueChange = false;
            } else if (Double.isNaN(dIn) || Double.isNaN(dOut)) {
                valueChange = true;
            }
            valueChange = Math.abs(dIn - dOut) > this.getChangeTolerance();
        } else {
            valueChange = true;
        }
        if (!valueChange) {
            return;
        }
        this.lastValue = (BDouble)out.getValueValue();
        this.updateMaster();
    }

    public void started() {
        if (!this.isRunning()) {
            return;
        }
        this.licensed = Util.checkLicense();
        this.updateMaster();
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (p == masterName) {
            this.updateMaster();
        }
    }

    private void updateMaster() {
        if (!this.licensed) {
            return;
        }
        if (this.getMasterName().trim().length() == 0) {
            return;
        }
        try {
            String qry = "slot:/|bql:select * from lynxKitControl:GlobalMathMasterExtension where masterName = '" + this.getMasterName() + "'";
            TableCursor c = ((BITable)BOrd.make((String)qry).get((BObject)this)).cursor();
            while (c.next()) {
                ((BGlobalMathMasterExtension)((Object)c.get())).execute();
            }
        }
        catch (Exception e) {
            Util.log.message(Util.lex.getText("global.masterNotFound", (Object[])new String[]{this.getMasterName()}));
        }
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot == changeTolerance && this.getParent() instanceof BNumericPoint) {
            return BFacets.make((BFacets)this.getPointFacets(), (BFacets)changeTolerance.getFacets());
        }
        return super.getSlotFacets(slot);
    }

    public boolean requiresPointSubscription() {
        return true;
    }

    public BIcon getIcon() {
        BIcon icon = Util.getIcon((BComplex)this);
        if (icon.equivalent((Object)BIcon.DEFAULT)) {
            return super.getIcon();
        }
        return icon;
    }
}

