/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.global;

import com.lynxspring.control.global.BGlobalSlaveLinkExt;
import com.lynxspring.control.util.Util;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Queue;

public class BGlobalMasterLinkExt
extends BComponent {
    public static final Property masterName = BGlobalMasterLinkExt.newProperty((int)0, (String)"", null);
    public static final Property fromSlot = BGlobalMasterLinkExt.newProperty((int)0, (String)"out", null);
    public static final Property linkOnStart = BGlobalMasterLinkExt.newProperty((int)0, (boolean)false, null);
    public static final Action linkToSlaves = BGlobalMasterLinkExt.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BGlobalMasterLinkExt.class);
    static LinkThread linkThread;

    public String getMasterName() {
        return this.getString(masterName);
    }

    public void setMasterName(String v) {
        this.setString(masterName, v, null);
    }

    public String getFromSlot() {
        return this.getString(fromSlot);
    }

    public void setFromSlot(String v) {
        this.setString(fromSlot, v, null);
    }

    public boolean getLinkOnStart() {
        return this.getBoolean(linkOnStart);
    }

    public void setLinkOnStart(boolean v) {
        this.setBoolean(linkOnStart, v, null);
    }

    public void linkToSlaves() {
        this.invoke(linkToSlaves, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (this.getMasterName().length() == 0 && this.getParent() != null) {
            this.setMasterName(this.getParent().getDisplayName(null));
        }
    }

    public void atSteadyState() {
        if (this.getLinkOnStart() && this.isRunning() && Sys.atSteadyState()) {
            this.linkToSlaves();
        }
    }

    public void doLinkToSlaves() {
        if (this.getMasterName().trim().length() == 0) {
            return;
        }
        this.checkThread();
        linkThread.addLink(this);
    }

    public void checkThread() {
        if (linkThread == null || !BGlobalMasterLinkExt.linkThread.running) {
            linkThread = new LinkThread();
            BGlobalMasterLinkExt.linkThread.running = true;
            linkThread.start();
        }
    }

    static class LinkThread
    extends Thread {
        boolean running = false;
        Queue linkQueue = new Queue();

        LinkThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Util.log.message("STARTING MASTER LINK THREAD");
            block7: while (true) {
                try {
                    Object obj;
                    while ((obj = this.linkQueue.dequeue()) != null) {
                        BGlobalMasterLinkExt master = (BGlobalMasterLinkExt)((Object)obj);
                        String qry = "slot:/|bql:select from lynxKitControl:GlobalSlaveLinkExt where masterName = '" + master.getMasterName() + "'";
                        try {
                            TableCursor c = ((BITable)BOrd.make((String)qry).get((BObject)master)).cursor();
                            while (true) {
                                if (!c.next()) continue block7;
                                ((BGlobalSlaveLinkExt)((Object)c.get())).linkFromMaster();
                            }
                        }
                        catch (Exception e) {
                            Util.log.error("Error creating links from master [" + master.getSlotPath() + "]", (Throwable)e);
                        }
                    }
                    LinkThread linkThread = BGlobalMasterLinkExt.linkThread;
                    synchronized (linkThread) {
                        while (BGlobalMasterLinkExt.linkThread.isEmpty()) {
                            this.wait(10000L);
                            if (!BGlobalMasterLinkExt.linkThread.isEmpty()) continue;
                            Util.log.message("STOPPING MASTER LINK THREAD");
                            this.running = false;
                            return;
                        }
                    }
                }
                catch (Exception e) {
                    Util.log.error("Unhandled error in link queue", (Throwable)e);
                    this.running = false;
                    return;
                }
            }
        }

        boolean isEmpty() {
            return this.linkQueue.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addLink(BGlobalMasterLinkExt link) {
            this.linkQueue.enqueue((Object)link);
            LinkThread linkThread = BGlobalMasterLinkExt.linkThread;
            synchronized (linkThread) {
                BGlobalMasterLinkExt.linkThread.notify();
            }
        }
    }
}

