/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.global;

import com.lynxspring.control.global.BGlobalSlaveExtension;
import com.lynxspring.control.util.Util;
import com.tridium.util.ArrayUtil;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.control.BControlPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BPointExtension;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public class BGlobalMasterExtension
extends BPointExtension {
    public static final Property masterName = BGlobalMasterExtension.newProperty((int)0, (String)"", null);
    public static final Property in = BGlobalMasterExtension.newProperty((int)0, (BValue)new BStatusBoolean(false, BStatus.nullStatus), null);
    public static final Property outputType = BGlobalMasterExtension.newProperty((int)1, (BValue)BStatusBoolean.TYPE.getTypeSpec(), null);
    public static final Property slaveCount = BGlobalMasterExtension.newProperty((int)1, (int)0, null);
    public static final Property changeTolerance = BGlobalMasterExtension.newProperty((int)0, (double)0.0, (BFacets)BFacets.make((String)"min", (BIDataValue)BFloat.make((float)0.0f)));
    public static final Action registerSlaves = BGlobalMasterExtension.newAction((int)0, null);
    public static final Action unregisterSlaves = BGlobalMasterExtension.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BGlobalMasterExtension.class);
    boolean activated = false;
    private boolean licensed = false;
    private BStatusValue lastValue = null;
    BGlobalSlaveExtension[] slaves;

    public String getMasterName() {
        return this.getString(masterName);
    }

    public void setMasterName(String v) {
        this.setString(masterName, v, null);
    }

    public BStatusValue getIn() {
        return (BStatusValue)this.get(in);
    }

    public void setIn(BStatusValue v) {
        this.set(in, (BValue)v, null);
    }

    public BTypeSpec getOutputType() {
        return (BTypeSpec)this.get(outputType);
    }

    public void setOutputType(BTypeSpec v) {
        this.set(outputType, (BValue)v, null);
    }

    public int getSlaveCount() {
        return this.getInt(slaveCount);
    }

    public void setSlaveCount(int v) {
        this.setInt(slaveCount, v, null);
    }

    public double getChangeTolerance() {
        return this.getDouble(changeTolerance);
    }

    public void setChangeTolerance(double v) {
        this.setDouble(changeTolerance, v, null);
    }

    public void registerSlaves() {
        this.invoke(registerSlaves, null, null);
    }

    public void unregisterSlaves() {
        this.invoke(unregisterSlaves, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.slaves = new BGlobalSlaveExtension[0];
        if (this.getMasterName().length() == 0 && this.getParent() != null) {
            this.setMasterName(this.getParent().getDisplayName(null));
        }
        if (this.isRunning() && (this.licensed = Util.checkLicense())) {
            this.activated = true;
            this.setFlags((Slot)in, this.getParent() instanceof BControlPoint ? 4 : 0);
            this.registerSlaves();
            if (!(this.getParent() instanceof BControlPoint)) {
                this.changed(in, null);
            }
        }
    }

    public void stopped() {
        this.doUnregisterSlaves();
    }

    public void onExecute(BStatusValue out, Context cx) {
        this.setIn((BStatusValue)out.newCopy(true));
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning() || !this.activated) {
            return;
        }
        if (p == masterName) {
            this.unregisterSlaves();
            this.lastValue = null;
            this.registerSlaves();
        } else if (p == in) {
            this.checkOutputType();
            if (!this.licensed || this.getMasterName().trim().length() == 0) {
                return;
            }
            boolean valueChange = false;
            if (this.lastValue != null && this.getIn().getValueValue() instanceof BDouble) {
                double dIn = ((BDouble)this.getIn().getValueValue()).getDouble();
                double dLast = ((BDouble)this.lastValue.getValueValue()).getDouble();
                valueChange = Double.isNaN(dIn) && Double.isNaN(dLast) ? false : (Double.isNaN(dIn) || Double.isNaN(dLast) ? true : Math.abs(dIn - dLast) > this.getChangeTolerance());
            } else if (this.lastValue == null || !this.getIn().getValueValue().equals((Object)this.lastValue.getValueValue())) {
                valueChange = true;
            }
            if (!valueChange && this.getIn().getStatus().equals((Object)this.lastValue.getStatus())) {
                return;
            }
            this.lastValue = (BStatusValue)this.getIn().newCopy(true);
            for (int i = 0; i < this.slaves.length; ++i) {
                this.slaves[i].setSlave(this.lastValue);
            }
        }
    }

    private void checkOutputType() {
        if (!this.getOutputType().equals((Object)this.getIn().getType().getTypeSpec())) {
            this.setOutputType(this.getIn().getType().getTypeSpec());
        }
    }

    public void doRegisterSlaves() {
        this.checkOutputType();
        String qry = "slot:/|bql:select from lynxKitControl:GlobalSlaveExtension where masterName = '" + this.getMasterName() + "' and parent.out.type = '" + this.getOutputType() + "'";
        TableCursor c = ((BITable)BOrd.make((String)qry).get((BObject)this)).cursor();
        while (c.next()) {
            ((BGlobalSlaveExtension)((Object)c.get())).registerMaster(this);
        }
    }

    public void doUnregisterSlaves() {
        while (this.slaves.length > 0) {
            this.slaves[0].doUnregisterMaster();
        }
    }

    void registerSlave(BGlobalSlaveExtension slave) {
        if (this.lastValue != null) {
            slave.setSlave(this.lastValue);
        }
        for (int i = 0; i < this.slaves.length; ++i) {
            if (slave != this.slaves[i]) continue;
            return;
        }
        this.slaves = (BGlobalSlaveExtension[])ArrayUtil.addOne((Object[])this.slaves, (Object)((Object)slave));
        this.setSlaveCount(this.slaves.length);
    }

    void unregisterSlave(BGlobalSlaveExtension slave) {
        this.slaves = (BGlobalSlaveExtension[])ArrayUtil.removeOne((Object[])this.slaves, (Object)((Object)slave));
        this.setSlaveCount(this.slaves.length);
    }

    public void childParented(Property p, BValue v, Context cx) {
        BLink link;
        BValue source;
        if (!this.isRunning() || this.getParent() instanceof BControlPoint || p == in) {
            return;
        }
        if (v instanceof BLink && (source = (link = (BLink)v).isDirect() ? link.getSourceComponent().get(link.getSourceSlotName()) : ((BComponent)link.getSourceOrd().resolve((BObject)this).get()).get(link.getSourceSlotName())) instanceof BStatusValue && !source.getType().is(this.getIn().getType())) {
            this.setIn((BStatusValue)source.newCopy());
        }
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot == changeTolerance && this.getParent() instanceof BNumericPoint) {
            return BFacets.make((BFacets)this.getPointFacets(), (BFacets)changeTolerance.getFacets());
        }
        return super.getSlotFacets(slot);
    }

    public boolean isParentLegal(BComponent parent) {
        return true;
    }

    public boolean requiresPointSubscription() {
        return true;
    }

    public BIcon getIcon() {
        BIcon icon = Util.getIcon((BComplex)this);
        if (icon.equivalent((Object)BIcon.DEFAULT)) {
            return super.getIcon();
        }
        return icon;
    }
}

