/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.global;

import com.lynxspring.control.global.BGlobalCommandAction;
import javax.baja.collection.BIRandomAccessTable;
import javax.baja.collection.BITable;
import javax.baja.collection.Tables;
import javax.baja.job.BSimpleJob;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BGlobalCommandJob
extends BSimpleJob {
    public static final Type TYPE = Sys.loadType(BGlobalCommandJob.class);
    BGlobalCommandAction global;
    private BValue bvalue;
    boolean failed = false;
    boolean allFailed = true;

    public Type getType() {
        return TYPE;
    }

    public BGlobalCommandJob() {
    }

    BGlobalCommandJob(BGlobalCommandAction global, BValue bvalue) {
        this.global = global;
        this.bvalue = bvalue;
    }

    public void run(Context context) throws Exception {
        BITable list = (BITable)this.global.getCommand().getQuery().resolve().get();
        BIRandomAccessTable ratlist = Tables.slurp((BITable)list);
        if (ratlist.size() == 0) {
            this.failed(new Exception("No components to process"));
            return;
        }
        this.log().start("Starting process of action " + this.global.getName() + " for global command at " + this.global.getCommand().getSlotPath());
        for (int i = 0; i < ratlist.size(); ++i) {
            BComponent comp = ((BObject)ratlist.get(i).rowObject()).asComponent();
            Action action = null;
            String actionName = this.global.getName();
            switch (this.global.getActionNameCheck().getOrdinal()) {
                case 0: {
                    action = comp.getAction(actionName);
                    break;
                }
                case 1: {
                    Action[] actions = comp.getActionsArray();
                    String lc = actionName.toLowerCase();
                    String lcf = TextUtil.fromFriendly((String)actionName).toLowerCase();
                    for (int a = 0; action == null && a < actions.length; ++a) {
                        if (!lc.equals(actions[a].getName().toLowerCase()) && !SlotPath.unescape((String)lc).equals(SlotPath.unescape((String)actions[a].getName().toLowerCase())) && !SlotPath.escape((String)lc).equals(SlotPath.escape((String)actions[a].getName().toLowerCase())) && !lcf.equals(actions[a].getName().toLowerCase()) && !SlotPath.unescape((String)lcf).equals(SlotPath.unescape((String)actions[a].getName().toLowerCase())) && !SlotPath.escape((String)lcf).equals(SlotPath.escape((String)actions[a].getName().toLowerCase()))) continue;
                        action = actions[a];
                    }
                    break;
                }
                default: {
                    action = comp.getAction(actionName);
                    if (action == null) {
                        action = comp.getAction(SlotPath.escape((String)actionName));
                    }
                    if (action == null) {
                        action = comp.getAction(SlotPath.unescape((String)actionName));
                    }
                    if (action == null) {
                        action = comp.getAction(TextUtil.fromFriendly((String)actionName));
                    }
                    if (action == null) {
                        action = comp.getAction(TextUtil.fromFriendly((String)SlotPath.escape((String)actionName)));
                    }
                    if (action == null) {
                        action = comp.getAction(TextUtil.fromFriendly((String)SlotPath.unescape((String)actionName)));
                    }
                    if (action == null) {
                        action = comp.getAction(SlotPath.escape((String)TextUtil.fromFriendly((String)actionName)));
                    }
                    if (action != null) break;
                    action = comp.getAction(SlotPath.unescape((String)TextUtil.fromFriendly((String)actionName)));
                }
            }
            if (action != null) {
                String msg = action.getName() + " on " + comp.getSlotPath();
                String val = this.bvalue == null ? "no value" : "value of " + this.bvalue;
                try {
                    comp.invoke(action, this.bvalue);
                    this.allFailed = false;
                    this.log().success("invoked " + msg + " with " + val);
                }
                catch (Exception e) {
                    this.failed(msg + " could not be invoked with " + val);
                }
            } else {
                this.failed(actionName + " not found in " + this.global.getActionNameCheck().getDisplayTag(null) + " mode on " + comp.getSlotPath());
            }
            this.progress((int)((float)((i + 1) / ratlist.size()) * 100.0f));
        }
        if (this.global.getActionValidMode().getOrdinal() == 1 && this.allFailed || this.global.getActionValidMode().getOrdinal() == 0 && this.failed) {
            throw new Exception("Job failed to complete successfully - see log");
        }
    }

    private void failed(String msg) {
        this.failed = true;
        this.log().failed(msg);
    }
}

