/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.energy;

import com.lynxspring.control.energy.BEnergyComponent;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

public class BMotor
extends BEnergyComponent {
    public static final Property horsepower = BMotor.newProperty((int)0, (int)10, (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"lynxKitControl:ResizableFloatFE"), (String)"units", (BIDataValue)BUnit.getUnit((String)"horsepower")));
    public static final Property efficiency = BMotor.newProperty((int)0, (int)90, (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"lynxKitControl:ResizableFloatFE"), (String)"units", (BIDataValue)BUnit.getUnit((String)"percent")));
    public static final Property percentageOfFullLoad = BMotor.newProperty((int)0, (int)75, (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"lynxKitControl:ResizableFloatFE"), (String)"units", (BIDataValue)BUnit.getUnit((String)"percent")));
    public static final Property averageCost = BMotor.newProperty((int)0, (double)0.1, (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"lynxKitControl:PerFloatFE"), (String)"units", (BIDataValue)BUnit.getUnit((String)"kilowatt hour")));
    public static final Type TYPE = Sys.loadType(BMotor.class);

    public double getHorsepower() {
        return this.getDouble(horsepower);
    }

    public void setHorsepower(double v) {
        this.setDouble(horsepower, v, null);
    }

    public double getEfficiency() {
        return this.getDouble(efficiency);
    }

    public void setEfficiency(double v) {
        this.setDouble(efficiency, v, null);
    }

    public double getPercentageOfFullLoad() {
        return this.getDouble(percentageOfFullLoad);
    }

    public void setPercentageOfFullLoad(double v) {
        this.setDouble(percentageOfFullLoad, v, null);
    }

    public double getAverageCost() {
        return this.getDouble(averageCost);
    }

    public void setAverageCost(double v) {
        this.setDouble(averageCost, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public double calculate(BRelTime time) {
        double minutes = (double)time.getMinutes() / 60.0;
        double usage = this.getHorsepower() * 0.746 * (this.getEfficiency() / 100.0) * (this.getPercentageOfFullLoad() / 100.0) * minutes;
        this.setEstimatedUsage(usage);
        double dbl = usage * this.getAverageCost();
        return (double)Math.round(dbl * 100.0) / 100.0;
    }
}

