/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.energy;

import com.lynxspring.control.datatypes.BCombustible;
import com.lynxspring.control.datatypes.BCombustibleCost;
import com.lynxspring.control.energy.BEnergyComponent;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

public class BGas
extends BEnergyComponent {
    public static final Property energyFactor = BGas.newProperty((int)0, (int)90, (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"lynxKitControl:ResizableFloatFE"), (String)"units", (BIDataValue)BUnit.getUnit((String)"percent")));
    public static final Property heatingInput = BGas.newProperty((int)0, (BValue)BCombustible.DEFAULT, null);
    public static final Property cost = BGas.newProperty((int)0, (BValue)BCombustibleCost.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BGas.class);

    public double getEnergyFactor() {
        return this.getDouble(energyFactor);
    }

    public void setEnergyFactor(double v) {
        this.setDouble(energyFactor, v, null);
    }

    public BCombustible getHeatingInput() {
        return (BCombustible)this.get(heatingInput);
    }

    public void setHeatingInput(BCombustible v) {
        this.set(heatingInput, (BValue)v, null);
    }

    public BCombustibleCost getCost() {
        return (BCombustibleCost)this.get(cost);
    }

    public void setCost(BCombustibleCost v) {
        this.set(cost, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public double calculate(BRelTime time) {
        double minutes = (double)time.getMinutes() / 60.0;
        double usage = this.getHeatingInput().getNumeric() * minutes;
        this.setEstimatedUsage(usage);
        double dbl = usage * this.getCost().getNumeric();
        return (double)Math.round(dbl * 100.0) / 100.0;
    }
}

