/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.energy;

import com.lynxspring.control.datatypes.BUnitRating;
import com.lynxspring.control.energy.BEnergyComponent;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

public class BCompressor
extends BEnergyComponent {
    public static final Property tonsOfCooling = BCompressor.newProperty((int)0, (int)30, null);
    public static final Property unitRating = BCompressor.newProperty((int)0, (BValue)BUnitRating.DEFAULT, null);
    public static final Property averageCost = BCompressor.newProperty((int)0, (double)0.1, (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"lynxKitControl:PerFloatFE"), (String)"units", (BIDataValue)BUnit.getUnit((String)"kilowatt hour")));
    public static final Type TYPE = Sys.loadType(BCompressor.class);

    public double getTonsOfCooling() {
        return this.getDouble(tonsOfCooling);
    }

    public void setTonsOfCooling(double v) {
        this.setDouble(tonsOfCooling, v, null);
    }

    public BUnitRating getUnitRating() {
        return (BUnitRating)this.get(unitRating);
    }

    public void setUnitRating(BUnitRating v) {
        this.set(unitRating, (BValue)v, null);
    }

    public double getAverageCost() {
        return this.getDouble(averageCost);
    }

    public void setAverageCost(double v) {
        this.setDouble(averageCost, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public double calculate(BRelTime time) {
        double minutes = (double)time.getMinutes() / 60.0;
        double usage = this.getTonsOfCooling() * 12000.0 * minutes / 1000.0 / this.getUnitRating().getNumeric();
        this.setEstimatedUsage(usage);
        double dbl = usage * this.getAverageCost();
        return (double)Math.round(dbl * 100.0) / 100.0;
    }
}

