/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.datatypes;

import com.lynxspring.control.datatypes.BAbstractUnitEnum;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BWattage
extends BAbstractUnitEnum {
    private static final String[] unitsText = new String[]{BWattage.makeTag("watt (W)"), BWattage.makeTag("kilowatt (kW)"), BWattage.makeTag("megaBtus per hour (MBH)")};
    public static final double[] units = new double[]{1.0, 1000.0, 293.07107017222};
    public static final BEnumRange unitRange = BEnumRange.make((String[])unitsText);
    public static final BWattage DEFAULT = (BWattage)BWattage.make(1.0, unitsText[1]);
    public static final Type TYPE = Sys.loadType(BWattage.class);
    private BDynamicEnum unitEnum = BDynamicEnum.make((int)0, (BEnumRange)unitRange);

    public static BAbstractUnitEnum make(double value, String unit) {
        return new BWattage(value, unit);
    }

    @Override
    public BAbstractUnitEnum remake(double value, String unit) {
        return BWattage.make(value, unit);
    }

    private BWattage(double value, String unit) {
        this.value = value;
        int u = 0;
        try {
            u = unitRange.get(BWattage.makeTag(unit)).getOrdinal();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.unitEnum = BDynamicEnum.make((int)u, (BEnumRange)unitRange);
    }

    @Override
    String getDataTypeName() {
        return "wattage";
    }

    @Override
    public double[] getUnits() {
        return units;
    }

    @Override
    public BDynamicEnum getUnitsEnum() {
        return this.unitEnum;
    }

    @Override
    public BAbstractUnitEnum decode(String value, String unit) {
        double d;
        if (value.equals("+inf")) {
            d = Double.POSITIVE_INFINITY;
        }
        if (value.equals("-inf")) {
            d = Double.NEGATIVE_INFINITY;
        }
        if (value.equals("nan")) {
            d = Double.NaN;
        }
        double r = Double.parseDouble(value);
        return BWattage.make(r, unit);
    }

    @Override
    public Type getType() {
        return TYPE;
    }
}

