/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.datatypes;

import com.lynxspring.control.datatypes.BAbstractUnitEnum;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BUnitRating
extends BAbstractUnitEnum {
    private static final String[] unitsText = new String[]{BUnitRating.makeTag("SEER"), BUnitRating.makeTag("EER"), BUnitRating.makeTag("COP")};
    public static final double[] units = new double[]{1.0, 1.112, 3.792};
    public static final BEnumRange unitRange = BEnumRange.make((String[])unitsText);
    public static final BUnitRating DEFAULT = (BUnitRating)BUnitRating.make(13.0, unitsText[0]);
    public static final Type TYPE = Sys.loadType(BUnitRating.class);
    private BDynamicEnum unitEnum = BDynamicEnum.make((int)0, (BEnumRange)unitRange);

    public static BAbstractUnitEnum make(double rating, String unit) {
        return new BUnitRating(rating, unit);
    }

    @Override
    public BAbstractUnitEnum remake(double value, String unit) {
        return BUnitRating.make(value, unit);
    }

    private BUnitRating(double rating, String unit) {
        this.value = rating;
        int u = 0;
        try {
            u = unitRange.get(BUnitRating.makeTag(unit)).getOrdinal();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.unitEnum = BDynamicEnum.make((int)u, (BEnumRange)unitRange);
    }

    @Override
    String getDataTypeName() {
        return "unit rating";
    }

    @Override
    public double[] getUnits() {
        return units;
    }

    @Override
    public BDynamicEnum getUnitsEnum() {
        return this.unitEnum;
    }

    @Override
    public BAbstractUnitEnum decode(String value, String unit) {
        double d;
        if (value.equals("+inf")) {
            d = Double.POSITIVE_INFINITY;
        }
        if (value.equals("-inf")) {
            d = Double.NEGATIVE_INFINITY;
        }
        if (value.equals("nan")) {
            d = Double.NaN;
        }
        double r = Double.parseDouble(value);
        return BUnitRating.make(r, unit);
    }

    @Override
    public Type getType() {
        return TYPE;
    }
}

