/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.datatypes;

import com.lynxspring.control.datatypes.BConversionPoint;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIComparable;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BDynamicConversionPointArray
extends BSimple
implements BIComparable {
    private ArrayList m_aPointList;
    private float[][] m_points = null;
    private static final char seperator = ';';
    public static final BDynamicConversionPointArray DEFAULT = BDynamicConversionPointArray.make();
    public static final Type TYPE = Sys.loadType(BDynamicConversionPointArray.class);

    private BDynamicConversionPointArray(BConversionPoint[] points) {
        if (this.m_aPointList == null) {
            this.m_aPointList = new ArrayList();
        }
        for (int i = 0; i < points.length; ++i) {
            this.addPoint(points[i]);
        }
    }

    private BDynamicConversionPointArray() {
        if (this.m_aPointList == null) {
            this.m_aPointList = new ArrayList();
        }
    }

    public static BDynamicConversionPointArray make() {
        return new BDynamicConversionPointArray();
    }

    public static BDynamicConversionPointArray make(String s) {
        String[] split = TextUtil.split((String)s, (char)';');
        BDynamicConversionPointArray conPtAry = new BDynamicConversionPointArray();
        for (int i = 0; i < split.length - 1; ++i) {
            String[] sValues = TextUtil.split((String)split[i], (char)' ');
            float setPoint = Float.parseFloat(sValues[0]);
            float value = Float.parseFloat(sValues[1]);
            conPtAry.addPoint(BConversionPoint.make(setPoint, value));
        }
        return conPtAry;
    }

    public BDynamicConversionPointArray make(BConversionPoint[] points) {
        return new BDynamicConversionPointArray(points);
    }

    public BObject decode(DataInput in) throws IOException {
        boolean HasRecords = true;
        BDynamicConversionPointArray conPtAry = BDynamicConversionPointArray.make();
        while (HasRecords) {
            try {
                float setPoint = in.readFloat();
                in.readByte();
                float value = in.readFloat();
                in.readByte();
                conPtAry.addPoint(BConversionPoint.make(setPoint, value));
            }
            catch (EOFException e) {
                HasRecords = false;
            }
        }
        return conPtAry;
    }

    public BObject decodeFromString(String s) throws IOException {
        try {
            return BDynamicConversionPointArray.make(s);
        }
        catch (RuntimeException e) {
            throw new IOException("Invalid " + this.getDataTypeName() + ": " + s);
        }
    }

    public void encode(DataOutput out) throws IOException {
        for (int i = 0; i < this.m_aPointList.size(); ++i) {
            out.writeChars(((BConversionPoint)((Object)this.m_aPointList.get(i))).encodeToString());
            out.writeByte(59);
        }
    }

    public String encodeToString() throws IOException {
        return BDynamicConversionPointArray.encode(this.m_aPointList);
    }

    public boolean equals(Object obj) {
        if (obj instanceof BDynamicConversionPointArray) {
            return (BDynamicConversionPointArray)((Object)obj) == this;
        }
        return false;
    }

    public static String encode(ArrayList points) {
        String out = "";
        try {
            for (int i = 0; i < points.size(); ++i) {
                out = out + ((BConversionPoint)((Object)points.get(i))).encodeToString();
                out = out + ';';
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return out;
    }

    public int compareTo(Object obj) {
        BDynamicConversionPointArray a = this;
        BDynamicConversionPointArray b = null;
        if (!(obj instanceof BDynamicConversionPointArray)) {
            return 1;
        }
        b = (BDynamicConversionPointArray)((Object)obj);
        if (a == b) {
            return 0;
        }
        return 1;
    }

    public BFacets getNumericFacets() {
        return BFacets.NULL;
    }

    public BConversionPoint getPoint(int Index) {
        if (Index >= this.m_aPointList.size() || Index < 0) {
            throw new ArrayIndexOutOfBoundsException(Index);
        }
        return (BConversionPoint)((Object)this.m_aPointList.get(Index));
    }

    public void setSetValue(int Index, BConversionPoint point) {
        this.m_aPointList.set(Index, point);
    }

    private void buildPoints() {
        int size = this.m_aPointList.size();
        this.m_points = new float[size][2];
        for (int i = 0; i < size; ++i) {
            this.m_points[i][0] = ((BConversionPoint)((Object)this.m_aPointList.get(i))).getSetPoint();
            this.m_points[i][1] = ((BConversionPoint)((Object)this.m_aPointList.get(i))).getValue();
        }
    }

    public float[][] getPoints() {
        return this.m_points;
    }

    public void addPoint(BConversionPoint point) {
        this.m_aPointList.add(point);
        this.buildPoints();
    }

    private String getDataTypeName() {
        return "Conversion Point";
    }

    public long getCount() {
        return this.m_aPointList.size();
    }

    public Type getType() {
        return TYPE;
    }
}

