/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.datatypes;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIComparable;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BConversionPoint
extends BSimple
implements BIComparable {
    private float m_setPoint;
    private float m_value;
    public static final char seperator = ' ';
    public static final BConversionPoint DEFAULT = BConversionPoint.make();
    public static final Type TYPE = Sys.loadType(BConversionPoint.class);

    private BConversionPoint(float setPoint, float value) {
        this.m_setPoint = setPoint;
        this.m_value = value;
    }

    private BConversionPoint() {
        this.m_setPoint = 0.0f;
        this.m_value = 0.0f;
    }

    public static BConversionPoint make() {
        return new BConversionPoint();
    }

    public BConversionPoint make(String s) {
        String[] split = TextUtil.split((String)s, (char)' ');
        float setPoint = Float.parseFloat(split[0]);
        float value = Float.parseFloat(split[1]);
        return BConversionPoint.make(setPoint, value);
    }

    public static BConversionPoint make(float setPoint, float value) {
        return new BConversionPoint(setPoint, value);
    }

    public BConversionPoint remake(float setPoint, float value) {
        return BConversionPoint.make(setPoint, value);
    }

    public BObject decode(DataInput in) throws IOException {
        float setPoint = in.readFloat();
        in.readByte();
        float value = in.readFloat();
        return this.remake(setPoint, value);
    }

    public BObject decodeFromString(String s) throws IOException {
        try {
            return this.make(s);
        }
        catch (RuntimeException e) {
            throw new IOException("Invalid " + this.getDataTypeName() + ": " + s);
        }
    }

    public void encode(DataOutput out) throws IOException {
        out.writeFloat(this.m_setPoint);
        out.writeByte(32);
        out.writeFloat(this.m_value);
    }

    public String encodeToString() throws IOException {
        return BConversionPoint.encode(this.m_setPoint, this.m_value);
    }

    public boolean equals(Object obj) {
        if (obj instanceof BConversionPoint) {
            return ((BConversionPoint)((Object)obj)).getNumeric() == this.getNumeric();
        }
        return false;
    }

    public static String encode(float setPoint, float value) {
        String sSetPoint = setPoint == Float.POSITIVE_INFINITY ? "+inf" : (setPoint == Float.NEGATIVE_INFINITY ? "-inf" : (Float.isNaN(setPoint) ? "+nan" : String.valueOf(setPoint)));
        String sValue = value == Float.POSITIVE_INFINITY ? "+inf" : (value == Float.NEGATIVE_INFINITY ? "-inf" : (Float.isNaN(value) ? "+nan" : String.valueOf(value)));
        return sSetPoint + ' ' + sValue;
    }

    public int compareTo(Object obj) {
        float a = this.getNumeric();
        float b = Float.NaN;
        if (obj instanceof BConversionPoint) {
            b = ((BConversionPoint)((Object)obj)).getNumeric();
        }
        if (a == b) {
            return 0;
        }
        if (Float.isNaN(a) && Float.isNaN(b)) {
            return 0;
        }
        if (a < b) {
            return -1;
        }
        return 1;
    }

    public float getNumeric() {
        float fShiftedSetPoint = this.m_setPoint;
        float out = fShiftedSetPoint + this.m_value;
        return out;
    }

    public BFacets getNumericFacets() {
        return BFacets.NULL;
    }

    public float getValue() {
        return this.m_value;
    }

    public float getSetPoint() {
        return this.m_setPoint;
    }

    public void setSetPoint(float value) {
        this.m_setPoint = value;
    }

    public void setValue(float value) {
        this.m_value = value;
    }

    private String getDataTypeName() {
        return "Conversion Point";
    }

    public Type getType() {
        return TYPE;
    }
}

