/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.datatypes;

import com.lynxspring.control.datatypes.BAbstractUnitEnum;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BCombustibleCost
extends BAbstractUnitEnum {
    private static final String[] unitsText = new String[]{BCombustibleCost.makeTag("per Mcf"), BCombustibleCost.makeTag("per therm")};
    public static final double[] units = new double[]{0.1, 1.0};
    public static final BEnumRange unitRange = BEnumRange.make((String[])unitsText);
    public static final BCombustibleCost DEFAULT = (BCombustibleCost)BCombustibleCost.make(9.0, unitsText[0]);
    public static final Type TYPE = Sys.loadType(BCombustibleCost.class);
    private BDynamicEnum unitEnum = BDynamicEnum.make((int)0, (BEnumRange)unitRange);

    public static BAbstractUnitEnum make(double value, String unit) {
        return new BCombustibleCost(value, unit);
    }

    @Override
    public BAbstractUnitEnum remake(double value, String unit) {
        return BCombustibleCost.make(value, unit);
    }

    private BCombustibleCost(double value, String unit) {
        this.value = value;
        int u = 0;
        try {
            u = unitRange.get(BCombustibleCost.makeTag(unit)).getOrdinal();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.unitEnum = BDynamicEnum.make((int)u, (BEnumRange)unitRange);
    }

    @Override
    String getDataTypeName() {
        return "combustible cost";
    }

    @Override
    public double[] getUnits() {
        return units;
    }

    @Override
    public BDynamicEnum getUnitsEnum() {
        return this.unitEnum;
    }

    @Override
    public BAbstractUnitEnum decode(String value, String unit) {
        double d;
        if (value.equals("+inf")) {
            d = Double.POSITIVE_INFINITY;
        }
        if (value.equals("-inf")) {
            d = Double.NEGATIVE_INFINITY;
        }
        if (value.equals("nan")) {
            d = Double.NaN;
        }
        double r = Double.parseDouble(value);
        return BCombustibleCost.make(r, unit);
    }

    @Override
    public Type getType() {
        return TYPE;
    }
}

